package com.cku.restful.v1.handler.service;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.handler.dao.HandlerQualificationCertificateDao;
import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.cku.oa.handler.entity.HandlerRegister;
import com.cku.oa.handler.entity.HandlerShow;
import com.cku.oa.handler.service.HandlerShowService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.handler.model.RestHandlerRegister;
import com.cku.restful.v1.handler.model.RestHandlerShow;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import jdk.nashorn.internal.runtime.logging.Logger;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.*;


@Service
@Logger
public class RestHandlerQualificationCertificateService {
    @Autowired
    private HandlerQualificationCertificateDao dao;

    @Autowired
    private HandlerShowService handlerShowService;

    private static final String PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_A = "handler_qualification_certificate@partnerDogA";
    private static final String PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_B = "handler_qualification_certificate@partnerDogB";
    private static final String PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_C = "handler_qualification_certificate@partnerDogC";
    private static final String PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_M = "handler_qualification_certificate@partnerDogM";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


    /**
     * app查询资格证书列表
     * @param request
     * @return
     */
    public RESTResponse selectTrainerCertificateListByApp(HttpServletRequest request){
        Member member = UserUtils.getLoginMember();
        // 获取参数
        String pageNo = request.getParameter("pageNo");
        String pageSize = request.getParameter("pageSize");
        // 参数校验
        int pageNoInt = 1;
        int pageSizeInt = 10;
        try {
            if (StringUtils.isNotBlank(pageNo)) {
                pageNoInt = Integer.parseInt(pageNo);
            }
            if (StringUtils.isNotBlank(pageSize)) {
                pageSizeInt = Integer.parseInt(pageSize);
            }
        } catch (Exception e) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
        }
        HandlerQualificationCertificate handlerQualificationCertificate = new HandlerQualificationCertificate();
        // 设置分页参数
        Page<HandlerRegister> page = new Page<HandlerRegister>();
        page.setPageNo(pageNoInt);
        page.setPageSize(pageSizeInt);
        // 设置查询条件
        String memberCode = member.getMemberCode();
        handlerQualificationCertificate.setMemberCode(memberCode);
        List<HandlerQualificationCertificate> handlerQualificationCertificates = dao.selectTrainerCertificateListByApp(handlerQualificationCertificate);

        List<RestHandlerRegister> list = new ArrayList<RestHandlerRegister>();
        for (HandlerQualificationCertificate qualificationCertificate : handlerQualificationCertificates) {
            RestHandlerRegister vo = new RestHandlerRegister();
            RestHandlerShow restHandlerShow = new RestHandlerShow();
            HandlerRegister handlerRegister = qualificationCertificate.getHandlerRegister();
            BeanUtil.copyProperties(vo, handlerRegister, "yyyy-MM-dd HH:mm");
            vo.setGender(DictUtils.getDictLabel(handlerRegister.getGender(), "user_gender", ""));
            vo.setShowLevel(DictUtils.getDictLabel(qualificationCertificate.getCertificateLevelEn(), "groomer_test_level", ""));
            vo.setGrade(DictUtils.getDictLabel(handlerRegister.getGrade(), "handler_grade", ""));
            vo.setPaymentState(qualificationCertificate.getPaymentState());
            String levelEn = qualificationCertificate.getCertificateLevelEn();
            String shortName = "";
            HandlerShow show = handlerShowService.getShow(handlerRegister.getShowCode());
            if (Objects.isNull(show)) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无此活动！");
            }

            if ("12".equals(show.getShowType())) {
                if ("A".equals(levelEn)) {
                    shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_A;
                } else if ("B".equals(levelEn)) {
                    shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_B;
                } else if ("C".equals(levelEn)) {
                    shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_C;
                } else if ("MASTER".equals(levelEn)) {
                    shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_M;
                }
                vo.setShortName(shortName);
            }
            String handlerShowName = StringEscapeUtils.unescapeHtml4(show.getShowName());
            restHandlerShow.setShowName(handlerShowName);
            restHandlerShow.setShowAddress(handlerShowName);
            dateFormat.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));// 设置成东八区时间
            //机器时间
            restHandlerShow.setCurrentTime(dateFormat.format(new Date()));
            vo.setRestHandlerShow(restHandlerShow);
            list.add(vo);
        }
        long count = list.size();
        return new RESTResponse("list", new PageBeanResult<RestHandlerRegister>(list, count));
    }

}
