package com.cku.restful.v1.groomer.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;

import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.constant.Constants;
import com.cku.oa.groomer.entity.*;
import com.cku.oa.groomer.enums.*;
import com.cku.oa.groomer.service.*;
import com.cku.util.DateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ListResultDto;
import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.groomer.dao.GroomerQualificationCertificateDao;
import com.cku.oa.groomer.dao.GroomerShowDao;
import com.cku.oa.groomer.utils.GroomerUtil;
import com.cku.oa.groomer.vo.GroomerRegisterVO;
import com.cku.oa.groomer.vo.GroomerShowBreedsGroupVO;
import com.cku.oa.groomer.vo.GroomerShowBreedsNumVO;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberActivity20201212Discount;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.restful.v1.groomer.model.RestGroomerRegister;
import com.cku.restful.v1.groomer.model.RestGroomerShow;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 * 美容师报名表Service
 *
 * @author cxt
 * @version 2016-07-14
 */
@Service
@Transactional(readOnly = true)

public class RestGroomerRegisterService {

    public static final String PAYMENTCHARGINGITEM_SHORTNAME_EXAM = "groomer_register@10";// 考试收费项
    public static final String PAYMENTCHARGINGITEM_SHORTNAME_MATCH = "groomer_register@11";// 讲座收费项
    public static final String PAYMENTCHARGINGITEM_SHORTNAME_MATCHS = "groomer_register@12";// 比赛收费项
    public static final String PAYMENTCHARGINGITEM_SHORTNAME_INTER = "groomer_register@Inter";// 国际费项
    public static final String PAYMENTCHARGINGITEM_SHORTNAME_PET = "groomer_register@Pet";// 宠物费项
    public static final String PAYMENTCHARGINGITEM_SHORTNAME_NURSE_EXAM = "groomer_register@nurse_exam";// 国际宠物洗护师考试报名费
    public static final String PAYMENTCHARGINGITEM_SHORTNAME_NURSE_MATCH = "groomer_register@nurse_match";// 国际宠物洗护师大赛报名费
    public static final String PAYMENTCHARGINGITEM_SHORTNAME_A = "groomer_qualification_certificate@A";// 其他收费项
    public static final String PAYMENTCHARGINGITEM_SHORTNAME_B = "groomer_qualification_certificate@B";// 其他收费项
    public static final String PAYMENTCHARGINGITEM_SHORTNAME_C = "groomer_qualification_certificate@C";// 其他收费项
    public static final String PAYMENTCHARGINGITEM_SHORTNAME_M = "groomer_qualification_certificate@M";// 其他收费项
    public static final String PAYMENTCHARGINGITEM_SHORTNAME_I = "groomer_qualification_certificate@I";// 国际宠物美容师
    public static final String PAYMENTCHARGINGITEM_SHORTNAME_NURSE = "groomer_qualification_certificate@nurse";// 国际宠物洗护师证书费
    public static final String PAYMENTCHARGINGITEM_SHORTNAME_NURSE_MAKE = "groomer_qualification_certificate@nurse_make";// 国际宠物洗护师证书制作费
    public static final String Groomer_RESERVE = "sys_member@GR";// 预备会员
    public static final String Groomer_FORMAL = "sys_member@GF";// 正式会员
    public static final String GROOMER_ABC = "300"; // ABC级报名费
    public static final String GROOMER_MASTER = "500";// 教师级报名费

    /**
     * Fci增发美容资格证书A级
     */
    public static final String FCI_GROOMER_QUALIFICATION_CERTIFICATE_A = "fci_groomer_qualification_certificate@A";

    /**
     * Fci增发美容资格证书B级
     */
    public static final String FCI_GROOMER_QUALIFICATION_CERTIFICATE_B = "fci_groomer_qualification_certificate@B";

    /**
     * Fci增发美容资格证书C级
     */
    public static final String FCI_GROOMER_QUALIFICATION_CERTIFICATE_C = "fci_groomer_qualification_certificate@C";

    /**
     * Fci增发美容资格证书教师级级
     */
    public static final String FCI_GROOMER_QUALIFICATION_CERTIFICATE_MASTER = "fci_groomer_qualification_certificate@M";

    /**
     * FCI美容资格证书A级
     */
    public static final String FCI_GROOMER_QUALIFICATION_CERTIFICATE_A_LEVEL = "fci_groomer_qualification_certificate@A_NEW";

    /**
     * FCI美容资格证书B级
     */
    public static final String FCI_GROOMER_QUALIFICATION_CERTIFICATE_B_LEVEL = "fci_groomer_qualification_certificate@B_NEW";

    /**
     * FCI美容资格证书C级
     */
    public static final String FCI_GROOMER_QUALIFICATION_CERTIFICATE_C_LEVEL = "fci_groomer_qualification_certificate@C_NEW";

    /**
     * Fci活动报名费用
     */
    public static final String GROOMER_REGISTER_FCI_FEE = "groomer_register@fci_fee";

    /**
     * 宠物造型师资格认证书
     */
    public static final String GROOMER_QUALIFICATION_CERTIFICATE_PET = "groomer_qualification_certificate@PET";

    /**
     * 猫洗护师
     */
    public static final String GROOMER_CAT_NURSE_PRIMARY_LEVEL = "300"; //宠物级
    public static final String GROOMER_CAT_NURSE_PROFESSIONAL_LEVEL = "300"; //宠物级
    public static final String GROOMER_CAT_NURSE_MASTER = "500";// 教师级

    /**
     * 伴侣猫洗护师资格证书宠物级
     */
    public static final String GROOMER_QUALIFICATION_CERTIFICATE_CAT_NURSE_PRIMARY = "groomer_qualification_certificate@CAT_PRIMARY";

    /**
     * 伴侣猫洗护师资格证书专业级
     */
    public static final String GROOMER_QUALIFICATION_CERTIFICATE_CAT_NURSE_PROFESSIONAL = "groomer_qualification_certificate@CAT_PROFESSIONAL";

    /**
     * 伴侣猫洗护师资格证书教师级
     */
    public static final String GROOMER_QUALIFICATION_CERTIFICATE_CAT_NURSE_MASTER = "groomer_qualification_certificate@CAT_MASTER";



    @Autowired
    public GroomerRegisterService groomerRegisterService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private PaymentChargingItemService paymentChargingItemService;
    @Autowired
    private PaymentCartService paymentCartService;
    @Autowired
    private PaymentOrderDetailDao paymentOrderDetailDao;
    @Autowired
    private GroomerShowDao groomerShowDao;
    @Autowired
    private GroomerQualificationCertificateService groomerQualificationCertificateService;
    @Autowired
    private GroomerQualificationCertificateDao groomerQualificationCertificateDao;
    @Autowired
    private PaymentOrderService paymentOrderService;
    @Autowired
    private MemberActivity20201212Discount memberActivity20201212Discount;
    @Autowired
    private GroomerShowBreedsService groomerShowBreedsService;

    @Autowired
    private GroomerWrittenExamInfoService groomerWrittenExamInfoService;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Autowired
    private FciGroomerQualificationCertificateService fciGroomerQualificationCertificateService;

    /**
     * 日志对象
     */
    protected Logger log = LoggerFactory.getLogger(getClass());

    @Transactional(readOnly = false)
    public RESTResponse post(String json) {
        // 获取参数
        RestGroomerRegister vo = BeanUtil.toBean(json, RestGroomerRegister.class);
        // 同步修改会员证件照为美容报名上传的图片 by zhuoHeng 2016年12月15日10:46:06
        GroomerShow groomerShow = groomerShowDao.getShowType(vo.getShowCode());
        // 参数校验
        validateParameter(vo);
        // 构造持久对象
        GroomerRegister po = buildPo(vo);
        // 业务校验
        groomerRegisterService.validateBusiness(po, groomerShow, "app");
        // 写入业务表
        groomerRegisterService.save(po);
        String avatar = po.getAvatar();

        if (!"".equals(groomerShow.getShowType()) && !"cathedra".equals(groomerShow.getShowType())) {// 讲座不进行图片修改
            Member member = UserUtils.getLoginMember();
            memberService.updateAvatar(avatar, member.getId());
        }
        // 写入购物车
        String businessOrderCode = IdGen.uuid();
        PaymentCart paymentCart = buildPaymentCart(po);
        paymentCart.setBusinessOrderCode(businessOrderCode);
        paymentCartService.addToCart(paymentCart, "1046");
        return new RESTResponse("data", paymentCart.getId());
    }

    /**
     * @description: 参数校验
     * @author: laiguanglong
     * @date: 2016年9月9日 上午9:41:47
     */
    private void validateParameter(RestGroomerRegister vo) {
        if (StringUtils.isBlank(vo.getShowCode())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "赛事编号为空");
        }

        if (StringUtils.isBlank(vo.getSchoolNameCn())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "培训学校为空");
        }
        GroomerShow groomerShow = groomerShowDao.getShowType(vo.getShowCode());
        if (!"cathedra".equals(groomerShow.getShowType())) {
            if (StringUtils.isBlank(vo.getShowDogBreed()) && StringUtils.isBlank(vo.getShowDogBreedExtra())) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "比赛犬种为空");
            }
            if (StringUtils.isBlank(vo.getShowLevel())) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参赛级别为空");
            }
            if (StringUtils.isBlank(vo.getAvatar())) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参赛照片为空");
            }

            if (!"A".equals(vo.getShowLevel()) && !"B".equals(vo.getShowLevel()) && !"C".equals(vo.getShowLevel())
                    && !"none".equals(vo.getShowLevel()) && groomerShow.getShowCategory().equals("1")) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参赛级别只能为A,B,C,无");
            }
            if (!"PRIMARY".equals(vo.getShowLevel()) && !"SENIOR".equals(vo.getShowLevel())
                    && !"MATCH".equals(vo.getShowLevel()) && "4".equals(groomerShow.getShowCategory())) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参赛级别只能为初级,高级,赛级");
            }
            if (!"PRIMARY LEVEL".equals(vo.getShowLevel()) && !"PROFESSIONAL LEVEL".equals(vo.getShowLevel())
                    && !"MASTER".equals(vo.getShowLevel()) && !"exam".equals(vo.getShowLevel()) && "8".equals(groomerShow.getShowCategory())) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参赛级别只能为宠物级,专业级,教师级");
            }
        }
        Member member = UserUtils.getLoginMember();
        // 洗护师犬种校验
        if ("4".equals(groomerShow.getShowCategory())) {
            // 过滤犬种无效字符
            StringBuilder showDogBreed = new StringBuilder();
            if (StringUtils.isNotBlank(vo.getShowDogBreedExtra())) {
                Arrays.asList(vo.getShowDogBreedExtra().split(",")).stream().forEach(a -> {
                    if (StringUtils.isNotBlank((String) a))
                        showDogBreed.append((String) a).append(",");
                });
            }
            vo.setShowDogBreedExtra(showDogBreed.length() > 0
                    ? showDogBreed.toString().substring(0, showDogBreed.toString().length() - 1)
                    : null);
            // 银卡及银卡以上会员才可报名
            if (!(member.getMemberEndDate() != null && member.getMemberEndDate().after(new Date())
                    || member.getGroomerEndDate() != null && member.getGroomerEndDate().after(new Date()))) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "有效爱宠银卡及以上会员或者美容会员才可办理!");
            }
        }
    }

    /**
     * @description: 构造持久对象
     * @author: laiguanglong
     * @date: 2016年9月13日 下午5:56:52
     */
    private GroomerRegister buildPo(RestGroomerRegister vo) {
        Member member = UserUtils.getLoginMember();
        GroomerShow groomerShow = groomerShowDao.getShowType(vo.getShowCode());
        String shortName = "";
        if ("1".equals(groomerShow.getShowCategory())) {
            if ("exam".equals(groomerShow.getShowType())) {// 考试
                shortName = PAYMENTCHARGINGITEM_SHORTNAME_EXAM;
                String showLevel = vo.getShowLevel();
                if ("MASTER".equals(showLevel)) {
                    groomerShow.setFee(GROOMER_MASTER);
                } else if (!"none".equals(showLevel)) {
                    groomerShow.setFee(GROOMER_ABC);
                }
            } else if ("cathedra".equals(groomerShow.getShowType())) {// 讲座
                shortName = PAYMENTCHARGINGITEM_SHORTNAME_MATCH;
            } else {// 比赛
                shortName = PAYMENTCHARGINGITEM_SHORTNAME_MATCHS;
            }
        } else if ("2".equals(groomerShow.getShowCategory())) {
            //新收费项  需要新增
            shortName = PAYMENTCHARGINGITEM_SHORTNAME_INTER;
        } else if ("4".equals(groomerShow.getShowCategory())) {
            if ("exam".equals(groomerShow.getShowType())) {// 考试
                shortName = PAYMENTCHARGINGITEM_SHORTNAME_NURSE_EXAM;
            } else if ("match".equals(groomerShow.getShowType())) {
                shortName = PAYMENTCHARGINGITEM_SHORTNAME_NURSE_MATCH;
            }
        } else if ("7".equals(groomerShow.getShowCategory())) {
            if ("match".equals(groomerShow.getShowType())) {
                shortName = GROOMER_REGISTER_FCI_FEE;
            }
        } else if ("8".equals(groomerShow.getShowCategory())) {
            shortName = PAYMENTCHARGINGITEM_SHORTNAME_NURSE_MATCH;
            String showLevel = vo.getShowLevel();
            if ("MASTER".equals(showLevel)) {
                groomerShow.setFee(GROOMER_CAT_NURSE_MASTER);
            } else if (!"none".equals(showLevel)) {
                groomerShow.setFee(GROOMER_CAT_NURSE_PRIMARY_LEVEL);
            }

        } else {
            shortName = PAYMENTCHARGINGITEM_SHORTNAME_PET;
        }

        PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
        GroomerRegister po = new GroomerRegister();
        po.setRegisterCode(SysCodeUtil.getGroomActivitySignCode("WB"));
        po.setMemberCode(member.getMemberCode());
        po.setName(member.getName());
        po.setGender(member.getGender());
        po.setMobile(member.getMobile());
        po.setShowLevel(vo.getShowLevel());
        po.setSchoolNameCn(vo.getSchoolNameCn());
        po.setFee(groomerShow.getFee());
        po.setShowLeave("0");
        po.setLeaveCancel("0");
        po.setOrderPrice(groomerShow.getFee());
        po.setPaymentMemberCode(member.getMemberCode());
        po.setPaymentChargingItemId(paymentChargingItem.getId());
        po.setShowDogBreed(vo.getShowDogBreed());
        po.setShowDogBreedExtra(vo.getShowDogBreedExtra());
        po.setReviewState("0");
        po.setPaymentState("1");
        po.setProccessState("0");
        po.setAvatar(vo.getAvatar());
        po.setShowCode(groomerShow.getShowCode());
        return po;
    }

    private PaymentCart buildPaymentCart(GroomerRegister po) {
        PaymentCart paymentCart = new PaymentCart();
        PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(po.getPaymentChargingItemId());
        paymentCart.setChargingItemId(paymentChargingItem.getId());
        paymentCart.setChargingItemName(paymentChargingItem.getName());
        paymentCart.setNum("1");
        paymentCart.setPrice(po.getFee());
        paymentCart.setTotalPrice(po.getFee());
        paymentCart.setBusinessTable("groomer_register");
        paymentCart.setBusinessIds(po.getId());
        return paymentCartService.addBusinessManage(paymentCart, "1046");// 所属业务类型
    }

    /**
     * 报名校验
     *
     * @Author chaixueteng
     * @2016年9月22日下午2:48:17
     */
    public RESTResponse apply(HttpServletRequest request) {
        Member member = UserUtils.getLoginMember();
        String showCode = request.getParameter("show_code");
        Map<String, Object> memberMessage = groomerRegisterService.getMemberMessageByWeb(member.getMemberCode(),
                showCode);
        return new RESTResponse("data", JSONObject.fromObject(memberMessage));
    }

    public static Long newBusinessTimeMillis = null;

    static {
        try {
            newBusinessTimeMillis = new SimpleDateFormat("yyyy-MM-dd").parse("2019-06-01").getTime();
        } catch (ParseException e) {
            System.out.println("资格证书在线申领列表格式化时间出错");
        }
    }

    /**
     * 资格证书在线申领列表
     *
     * @Author chaixueteng
     * @2016年9月22日下午3:32:09
     */
    public RESTResponse certificateList(HttpServletRequest request) {
        Member member = UserUtils.getLoginMember();
        // 获取参数
        String pageNo = request.getParameter("pageNo");
        String pageSize = request.getParameter("pageSize");
        // 参数校验
        int pageNoInt = 1;
        int pageSizeInt = 10;
        try {
            if (StringUtils.isNotBlank(pageNo)) {
                pageNoInt = Integer.parseInt(pageNo);
            }
            if (StringUtils.isNotBlank(pageSize)) {
                pageSizeInt = Integer.parseInt(pageSize);
            }
        } catch (Exception e) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
        }
        GroomerRegister register = new GroomerRegister();
        // 设置分页参数
        Page<GroomerRegister> page = new Page<GroomerRegister>();
        page.setPageNo(pageNoInt);
        page.setPageSize(pageSizeInt);
        // 设置查询条件
        String memberCode = member.getMemberCode();
        register.setMemberCode(memberCode);
        GroomerShow groomerShow = new GroomerShow();
        register.setGroomerShow(groomerShow);
        register.setDelFlag("0");
        register.setPage(page);

        List<GroomerRegister> groomerRegisters = groomerQualificationCertificateService.queryCertificateList(memberCode, (pageNoInt - 1) * pageSizeInt, pageSizeInt);

        // 领取资格证书（成绩为通过且同级别只显示一条）
        /*Page<GroomerRegister> result = groomerRegisterService.findListWrite(page, register);
        List<GroomerRegister> findList = result.getList();*/
        List<RestGroomerRegister> list = new ArrayList<RestGroomerRegister>();
        for (GroomerRegister groomerRegister : groomerRegisters) {
            RestGroomerRegister vo = getGroomerRegister(groomerRegister);
            if (vo != null) {
                list.add(vo);
            }
        }
        long count = list.size();
        return new RESTResponse("list", new PageBeanResult<RestGroomerRegister>(list, count));
    }

    public RestGroomerRegister getGroomerRegister(GroomerRegister groomerRegister) {
        RestGroomerRegister vo = new RestGroomerRegister();
        RestGroomerShow show = new RestGroomerShow();
        BeanUtil.copyProperties(vo, groomerRegister, "yyyy-MM-dd HH:mm");
        vo.setGender(DictUtils.getDictLabel(groomerRegister.getMember().getGender(), "user_gender", ""));
        vo.setShowLevel(DictUtils.getDictLabel(vo.getShowLevel(), "groomer_test_level", ""));
        /*vo.setShowLevel("SENIOR".equals(vo.getShowLevel()) ? "高级" :
                ("MATCH".equals(vo.getShowLevel()) ? "赛级" : ("PRIMARY".equals(vo.getShowLevel()) ? "初级" : vo.getShowLevel())));*/
        vo.setGrade(DictUtils.getDictLabel(groomerRegister.getGrade(), "Grade", ""));
        vo.setLevelCn(GroomerUtil.getLevelCn(groomerRegister.getGroomerQualificationCertificate().getLevelEn()));
        if (StringUtils.isNotBlank(groomerRegister.getShowDogBreedExtra())) {
            vo.setShowDogBreed(StringUtils.isNotBlank(vo.getShowDogBreed()) ?
                    vo.getShowDogBreed() + "," + groomerRegister.getShowDogBreedExtra() : groomerRegister.getShowDogBreedExtra());
        }
        /*if ("1".equals(groomerRegister.getGroomerShow().getShowCategory())) {
            String showCode = groomerRegister.getShowCode().split("-")[0].substring(0, 6);
            if (Integer.parseInt(showCode) >= 201913) {// 截至201913以后的赛事必须成绩、笔试成绩通过才可显示
                vo.setHistorySwitch(Constants.NUM_ONE);
            } else {
                vo.setHistorySwitch(Constants.NUM_ZERO);
            }
        }*/
        /*GroomerQualificationCertificate gqc = groomerQualificationCertificateDao
                .getRegisterById(groomerRegister.getGroomerQualificationCertificate().getId());*/
        GroomerQualificationCertificate gqc = groomerRegister.getGroomerQualificationCertificate();

        if (gqc == null) {// 未通过 缺考的不生资格证书 这类的只展示考试信息
			vo.setPaymentState("3");
		} else {
			vo.setPaymentState(gqc.getPaymentState());
            vo.setQualificationCertificateType(gqc.getQualificationCertificateType());
		}
		if (groomerRegister.getGroomerShow() != null) {
			show.setShowName(groomerRegister.getGroomerShow().getShowName());
			show.setShowAddress(groomerRegister.getGroomerShow().getShowAddress());
			show.setEndTime(groomerRegister.getGroomerShow().getEndTime());
            show.setShowCategory(groomerRegister.getGroomerShow().getShowCategory());
		    dateFormat.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));// 设置成东八区时间
			//机器时间
			show.setCurrentTime(dateFormat.format(new Date()));
		}
		vo.setRestGroomerShow(show);
		if(gqc!=null){
			vo.setIsFree(gqc.getIsFree());
            if (QualificationCertificateTypeEnum.CKU_QUALIFICATION_CERTIFICATE.code()
                    .equals(gqc.getQualificationCertificateType())) {
                if("3".equals(gqc.getCertificateType())){
                    vo.setShowCategory("宠物造型师资格证书");
                }else if("2".equals(gqc.getCertificateType())){
                    vo.setShowCategory("国际宠物美容师资格证书");
                }else if("4".equals(gqc.getCertificateType())) {
                    vo.setShowCategory("CKU国际宠物洗护师（纸质版）");
                } else if("1".equals(gqc.getCertificateType())){
                    vo.setShowCategory("CKU美容师资格证书");
                } else if("6".equals(gqc.getCertificateType())){
                    vo.setShowCategory("派多格资格证书");
                } else if("8".equals(gqc.getCertificateType())){
                    vo.setShowCategory("伴侣猫洗护师资格证书");
                }
            } else if (QualificationCertificateTypeEnum.FCI_QUALIFICATION_CERTIFICATE.code()
                    .equals(gqc.getQualificationCertificateType())) {
                if ("5".equals(gqc.getCertificateType())){
                    vo.setShowCategory("FCI增发美容师资格证书");
                } else if ("7".equals(gqc.getCertificateType())){
                    vo.setShowCategory("FCI美容师资格证书");
                }
            }

            //收费项名称shortName
			String levelEn = gqc.getLevelEn();
			String shortName = "";
			//资格证书
			if("1".equals(gqc.getCertificateType())){
				if ("A".equals(levelEn)) {
					shortName = PAYMENTCHARGINGITEM_SHORTNAME_A;
				} else if ("B".equals(levelEn)) {
					shortName = PAYMENTCHARGINGITEM_SHORTNAME_B;
				} else if ("C".equals(levelEn)) {
					shortName = PAYMENTCHARGINGITEM_SHORTNAME_C;
				} else if ("MASTER".equals(levelEn)) {
					shortName = PAYMENTCHARGINGITEM_SHORTNAME_M;
				}
			} else if ("4".equals(gqc.getCertificateType())) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_NURSE;
			} else if ("5".equals(gqc.getCertificateType())) {
                if ("A".equals(levelEn)) {
                    shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_A;
                } else if ("B".equals(levelEn)) {
                    shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_B;
                } else if ("C".equals(levelEn)) {
                    shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_C;
                } else if ("MASTER".equals(levelEn)) {
                    shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_MASTER;
                }
            } else if ("7".equals(gqc.getCertificateType())) {
                if ("A".equals(levelEn)) {
                    shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_A_LEVEL;
                } else if ("B".equals(levelEn)) {
                    shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_B_LEVEL;
                } else if ("C".equals(levelEn)) {
                    shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_C_LEVEL;
                } /*else if ("MASTER".equals(levelEn)) {
                    shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_MASTER;
                }*/
            } else if ("3".equals(gqc.getCertificateType())) {
                shortName = GROOMER_QUALIFICATION_CERTIFICATE_PET;
            } else if ("8".equals(gqc.getCertificateType())) {
                if ("PRIMARY LEVEL".equals(levelEn)) {
                    shortName = GROOMER_QUALIFICATION_CERTIFICATE_CAT_NURSE_PRIMARY;
                } else if ("PROFESSIONAL LEVEL".equals(levelEn)) {
                    shortName = GROOMER_QUALIFICATION_CERTIFICATE_CAT_NURSE_PROFESSIONAL;
                } else if ("MASTER".equals(levelEn)) {
                    shortName = GROOMER_QUALIFICATION_CERTIFICATE_CAT_NURSE_MASTER;
                }
            } else {
                if ("国际宠物美容师".equals(levelEn)) {
                    shortName = PAYMENTCHARGINGITEM_SHORTNAME_I;
                }
            }
			vo.setShortName(shortName);
		}

        //更新成证书id
        vo.setId(groomerRegister.getGroomerQualificationCertificate().getId());
        if (!vo.getShowCode().endsWith("ND")) {
            return vo;
        }
        return null;
    }

    /**
     * 资格证书在线申领
     *
     * @Author chaixueteng
     * @2016年9月29日下午3:58:07
     */
    @SuppressWarnings("unused")
    @Transactional(readOnly = false)
    public RESTResponse receiveCertificateFree(String id) {
        Member member = UserUtils.getLoginMember();
        if (!MemberUtil.isActiveMember(member)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员无效！");
        }
        GroomerQualificationCertificate gqc = groomerQualificationCertificateDao.getRegisterById(id);
        if (gqc == null) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无证书!");
        } else if ("2".equals(gqc.getPaymentState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书已经申领,请勿重复申领!");
        }
        //调整免费申请规则：付费申请缴费未退款状态下才可以申请
        GroomerQualificationCertificate payGqc = groomerQualificationCertificateDao.getRegisterIdForPay(gqc.getRegisterId());
        if (payGqc != null && !"2".equals(payGqc.getPaymentState())) {
            String[] strs = {"A", "B", "C", "", "MASTER", "M", "教师级"};
            List<String> list = Arrays.asList(strs);
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请先完成" + (list.contains(payGqc.getLevelCn()) ? "美容师资格认证" : payGqc.getLevelCn()) + "申请，并缴费完成后进行免费申请!");
        }

        //暂时关闭国际高级宠物美容师证书的申领
//		if("国际高级宠物美容师".equals(gqc.getLevelEn())){
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "暂时关闭国际高级宠物美容师证书的申领");
//		}

        //判断同类型证书
        List<GroomerQualificationCertificate> groomerQualificationCertificates = groomerQualificationCertificateDao.eqCertificatepay(member.getMemberCode(), gqc.getLevelEn(), gqc.getCertificateType());
        if (groomerQualificationCertificates.size() > 0) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已经申领过该类型的证书，无需申领!");
        }
        GroomerRegister groomerRegister = groomerRegisterService.get(gqc.getRegisterId());
        if (groomerRegister == null) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "报名信息异常!");
        }
        //修改支付状态
        groomerQualificationCertificateDao.updatePayment(gqc);
        //更改申领状态
        groomerQualificationCertificateDao.updateCertificateState(id);
        return new RESTResponse();
    }

    /**
     * 资格证书在线申领
     *
     * @Author chaixueteng
     * @2016年9月29日下午3:58:07
     */
    @SuppressWarnings("unused")
    @Transactional(readOnly = false)
    public RESTResponse receiveCertificate(String id, String qualificationCertificateType) {
        Member member = UserUtils.getLoginMember();
        if (!MemberUtil.isActiveMember(member)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员无效！");
        }
        if (StringUtils.isBlank(qualificationCertificateType)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请传入证书类型！");
        }
        GroomerQualificationCertificate gqc;

        if (Objects.equals(qualificationCertificateType, Constants.STRING_NUM_TWO)) {
            FciGroomerQualificationCertificate fciGroomerQualificationCertificate = fciGroomerQualificationCertificateService.get(id);
            if (Objects.isNull(fciGroomerQualificationCertificate)) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "申领FCI证书出现错误，请联系相关人员!");
            }
            //GroomerQualificationCertificate registerById = groomerQualificationCertificateDao.getRegisterById(fciGroomerQualificationCertificate.getCertificateId());
            gqc = new GroomerQualificationCertificate();
            gqc.setId(fciGroomerQualificationCertificate.getId());
            gqc.setLevelCn(fciGroomerQualificationCertificate.getLevelEn());
            gqc.setLevelEn(fciGroomerQualificationCertificate.getLevelEn());
            gqc.setPaymentState(fciGroomerQualificationCertificate.getPaymentState());
            gqc.setIsFree("1");
            gqc.setCertificateType(fciGroomerQualificationCertificate.getCertificateType());
            gqc.setRegisterId(fciGroomerQualificationCertificate.getRegisterId());

        } else {
            gqc = groomerQualificationCertificateDao.getRegisterById(id);
        }

        if (gqc == null) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无此证书!");
        } else if ("2".equals(gqc.getPaymentState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此证书已经申领,请勿重复申领!");
        }
        GroomerRegister groomerRegister = groomerRegisterService.get(gqc.getRegisterId());
        //判断是否是免费申领，兼容IOS
        if ("0".equals(gqc.getIsFree())) {
            receiveCertificateFree(id);
            //throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, );
            RESTResponse data = new RESTResponse();
            data.setRc(-1);
            data.setMsg("证书申领成功!");
            return data;
        }
        // 加入购物车
        String levelEn = gqc.getLevelEn();
        String shortName = "";
        //资格证书
        if ("1".equals(gqc.getCertificateType())) {
            if ("MASTER".equals(gqc.getLevelEn())) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "教师级请联系业务部门办理申领!");
            }
            if (groomerRegister != null) {
                Date endTime = groomerRegister.getGroomerShow().getEndTime();
                Calendar calendar = Calendar.getInstance();// 日历对象
                calendar.setTime(endTime);// 设置当前日期
                calendar.add(Calendar.DATE, 61);// 天数+61 17年实行61天制
                long timeInMillis = calendar.getTimeInMillis();
                long time = new Date().getTime();
                if (timeInMillis < time) {// 超过61未申领 资格证书为过期
                    throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此证书已经过期,请联系业务部门处理!");
                }
            } else {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "报名信息异常!");
            }
            if ("A".equals(levelEn)) {
                shortName = PAYMENTCHARGINGITEM_SHORTNAME_A;
            } else if ("B".equals(levelEn)) {
                shortName = PAYMENTCHARGINGITEM_SHORTNAME_B;
            } else if ("C".equals(levelEn)) {
                shortName = PAYMENTCHARGINGITEM_SHORTNAME_C;
            } else if ("MASTER".equals(levelEn)) {
                shortName = PAYMENTCHARGINGITEM_SHORTNAME_M;
            }
        } else if ("4".equals(gqc.getCertificateType())) {
            shortName = PAYMENTCHARGINGITEM_SHORTNAME_NURSE;
        } else if ("5".equals(gqc.getCertificateType())) {
            if ("A".equals(levelEn)) {
                shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_A;
            } else if ("B".equals(levelEn)) {
                shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_B;
            } else if ("C".equals(levelEn)) {
                shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_C;
            } else if ("MASTER".equals(levelEn)) {
                shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_MASTER;
            }
        } else if ("6".equals(gqc.getCertificateType())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请联系CKU工作人员!");
        } else if ("7".equals(gqc.getCertificateType())) {
            if (groomerRegister != null) {
                Date endTime = groomerRegister.getGroomerShow().getEndTime();
                Calendar calendar = Calendar.getInstance();// 日历对象
                calendar.setTime(endTime);// 设置当前日期
                calendar.add(Calendar.DATE, 61);// 天数+61 17年实行61天制
                long timeInMillis = calendar.getTimeInMillis();
                long time = new Date().getTime();
                if (timeInMillis < time) {// 超过61未申领 资格证书为过期
                    throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此证书已经过期,请联系业务部门处理!");
                }
            } else {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "报名信息异常!");
            }
            if ("A".equals(levelEn)) {
                shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_A_LEVEL;
            } else if ("B".equals(levelEn)) {
                shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_B_LEVEL;
            } else if ("C".equals(levelEn)) {
                shortName = FCI_GROOMER_QUALIFICATION_CERTIFICATE_C_LEVEL;
            }
        } else if ("3".equals(gqc.getCertificateType())) {
            //判断同类型证书
            List<GroomerQualificationCertificate> groomerQualificationCertificates = groomerQualificationCertificateDao.eqCertificatepay(member.getMemberCode(), gqc.getLevelEn(), "3");
            if (groomerQualificationCertificates.size() > 0) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已经申领过该类型的证书，无需申领!");
            }
            shortName = GROOMER_QUALIFICATION_CERTIFICATE_PET;
        } else if ("8".equals(gqc.getCertificateType())) {
            //判断同类型证书
            List<GroomerQualificationCertificate> groomerQualificationCertificates = groomerQualificationCertificateDao.eqCertificatepay(member.getMemberCode(), gqc.getLevelEn(), "8");
            if (!groomerQualificationCertificates.isEmpty()) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已经申领过该类型的证书，无需申领!");
            }
            if ("PRIMARY LEVEL".equals(levelEn)) {
                shortName = GROOMER_QUALIFICATION_CERTIFICATE_CAT_NURSE_PRIMARY;
            } else if ("PROFESSIONAL LEVEL".equals(levelEn)) {
                shortName = GROOMER_QUALIFICATION_CERTIFICATE_CAT_NURSE_PROFESSIONAL;
            } else if ("MASTER".equals(levelEn)) {
                shortName = GROOMER_QUALIFICATION_CERTIFICATE_CAT_NURSE_MASTER;
            }
        } else {
            //判断同类型证书
            List<GroomerQualificationCertificate> groomerQualificationCertificates = groomerQualificationCertificateDao.eqCertificatepay(member.getMemberCode(), gqc.getLevelEn(), gqc.getCertificateType());
            if (groomerQualificationCertificates.size() > 0) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已经申领过该类型的证书，无需申领!");
            }
            if ("国际宠物美容师".equals(levelEn)) {
                shortName = PAYMENTCHARGINGITEM_SHORTNAME_I;
            }

        }
        log.info("--------------收费项Name-------------: {}", shortName);
        List<PaymentCart> paymentCartList = paymentCartService.getMyCart(true);
        PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
        log.info("--------------paymentChargingItem-------------: {}", shortName);
        for (PaymentCart paymentCart : paymentCartList) {
            if (paymentChargingItem.getId().equals(paymentCart.getChargingItemId())) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "购物车已有订单，请勿重复提交");
            }
        }
        PaymentOrderDetail paymentOrderDetail = new PaymentOrderDetail();
        paymentOrderDetail.setMemberCode(member.getMemberCode());
        paymentOrderDetail.setChargingItemId(paymentChargingItem.getId());
        //洗护师需要关联证书表进行重复订单验证
        List<PaymentOrderDetail> validOrder = null;
        if ("4".equals(gqc.getCertificateType())) {
            validOrder = paymentOrderDetailDao.validOrderNurse(member.getMemberCode(), paymentChargingItem.getId(), levelEn);
        } else {
            validOrder = paymentOrderDetailDao.validOrder(paymentOrderDetail);
        }
        if (validOrder.size() > 0) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已有订单，请勿重复提交");
        }
        PaymentCart paymentCart = new PaymentCart();
        //收费项更新

        paymentCart.setChargingItemId(paymentChargingItem.getId());
        paymentCart.setChargingItemName(paymentChargingItem.getName());
        paymentCart.setNum("1");
        paymentCart.setPrice(paymentChargingItem.getPrice());
        paymentCart.setTotalPrice(paymentChargingItem.getPrice());
        paymentCart.setBusinessTable(Objects.equals(qualificationCertificateType, Constants.STRING_NUM_TWO) ? "fci_groomer_qualification_certificate" : "groomer_qualification_certificate");
        paymentCart.setBusinessIds(gqc.getId());
        if (Objects.equals(qualificationCertificateType, Constants.STRING_NUM_TWO)) {
            // 添加购物车
            paymentCartService.addToCart(paymentCart, "1207"); // 美容师资格证书领取
            //更改申领状态
            fciGroomerQualificationCertificateService.updateFciCertificateState(id);

        } else {
            // 添加购物车
            paymentCartService.addToCart(paymentCart, "1048"); // 美容师资格证书领取
            //更改申领状态
            groomerQualificationCertificateDao.updateCertificateState(id);
        }

        return new RESTResponse("data", paymentCart.getId());
    }

    /**
     * @description: 美容师续费
     * @author: laiguanglong
     * @date: 2016年10月12日 上午11:52:08
     */
    @Transactional(readOnly = false)
    public RESTResponse renew() {
        Member po = UserUtils.getLoginMember();
        if (po == null) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录用户信息为空，请登录");
        }
        if (StringUtils.isBlank(po.getGroomerType())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员不是美容师，不能进行美容师续费");
        }
        String shortName = null;
        if ("reserve".equals(po.getGroomerType())) {
            shortName = Groomer_RESERVE;
        } else if ("formal".equals(po.getGroomerType())) {
            shortName = Groomer_FORMAL;
        }
        // 业务查重
        List<PaymentCart> paymentCartList = paymentCartService.getMyCart(false);
        PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
        for (PaymentCart paymentCart : paymentCartList) {
            if (paymentChargingItem.getId().equals(paymentCart.getChargingItemId())) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "购物车已有美容师续费订单，请勿重复提交");
            }
        }
        // 续费
        PaymentCart typePaymentCart = buildPaymentCart(po, shortName);
        paymentCartService.addToCart(typePaymentCart, false, "1045"); // 会员续费

        Map<String, String> data = new HashMap<>();
        data.put("id", typePaymentCart.getId());
        // 20201212优惠 在活动时间内才能计入优惠
        if (!LocalDate.now().isBefore(LocalDate.parse(MemberActivity20201212Discount.yearEndPromotion2020Start))
                && !LocalDate.now().isAfter(LocalDate.parse(MemberActivity20201212Discount.yearEndPromotion2020End))) {
            if (memberActivity20201212Discount.isFirst20201212GroomerActivityRecord(po.getMemberCode())) {
                if ("reserve".equals(po.getGroomerType())) {
                    data.put("discountExplain", null);// 优惠文案
                    data.put("giveExplain", "预备美容师会员续费赠送2个月权益");// 赠送文案
                } else if ("formal".equals(po.getGroomerType())) {
                    data.put("discountExplain", null);// 优惠文案
                    data.put("giveExplain", "正式美容师会员续费赠送2个月权益");// 赠送文案
                }
            }
        }
        return new RESTResponse("data", data);
    }

    // 美容师续费加入购物车
    private PaymentCart buildPaymentCart(Member po, String shortName) {
        PaymentCart paymentCart = new PaymentCart();
        PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
        paymentCart.setChargingItemId(paymentChargingItem.getId());
        paymentCart.setChargingItemName(paymentChargingItem.getName());
        paymentCart.setNum("1");
        paymentCart.setPrice(paymentChargingItem.getPrice());
        paymentCart.setTotalPrice(paymentChargingItem.getPrice());
        paymentCart.setBusinessTable("sys_member");
        //续费优惠添加
        paymentCart.setBusinessOrderCode(IdGen.uuid() + "8088811");
        paymentCart.setBusinessIds(po.getId());
        return paymentCart;
    }

    /**
     * @Description：获取培训报名历史数据
     * @author: zhuoHeng
     * @version: 2016年12月14日 上午11:06:40
     */
    public RESTResponse getGroomerRegister(HttpServletRequest request) {
        Member member = UserUtils.getLoginMember();
        List<RestGroomerRegister> restList = new ArrayList<RestGroomerRegister>();
        log.info("RestGroomerRegisterService.getGroomerRegister member ： {}", JSONObjectUtils.toJsonString(member));
        if (member != null) {
            List<GroomerRegister> list = groomerRegisterService.getGroomerRegister(member.getMemberCode());
            if (CollectionUtils.isEmpty(list)) {
                return new RESTResponse("list", restList);
            }
            List<GroomerWrittenExamInfo> groomerWrittenExamInfos = groomerWrittenExamInfoService.queryWrittenExamInfoListByMaxDate(list.stream()
                    .map(GroomerRegister::getId).collect(Collectors.toList()), member.getMemberCode());


            // 查询有没有退款或退款中 fmdog_breed_certified_code
            Map<String, String> map = paymentOrderService
                    .getRefundStateByBusinessId(list.stream().map(a -> a.getId()).collect(Collectors.toSet()));
            List<GroomerRegisterVO> list2 = list.stream().map(a -> {
                GroomerRegisterVO b = new GroomerRegisterVO();
                BeanUtils.copyProperties(a, b);
                b.setBusinessRefundState(map.keySet().contains(a.getId()));
                return b;
            }).collect(Collectors.toList());

            log.info("list2 : {}", JSONObjectUtils.toJsonString(list2));
            for (GroomerRegisterVO groomerRegister : list2) {
                RestGroomerRegister vo = new RestGroomerRegister();
                RestGroomerShow show = new RestGroomerShow();
                GroomerShow groomerShow = groomerShowDao.getShowType(groomerRegister.getShowCode());
                BeanUtil.copyProperties(vo, groomerRegister, "yyyy-MM-dd HH:mm");
                vo.setIsShowModel(false);
                vo.setGender(DictUtils.getDictLabel(groomerRegister.getGender(), "user_gender", ""));
                if ("8".equals(groomerShow.getShowCategory())) {
                    vo.setShowLevel(DictUtils.getDictLabel(groomerRegister.getShowLevel(), "groomer_cat_nurse_level", ""));
                } else {
                    vo.setShowLevel(DictUtils.getDictLabel(groomerRegister.getShowLevel(), "groomer_test_level", ""));
                }
                String grade = groomerRegister.getGrade();
                vo.setGrade(DictUtils.getDictLabel(grade, "Grade", ""));
                GroomerQualificationCertificate gqc = groomerQualificationCertificateService
                        .getRegister(groomerRegister.getId());
                if (gqc == null) {
                    vo.setPaymentState("2");
                } else {
                    vo.setPaymentState(gqc.getPaymentState());
                }
                vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
                if (groomerRegister.getGroomerShow() == null) {
                    continue;
                }
                show.setShowName(groomerRegister.getGroomerShow().getShowName());
                show.setShowAddress(groomerRegister.getGroomerShow().getShowAddress());
                show.setShowType(DictUtils.getDictLabel(groomerRegister.getGroomerShow().getShowType(),
                        "groomer_show_type", ""));
                vo.setRestGroomerShow(show);
                vo.setAvatar(member.getAvatar());
                vo.setBusinessRefundState(groomerRegister.isBusinessRefundState());
                vo.setShowCategory(groomerShow.getShowCategory());
                if ("2".equals(groomerShow.getShowCategory())) {
                    vo.setShowTypeSpare(new String[]{"国际宠物美容师"});
                    vo.setIsShowModel(true);
                }
                if ("3".equals(groomerShow.getShowCategory())) {
                    String[] testLevel = groomerShow.getTestLevel().split(",");
                    if (testLevel.length == 2) {
                        vo.setShowTypeSpare(new String[]{"国际宠物美容师", "宠物造型师&国际宠物美容师"});
                        vo.setIsShowModel(true);
                    } else {
                        if (groomerShow.getTestLevel().contains("宠物造型师")) {
                            vo.setShowTypeSpare(new String[]{"宠物造型师&国际宠物美容师"});
                        } else {
                            vo.setShowTypeSpare(new String[]{"国际宠物美容师"});
                            vo.setIsShowModel(true);
                        }
                    }

                }
                //设置默认走旧UI
                vo.setUiSwitchType(GroomerExamUIEnum.OLD_UI.getCode());
                //展示美容考试活动状态代码块
                String gradeWrite = groomerRegister.getGradeWrite();
                String[] str = groomerRegister.getShowCode().split(Constants.LINE);
                String showCodeTypeName = str[2];



                if ((Objects.equals(groomerShow.getShowType(), "exam") && showCodeTypeName.trim().equals("ZG")) ||
                        ((Objects.equals(groomerShow.getShowType(), "match") &&
                                (showCodeTypeName.trim().equals("JY") || showCodeTypeName.trim().equals("ZHRY")
                                        || showCodeTypeName.trim().equals("CQ") || showCodeTypeName.trim().equals("CQTZ"))))) {

                    if (StringUtils.isNotBlank(groomerRegister.getReviewState()) && Objects.equals(groomerRegister.getReviewState(), "1")) {
                        //条件满足则走新UI
                        vo.setUiSwitchType(GroomerExamUIEnum.NEW_UI.getCode());
                    }
                    String showCodeDate = str[0].substring(0, 6);
                    log.info("showCodeDate : {}", showCodeDate);
                    //校验美容活动code是否在可以线上笔试的范围之内
                    Boolean showCodeIsNotActive = this.checkExamShowCodeNotActivity(showCodeTypeName, showCodeDate);
                    if (showCodeIsNotActive) {
                        vo.setGroomerQualificationStatus(GroomerQualificationStatusEnum.FINISHED.code());
                        vo.setGradeWrite("");
                        vo.setGrade("");
                    } else {
                        if (CollectionUtils.isNotEmpty(groomerWrittenExamInfos)) {
                            Map<String, GroomerWrittenExamInfo> groomerWrittenExamInfoMap = groomerWrittenExamInfos.stream().collect(Collectors.toMap(GroomerWrittenExamInfo::getRegisterId, Function.identity()));
                            if (MapUtils.isNotEmpty(groomerWrittenExamInfoMap)) {
                                if (Objects.nonNull(groomerWrittenExamInfoMap.get(groomerRegister.getId()))) {
                                    vo.setWrittenScore(groomerWrittenExamInfoMap.get(groomerRegister.getId()).getGradeWrite());
                                }
                            }
                        }
                        //用来校验实操成绩是否为可以笔试的类型
                        Boolean flag = Boolean.FALSE;
                        //是否有实操成绩
                        if (StringUtils.isBlank(grade)) {
                            //没有实操成绩设置为已报名
                            vo.setGroomerQualificationStatus(GroomerQualificationStatusEnum.REGISTERED.code());
                        } else {
                            if ((Objects.equals(groomerShow.getShowType(), "exam") && str[2].trim().equals("ZG"))) {
                                if (Objects.equals(grade, "2") || Objects.equals(grade, "3")
                                        || Objects.equals(grade, "4") || Objects.equals(grade, "12")) {
                                    flag = Boolean.TRUE;
                                }
                            } else if ((Objects.equals(groomerShow.getShowType(), "match") &&
                                    (str[2].trim().equals("JY") || str[2].trim().equals("ZHRY")
                                            || str[2].trim().equals("CQ") || str[2].trim().equals("CQTZ")))) {
                                if (Objects.equals(Integer.parseInt(grade), OperationExamStatusEnum.PASSED.getCode())
                                        || Objects.equals(Integer.parseInt(grade), OperationExamStatusEnum.FIRST.getCode())
                                        || Objects.equals(Integer.parseInt(grade), OperationExamStatusEnum.SECOND.getCode())
                                        || Objects.equals(Integer.parseInt(grade), OperationExamStatusEnum.THIRD.getCode())
                                        || Objects.equals(Integer.parseInt(grade), OperationExamStatusEnum.EXCELLENT.getCode())
                                        || Objects.equals(Integer.parseInt(grade), OperationExamStatusEnum.EXTREMELY_EXCELLENT.getCode())
                                        || Objects.equals(Integer.parseInt(grade), OperationExamStatusEnum.BE_PROMOTED.getCode())) {
                                    flag = Boolean.TRUE;
                                }
                            }
                            //如果实操成绩没通过设置为已报名
                            if (!flag) {
                                vo.setGroomerQualificationStatus(GroomerQualificationStatusEnum.REGISTERED.code());
                            } else {
                                //实操成绩通过后判断笔试成绩是否为空，空为待考试
                                if (StringUtils.isBlank(gradeWrite)) {
                                    //两个月内没进行考试的更新考试资格
                                    if (DateUtils.nowDateAddTargetDateUnitMonth(groomerRegister.getGradeTime(), Constants.NUM_SIX).compareTo(new Date()) < 0) {
                                        vo.setGroomerQualificationStatus(GroomerQualificationStatusEnum.RESIT_EXAM_FAIL.code());
                                    } else if (DateUtils.nowDateAddTargetDateUnitMonth(groomerRegister.getGradeTime(), Constants.NUM_TWO).compareTo(new Date()) < 0) {
                                        vo.setGroomerQualificationStatus(GroomerQualificationStatusEnum.TO_BE_RETAKEN.code());
                                        gradeWrite = GradeWrittenEnum.FAIL.code();
                                        vo.setWrittenScore(Constants.STRING_ZERO);
                                    } else {
                                        vo.setGroomerQualificationStatus(GroomerQualificationStatusEnum.TO_BE_EXAM.code());
                                        gradeWrite = GradeWrittenEnum.TO_BE_EXAM.code();
                                    }

                                } else {
                                    if (groomerRegister.getReset()) {
                                        vo.setGroomerQualificationStatus(GroomerQualificationStatusEnum.TO_BE_EXAM.code());
                                        gradeWrite = GradeWrittenEnum.TO_BE_EXAM.code();
                                        vo.setWrittenScore(null);
                                    } else {
                                        //笔试成绩不为空，并且成绩为未通过 状态为待补考
                                        if (Objects.equals(gradeWrite, GradeWrittenEnum.FAIL.code())) {
                                            vo.setGroomerQualificationStatus(GroomerQualificationStatusEnum.TO_BE_RETAKEN.code());
                                            //如果实操考试录入时间超过6个月，则取消补考机会
                                            if (DateUtils.nowDateAddTargetDateUnitMonth(groomerRegister.getGradeTime(), Constants.NUM_SIX).compareTo(new Date()) < 0) {
                                                vo.setGroomerQualificationStatus(GroomerQualificationStatusEnum.RESIT_EXAM_FAIL.code());
                                            }
                                        } else if (Objects.equals(gradeWrite, GradeWrittenEnum.PASSED.code())) { // 判断笔试成绩是否通过,通过则查询是否已经申领证书
                                            GroomerQualificationCertificate groomerQualificationCertificate = groomerQualificationCertificateDao.getRegisterByIdAndLevel(groomerRegister.getId(), groomerRegister.getShowLevel(), member.getMemberCode());
                                            //如果已经申请，并且缴费状态为已缴费，则流程也是完成
                                            if (Objects.nonNull(groomerQualificationCertificate) && Objects.equals(groomerQualificationCertificate.getPaymentState(), Constants.STRING_NUM_TWO)) {
                                                vo.setGroomerQualificationStatus(GroomerQualificationStatusEnum.FINISHED.code());
                                            } else {
                                                //否则状态为待领取证书
                                                vo.setGroomerQualificationStatus(GroomerQualificationStatusEnum.UNCLAIMED_CERTIFICATE.code());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        vo.setGradeWrite(DictUtils.getDictLabel(gradeWrite, "grade_write", ""));
                    }
                }
                restList.add(vo);
            }
        } else {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无登录信息或登陆者无会员身份！");
        }
        return new RESTResponse("list", restList);

    }

    /**
     * @Description：更改个人证件照并重置美容报名审核状态（宠爱王国使用） @author: zhuoHeng
     * @version: 2016年12月15日 上午10:08:22
     */
    @Transactional(readOnly = false)
    public RESTResponse resetReviewState(HttpServletRequest request) {
        Member member = UserUtils.getLoginMember();
        String avatar = ServletUtils.getParameter(request, "avatar");
        String id = ServletUtils.getParameter(request, "id");
        GroomerRegister model = groomerRegisterService.get(id);
        if (model == null) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未匹配到有效记录！");
        } else if (!member.getMemberCode().equals(model.getMemberCode())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "申请人与登录会员不一致！");
        }
        if ("2".equals(model.getReviewState())) {
            groomerRegisterService.changeReviewState(id);
            memberService.updateAvatar(avatar, member.getId());
        } else {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前审核状态下的数据不允许被更改！");
        }
        return new RESTResponse();
    }

    /**
     * @Description：根据id获取美容报名详细
     * @author: zhuoHeng
     * @version: 2016年12月27日 下午4:04:15
     */
    public RESTResponse getGroomerRegisterById(HttpServletRequest request) {
        String id = request.getParameter("id");
        Member member = UserUtils.getLoginMember();
        GroomerRegister groomerRegister = new GroomerRegister();
        List<RestGroomerRegister> restList = new ArrayList<RestGroomerRegister>();
        if (member != null) {
            groomerRegister = groomerRegisterService.get(id);
            RestGroomerRegister vo = new RestGroomerRegister();
            RestGroomerShow show = new RestGroomerShow();
            BeanUtil.copyProperties(vo, groomerRegister, "yyyy-MM-dd HH:mm");
            vo.setGender(DictUtils.getDictLabel(groomerRegister.getGender(), "user_gender", ""));
            vo.setShowLevel(DictUtils.getDictLabel(groomerRegister.getShowLevel(), "groomer_test_level", ""));
            vo.setGrade(DictUtils.getDictLabel(groomerRegister.getGrade(), "Grade", ""));
            GroomerQualificationCertificate gqc = groomerQualificationCertificateService
                    .getRegister(groomerRegister.getId());
            if (gqc == null) {
                vo.setPaymentState("3");
            } else {
                vo.setPaymentState(gqc.getPaymentState());
            }
            vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
            show.setShowName(groomerRegister.getGroomerShow().getShowName());
            show.setShowAddress(groomerRegister.getGroomerShow().getShowAddress());
            show.setShowType(
                    DictUtils.getDictLabel(groomerRegister.getGroomerShow().getShowType(), "groomer_show_type", ""));
            vo.setRestGroomerShow(show);
            vo.setAvatar(member.getAvatar());
            restList.add(vo);
        } else {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无登录信息或登陆者无会员身份！");
        }
        return null;
    }

    /**
     * @Description：订单详细中业务数据查询
     * @author: zhuoHeng
     * @version: 2017年1月11日 下午5:19:16
     */
    public RESTResponse orderDetail(String id) {
        GroomerRegister model = groomerRegisterService.get(id);
        Map<String, String> map = new HashMap<>();
        map.put("key1", GroomerUtil.getLevelCn(model.getShowLevel()));
        map.put("key2", GroomerUtil.concatDogBreeds(model.getShowDogBreed(), model.getShowDogBreedExtra()));
        map.put("key3", model.getName());
        map.put("key4", model.getMemberCode());
        map.put("key5", model.getReferee());
        map.put("key6", model.getSchoolNameCn());
        map.put("key7", model.getGroomerShow().getShowType());
        return new RESTResponse("data", map);
    }


    @Transactional(readOnly = false)
    public ListResultDto<RestGroomerRegister> getNurserRegisters() throws Exception {
        Member member = UserUtils.getLoginMember();
        List<GroomerRegister> list = groomerShowBreedsService.findNurseGroomerShowRegister(member.getMemberCode());
        List<RestGroomerRegister> listResult = new ArrayList<RestGroomerRegister>();
        list.stream().forEach(a -> {
            RestGroomerRegister rg = new RestGroomerRegister();
            BeanUtils.copyProperties(a, rg);
            rg.setShowLevel(GroomerUtil.getLevelCn(rg.getShowLevel()));
            rg.setGrade(DictUtils.getDictLabel(rg.getGrade(), "Grade", ""));
            rg.setShowDogBreed(GroomerUtil.concatDogBreeds(rg.getShowDogBreed(), rg.getShowDogBreedExtra()));
            listResult.add(rg);
        });
        return ListResultDto.success(listResult);
    }

    @Transactional(readOnly = false)
    public ListResultDto<GroomerShowBreedsGroupVO> findNurseGroomerShowBreeds(String showLevel) throws Exception {
        Member member = UserUtils.getLoginMember();
        List<GroomerShowBreedsGroupVO> list = groomerShowBreedsService.findNurseGroomerShowBreeds(
                GroomerShowBreeds.builder().showLevels(showLevel).memberCode(member.getMemberCode()).build());
        List<GroomerShowBreedsGroupVO> listResult = new ArrayList<GroomerShowBreedsGroupVO>();
        for (GroomerShowBreedsGroupVO vo : list) {
            vo.setBreedList(vo.getBreedList().stream().filter(a -> !a.isRegistered()).collect(Collectors.toList()));
            if (vo.getBreedList().size() > 0) {
                listResult.add(vo);
            }
        }
        return ListResultDto.success(listResult);
    }

    @Transactional(readOnly = false)
    public ResultDto<GroomerShowBreedsNumVO> getShowLevelNum(String showLevel) throws Exception {
        Member member = UserUtils.getLoginMember();
        //最多申请只数 初级1 高级3 赛级5
        int maxNum = groomerShowBreedsService.getShowLevelMaxNum(showLevel);
        //最少申请只数 最多申请只数 减去 已申请只数 不能小于1
        List<GroomerShowBreeds> registerdList = new ArrayList<>();
        List<GroomerShowBreedsGroupVO> breedGroupList = groomerShowBreedsService.findNurseGroomerShowBreeds(GroomerShowBreeds.builder().showLevels(showLevel).memberCode(member.getMemberCode()).build());
        breedGroupList.forEach(v -> {
            registerdList.addAll(v.getBreedList().stream().filter(b -> b.isRegistered()).collect(Collectors.toList()));
        });
        int minNum = maxNum - registerdList.size();
        minNum = minNum < 1 ? 1 : minNum;

        return ResultDto.success(GroomerShowBreedsNumVO.builder().maxNum(maxNum).minNum(minNum).build());
    }

    /**
     * 校验美容考试赛事编号是否有权限
     * @param showCodeTypeName
     * @param showCodeNum
     * @return
     */
    private Boolean checkExamShowCodeNotActivity(String showCodeTypeName, String showCodeNum) {
        if (showCodeTypeName.trim().equals("ZG")) {
            if (Integer.parseInt(showCodeNum) < Constants.GROOMER_SHOW_HISTORY_SPLIT_DATE_ZG) {
                return Boolean.TRUE;
            }
        } else if (showCodeTypeName.trim().equals("JY")) {
            if (Integer.parseInt(showCodeNum) < Constants.GROOMER_SHOW_HISTORY_SPLIT_DATE_JY) {
                return Boolean.TRUE;
            }
        } else if (showCodeTypeName.trim().equals("CQ")) {
            if (Integer.parseInt(showCodeNum) < Constants.GROOMER_SHOW_HISTORY_SPLIT_DATE_CQ) {
                return Boolean.TRUE;
            }
        } else if (showCodeTypeName.trim().equals("ZHRY")) {
            if (Integer.parseInt(showCodeNum) < Constants.GROOMER_SHOW_HISTORY_SPLIT_DATE_ZHRY) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

}
