/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dogNoseprin.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 鼻纹抽奖机会Entity
 * 
 * @author xx
 * @version 2020-05-06
 */
public class DogNoseRaffle extends DataEntity<DogNoseRaffle> {

	private static final long serialVersionUID = 1L;
	private String memberCode; // 会员号
	private Integer usedNum; // 已用抽奖次数
	private Integer totalNum; // 抽奖总次数
	private String isShare; // 是否第一次分享 1已分享过

	public DogNoseRaffle() {
		super();
	}

	public DogNoseRaffle(String id) {
		super(id);
	}

	@Length(min = 1, max = 60, message = "会员号长度必须介于 1 和 60 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 5, message = "已用抽奖次数长度必须介于 0 和 5 之间")
	public Integer getUsedNum() {
		return usedNum;
	}

	public void setUsedNum(Integer usedNum) {
		this.usedNum = usedNum;
	}

	@Length(min = 0, max = 5, message = "抽奖总次数长度必须介于 0 和 5 之间")
	public Integer getTotalNum() {
		return totalNum;
	}

	public void setTotalNum(Integer totalNum) {
		this.totalNum = totalNum;
	}

	@Length(min = 0, max = 1, message = "是否第一次分享 1已分享过长度必须介于 0 和 1 之间")
	public String getIsShare() {
		return isShare;
	}

	public void setIsShare(String isShare) {
		this.isShare = isShare;
	}

}