package com.cku.restful.v1.dog.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogPedigreeCertifiedExportService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * 出口证书申请Controller
 * 
 * @author lgl
 * @version 2016-08-19
 */
@Controller
@RequestMapping(value = "/api/v1/dog")
public class RestDogPedigreeCertifiedExportController extends BaseRestController {

	@Autowired
	private RestDogPedigreeCertifiedExportService restDogPedigreeCertifiedExportService;

	@ApiOperation(value = "出口证书-列表", tags = { "出口证书-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageSize", value = "展示条数"),
			@ApiImplicitParam(name = "pageNo", value = "当前页"),
			@ApiImplicitParam(name = "pedigreeCertified", value = "血统证书号"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "    \"rc\":0,\n" + "    \"msg\":\"OK\",\n"
			+ "    \"list\":[\n" + "        {\n" + "            \"pedigreeCertified\":\"CKU-111463176/20\", // 血统证书\n"
			+ "            \"reviewRemarks\":\"\",\n" + "            \"dogOwner\":\"刘载春\", \n"
			+ "            \"reviewStateCode\":\"\",\n" + "            \"id\":\"d04e10e402514f9f857051604d38d7d1\", \n"
			+ "            \"reviewState\":\"待审核\", // 审核状态\n" + "            \"exportCountry\":\"USA\", // 出口国家\n"
			+ "            \"createDate\":\"2020-05-28\", // 申请时间\n" + "            \"exportDestination\":\"XX\"\n"
			+ "        }\n" + "    ],\n" + "    \"total\":1\n" + "}\n") })
	@RequestMapping(value = "/dogexport", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = new RESTResponse();
		result = restDogPedigreeCertifiedExportService.getList(request);
		ServletUtils.writeResponse(response, result);
	}


	@ApiOperation(value = "出口证书-提交表单", tags = { "出口证书-zxy" })
	@ApiImplicitParam(name = "token", paramType = "query", value = "token")
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "    \"rc\":0,\n" + "    \"msg\":\"OK\",\n"
			+ "    \"data\":\"4bb236aa5935427ea9ce992d1903027c\"\n" + "}\n" + "") })
	@RequestMapping(value = "/dogexport", method = RequestMethod.POST)
	@ResponseBody
	public void post(
			@ApiParam(name = "json", value = "{\n" + "    \"dogId\":\"b9ca85c141124988a888a95108406bf9\",\n"
					+ "    \"exportCountry\":\"usa\",  // 出口国家\n" + "    \"exporter\":\"tom\", // 接受人\n"
					+ "    \"exportDestination\":\"xx\" // 地址\n" + "}\n" + "") 
			@RequestBody String json,
			HttpServletResponse response) throws IOException {
		RESTResponse result = new RESTResponse();
		result = restDogPedigreeCertifiedExportService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "出口证书-获取价格", tags = { "出口证书-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "dogId", value = "犬只id"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\"rc\":0,\"msg\":\"OK\",\"data\":{\"price\":\"600.00\"}}\n") })
	@RequestMapping(value = "/dogexport/getPrice", method = RequestMethod.GET)
	@ResponseBody
	public void getPrice(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogPedigreeCertifiedExportService.getPrice(request);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "出口证书-国家列表", tags = { "出口证书-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "    \"rc\":0,\n" + "    \"msg\":\"OK\",\n"
			+ "    \"data\":{\n" + "        \"countryList\":[\n" + "            {\n"
			+ "                \"countryEn\":\"Afghanistan\",\n" + "                \"id\":\"3\",\n"
			+ "                \"countryCn\":\"阿富汗\"\n" + "            },\n" + "            {\n"
			+ "                \"countryEn\":\"Albania\",\n" + "                \"id\":\"1\",\n"
			+ "                \"countryCn\":\"阿尔巴尼亚\"\n" + "            }\n" + "        ]\n" + "    }\n" + "}\n"
			+ "") })
	@RequestMapping(value = "/dogexport/countryList", method = RequestMethod.GET)
	@ResponseBody
	public void countryList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogPedigreeCertifiedExportService.countryList(request);
		ServletUtils.writeResponse(response, result);
	}

	
	@RequestMapping(value = "/dogexport/editvod", method = RequestMethod.POST)
	@ResponseBody
	public void editvod(@RequestBody String json , HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogPedigreeCertifiedExportService.editvod(json);
		ServletUtils.writeResponse(response, result);
	}
	
	@ApiOperation(value = "出口证书-申请列表点击验证", tags = { "出口证书-xx" })
	@RequestMapping(value = "/dogexport/validateBusiness", method = RequestMethod.GET)
	@ResponseBody
	public void validateBusiness(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogPedigreeCertifiedExportService.validateBusiness(request);
		ServletUtils.writeResponse(response, result);
	}

	
}