package com.cku.restful.v1.dog.web;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.oa.dog.dao.DogTypeDao;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.restful.v1.dog.model.RestDogType;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 犬种Controller
 *
 * @author fanhuibin
 * @version 2016-08-22
 */
@Controller
@RequestMapping(value = "/cku/v1/dog/dogtype")
public class CkuDogTypeController extends BaseRestController {

    @Autowired
    private DogTypeDao dogTypeDao;
    @Autowired
	public LoginServerService loginServerService;

    @RequestMapping(value = "", method = RequestMethod.GET)
    @ResponseBody
    public void getList(HttpServletResponse response) throws IOException {
        List<DogType> result = dogTypeDao.findAllList(new DogType());
        List<RestDogType> list = Lists.newArrayList();
        result.forEach(dogType -> {
            list.add(new RestDogType(dogType));
        });
        Long totalCount = (long) list.size();
        ServletUtils.writeResponse(response, new RESTResponse("list",
                new PageBeanResult<RestDogType>(list, totalCount)));
    }
}