package com.cku.restful.v1.customer.web;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.github.sd4324530.fastweixin.message.BaseMsg;
import com.github.sd4324530.fastweixin.message.ImageMsg;
import com.github.sd4324530.fastweixin.message.TextMsg;
import com.github.sd4324530.fastweixin.message.req.BaseEvent;
import com.github.sd4324530.fastweixin.message.req.ImageReqMsg;
import com.github.sd4324530.fastweixin.message.req.LinkReqMsg;
import com.github.sd4324530.fastweixin.message.req.LocationReqMsg;
import com.github.sd4324530.fastweixin.message.req.MenuEvent;
import com.github.sd4324530.fastweixin.message.req.TextReqMsg;
import com.github.sd4324530.fastweixin.message.req.VideoReqMsg;
import com.github.sd4324530.fastweixin.message.req.VoiceReqMsg;
import com.github.sd4324530.fastweixin.servlet.WeixinControllerSupport;

/**
 *user chaixueteng
 *2017年7月26日
 */
@Controller
@RequestMapping(value = "/cku/v1/customer/weixin")
public class WeixinController extends WeixinControllerSupport{
	
	private static final String TOKEN = "cabkftoken";
	private static final String URL = "http://bwx2.ntalker.com/agent/weixin";//小能接收微信的接口
	private static final String APPENCODE = "gEZ_ptOOF6e81W45Yi5FnTSvVZjk40egqm8zZYWEVDY"; // app下载的二维码
	private static final String HOSENCODE = "gEZ_ptOOF6e81W45Yi5FnYG_nijw2pb_PWA89GVopgs"; // 定点医院图片
	private static final String JBENCODE = "gEZ_ptOOF6e81W45Yi5FnSSzN_8tRLmPjgtYgOYA_xc"; // 承包疾病图片
    @Override
    protected String getToken() {
        return TOKEN;
    }
    //使用安全模式时设置：APPID
    //不再强制重写，有加密需要时自行重写该方法
    @Override
    protected String getAppId() {
        return null;
    }
    //使用安全模式时设置：密钥
    //不再强制重写，有加密需要时自行重写该方法
    @Override
    protected String getAESKey() {
        return null;
    }
    //处理关注事件
    @Override
    protected BaseMsg handleSubscribe(BaseEvent event) {
    	StringBuffer buffer = new StringBuffer();
    	buffer.append("从热爱到专业,我们不仅是宠物自媒体").append("\n\n");
    	buffer.append("会员业务咨询及办理请致电：").append("\n");
    	buffer.append("400-660-7000").append("\n");
    	buffer.append("合作邮箱：").append("\n");
    	buffer.append("market@chongaibao.com").append("\n\n");
    	buffer.append("点击下方“现场活动”查看详情。").append("\n");
    	buffer.append("↓↓↓ [Smart]精彩不容错过[Smart] ↓↓↓").append("\n");
        return new TextMsg(buffer.toString());
    }
    
    //重写父类方法，处理对应的微信消息(文本消息)
    @Override
    protected BaseMsg handleTextMsg(TextReqMsg msg) {
        String content = msg.getContent();
        //构建xml数据
        StringBuffer str = new StringBuffer();
        str.append("<xml>");
        str.append("<ToUserName><![CDATA[" + msg.getToUserName() + "]]></ToUserName>");
        str.append("<FromUserName><![CDATA[" + msg.getFromUserName() + "]]></FromUserName>");
        str.append("<CreateTime>" + msg.getCreateTime() + "</CreateTime>");
        str.append("<MsgType><![CDATA[" + msg.getMsgType() + "]]></MsgType>");
        str.append("<Content><![CDATA[" + msg.getContent() + "]]></Content>");
        str.append("<MsgId><![CDATA[" + msg.getMsgId() + "]]></MsgId>");
        str.append("</xml>");
        //System.out.println(str.toString());
        //处理关键字自动回复
        if("承保疾病".equals(content.trim())){
        	return new ImageMsg(JBENCODE);
        }else if("定点医院".equals(content.trim())){
        	return new ImageMsg(HOSENCODE);
        }else{
        	//发送给小能
        	doPost(str.toString());
        }
        return null;
    }

    //重写父类方法，处理对应的微信消息(图片消息)
    @Override
    protected BaseMsg handleImageMsg(ImageReqMsg msg) {
       String mediaId= msg.getMediaId();
        //构建xml数据
        StringBuffer str = new StringBuffer();
        str.append("<xml>");
        str.append("<ToUserName><![CDATA[" + msg.getToUserName() + "]]></ToUserName>");
        str.append("<FromUserName><![CDATA[" + msg.getFromUserName() + "]]></FromUserName>");
        str.append("<CreateTime>" + msg.getCreateTime() + "</CreateTime>");
        str.append("<MsgType><![CDATA[" + msg.getMsgType() + "]]></MsgType>");
        str.append("<PicUrl><![CDATA[" + msg.getPicUrl() + "]]></PicUrl>");
        str.append("<MediaId><![CDATA[" + msg.getMediaId() + "]]></MediaId>");
        str.append("<MsgId><![CDATA[" + msg.getMsgId() + "]]></MsgId>");
        str.append("</xml>");
        System.out.println(str.toString());
        doPost(str.toString());
        System.out.print( new ImageMsg(mediaId).toXml());
     //   return new ImageMsg(mediaId);
        return null;
    }
    //重写父类方法，处理对应的微信消息(语音消息)
    @Override
    protected BaseMsg handleVoiceMsg(VoiceReqMsg msg) {
        //构建xml数据
        StringBuffer str = new StringBuffer();
        str.append("<xml>");
        str.append("<ToUserName><![CDATA[" + msg.getToUserName() + "]]></ToUserName>");
        str.append("<FromUserName><![CDATA[" + msg.getFromUserName() + "]]></FromUserName>");
        str.append("<CreateTime>" + msg.getCreateTime() + "</CreateTime>");
        str.append("<MsgType><![CDATA[" + msg.getMsgType() + "]]></MsgType>");
        str.append("<MediaId><![CDATA[" + msg.getMediaId() + "]]></MediaId>");
        str.append("<Format><![CDATA[" + msg.getFormat() + "]]></Format>");
        str.append("<MsgId><![CDATA[" + msg.getMsgId() + "]]></MsgId>");
        str.append("</xml>");
        System.out.println(str.toString());
        doPost(str.toString());
        return null;
    }
    //重写父类方法，处理对应的微信消息(视频消息)
    @Override
    protected BaseMsg handleVideoMsg(VideoReqMsg msg) {
        //构建xml数据
        StringBuffer str = new StringBuffer();
        str.append("<xml>");
        str.append("<ToUserName><![CDATA[" + msg.getToUserName() + "]]></ToUserName>");
        str.append("<FromUserName><![CDATA[" + msg.getFromUserName() + "]]></FromUserName>");
        str.append("<CreateTime>" + msg.getCreateTime() + "</CreateTime>");
        str.append("<MsgType><![CDATA[" + msg.getMsgType() + "]]></MsgType>");
        str.append("<MediaId><![CDATA[" + msg.getMediaId() + "]]></MediaId>");
        str.append("<ThumbMediaId><![CDATA[" + msg.getThumbMediaId() + "]]></ThumbMediaId>");
        str.append("<MsgId><![CDATA[" + msg.getMsgId() + "]]></MsgId>");
        str.append("</xml>");
        System.out.println(str.toString());
        doPost(str.toString());
        return null;
    }
    //重写父类方法，处理对应的微信消息(短视频消息)
    @Override
    protected BaseMsg hadnleShortVideoMsg(VideoReqMsg msg) {
        String mediaId= msg.getMediaId();
        //构建xml数据
        StringBuffer str = new StringBuffer();
        str.append("<xml>");
        str.append("<ToUserName><![CDATA[" + msg.getToUserName() + "]]></ToUserName>");
        str.append("<FromUserName><![CDATA[" + msg.getFromUserName() + "]]></FromUserName>");
        str.append("<CreateTime>" + msg.getCreateTime() + "</CreateTime>");
        str.append("<MsgType><![CDATA[" + msg.getMsgType() + "]]></MsgType>");
        str.append("<MediaId><![CDATA[" + msg.getMediaId() + "]]></MediaId>");
        str.append("<ThumbMediaId><![CDATA[" + msg.getThumbMediaId() + "]]></ThumbMediaId>");
        str.append("<MsgId><![CDATA[" + msg.getMsgId() + "]]></MsgId>");
        str.append("</xml>");
        System.out.println(str.toString());
        doPost(str.toString());
        return null;
    }

    //重写父类方法，处理对应的微信消息(地理位置消息)
    @Override
    protected BaseMsg handleLocationMsg(LocationReqMsg msg) {
        //构建xml数据
        StringBuffer str = new StringBuffer();
        str.append("<xml>");
        str.append("<ToUserName><![CDATA[" + msg.getToUserName() + "]]></ToUserName>");
        str.append("<FromUserName><![CDATA[" + msg.getFromUserName() + "]]></FromUserName>");
        str.append("<CreateTime>" + msg.getCreateTime() + "</CreateTime>");
        str.append("<MsgType><![CDATA[" + msg.getMsgType() + "]]></MsgType>");
        str.append("<Location_X><![CDATA[" + msg.getLocationX()+ "]]></Location_X>");
        str.append("<Location_Y><![CDATA[" + msg.getLocationY() + "]]></Location_Y>");
        str.append("<Scale><![CDATA[" + msg.getScale() + "]]></Scale>");
        str.append("<Label><![CDATA[" + msg.getLabel() + "]]></Label>");
        str.append("<MsgId><![CDATA[" + msg.getMsgId() + "]]></MsgId>");
        str.append("</xml>");
        System.out.println(str.toString());
        doPost(str.toString());
        return null;
    }

    //重写父类方法，处理对应的微信消息(链接消息)
    @Override
    protected BaseMsg handleLinkMsg(LinkReqMsg msg) {
        //构建xml数据
        StringBuffer str = new StringBuffer();
        str.append("<xml>");
        str.append("<ToUserName><![CDATA[" + msg.getToUserName() + "]]></ToUserName>");
        str.append("<FromUserName><![CDATA[" + msg.getFromUserName() + "]]></FromUserName>");
        str.append("<CreateTime>" + msg.getCreateTime() + "</CreateTime>");
        str.append("<MsgType><![CDATA[" + msg.getMsgType() + "]]></MsgType>");
        str.append("<Title><![CDATA[" + msg.getTitle() + "]]></Title>");
        str.append("<Description><![CDATA[" + msg.getDescription() + "]]></Description>");
        str.append("<Url><![CDATA[" + msg.getUrl()+ "]]></Url>");
        str.append("</xml>");
        System.out.println(str.toString());
        doPost(str.toString());
        return null;
    }
/*    *//*1.1版本新增，重写父类方法，加入自定义微信消息处理器
     *不是必须的，上面的方法是统一处理所有的文本消息，如果业务觉复杂，上面的会显得比较乱
     *这个机制就是为了应对这种情况，每个MessageHandle就是一个业务，只处理指定的那部分消息
     *//*
    @Override
    protected List<MessageHandle> initMessageHandles() {
        List<MessageHandle> handles = new ArrayList<MessageHandle>();
       // handles.add(new MyMessageHandle());
        return handles;
    }
    //1.1版本新增，重写父类方法，加入自定义微信事件处理器，同上
    @Override
    protected List<EventHandle> initEventHandles() {
        List<EventHandle> handles = new ArrayList<EventHandle>();
       // handles.add(new MyEventHandle());
        return handles;
    }*/
    @Override
    protected BaseMsg handleMenuClickEvent(MenuEvent event){
    	event.getFromUserName();
    	event.getToUserName();
        String key = event.getEventKey();
        switch (key.toUpperCase()) {
            case "APP": //发送app下载二维码
            	return new ImageMsg(APPENCODE);
            default:
                return null;
        }
    }


    public void doPost(String xml){
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost post=new HttpPost(URL);
            StringEntity myEntity = new StringEntity(xml, "UTF-8");
            post.setEntity(myEntity);
            post.setHeader("Content-Type", "text/xml;charset=UTF-8");
            httpclient.execute(post);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
