package com.cku.restful.v1.buying.service;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.buying.dao.BuyingDao;
import com.cku.oa.buying.entity.Buying;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * Created by user on 2016/12/10.
 */
@Service
@Transactional(readOnly = true)
public class RestBuyingService {
    @Autowired
    private PaymentCartService paymentCartService;
    @Autowired
    private BuyingDao buyingDao;
    @Transactional(readOnly = false)
    public RESTResponse post(String json) {
        //得到会员
        Member member = UserUtils.getLoginMember();
        //记录抢购表
        Buying buying = new Buying();
        buying.setMemberName(member.getName());
        buying.setMemberCode(member.getMemberCode());
        buying.setPaymentState("1");
        Date nowTime=new Date();
        Date startTime = null;
        SimpleDateFormat format=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        try {
            startTime = format.parse("2016-12-14 10:00:00:000");
        } catch (ParseException e) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "时间转化出错！");
        }
        if(startTime.getTime()-nowTime.getTime()>=0){
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "还未到请购时间，请等待！");
        }
        buying.setRemarks(format.format(nowTime));
        buying.preInsert();
        buyingDao.insert(buying);
        // 写入购物车
        PaymentCart paymentCart = new PaymentCart();
        paymentCart.setMemberCode(member.getMemberCode());
        paymentCart.setMemberName(member.getName());
        paymentCart.setChargingItemId("1111");
        paymentCart.setChargingItemName("星级犬舍联展（2017年）");
        paymentCart.setNum("1");
        paymentCart.setPrice("12899");
        paymentCart.setTotalPrice("12899");
        //会员2268,19207 免费
        if("2268".equals(member.getMemberCode()) || "19207".equals(member.getMemberCode())){
            paymentCart.setPrice("0.1");
            paymentCart.setTotalPrice("0.1");
        }
        paymentCart.setAddTime(new Date());
        paymentCart.setBusinessTable("cku_buying");
        paymentCart.setBusinessIds(buying.getId());
        paymentCartService.addToCart(paymentCart, "1059");
        return new RESTResponse();
    }
    @Transactional(readOnly = true)
    public List<Buying> findForRunningNumber(String runningNumber) {
        Buying buying = new Buying();
        buying.setRunningNumber(runningNumber);
        return buyingDao.findList(buying);
    }
}
