package com.cku.restful.v1.appreciation.model;

import java.io.Serializable;

import javax.validation.constraints.Pattern;

import org.hibernate.validator.constraints.NotBlank;
import org.springframework.validation.annotation.Validated;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@Validated
@ApiModel
public class RestAppreciationLogin implements Serializable {

	private static final long serialVersionUID = 3513747895837991920L;

	@ApiModelProperty(value = "手机号码")
	@NotBlank(message = "手机号不能为空")
	@Pattern(regexp = "^[1]{1}[0-9]{10}$", message = "手机号格式不正确")
	private String mobile;

	@ApiModelProperty("验证码")
	@NotBlank(message = "验证码不能为空！")
	private String smsCode;

}
