package com.cku.partner.open.club.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.PageResultDto;
import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.oa.dog.service.DogVideoAppraisalService;
import com.cku.restful.v1.dog.model.RestVideoAppraisalListResponse;
import com.cku.restful.v1.dog.model.RestVideoAppraisalPostResponse;
import com.cku.restful.v1.dog.model.VideoMemberResponse;
import com.cku.restful.v1.dog.vo.DogVideoAppraisalVo;
import com.cku.restful.v1.dog.vo.DogVideoBindChipVo;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Controller
@RequestMapping(value = "/partner/open/appraisal")
public class RestVideoAppraisalController extends BaseRestController {

	@Autowired
	private DogVideoAppraisalService dogVideoAppraisalService;

//	@Autowired
//	private RestOrderService restOrderService;
//
//	@Autowired
//	private PaymentCartService paymentCartService;

	@ApiOperation(value = "视频鉴定-列表", tags = { "视频鉴定-zxy" })
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ResponseBody
	public PageResultDto<RestVideoAppraisalListResponse> getList(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		return dogVideoAppraisalService.getList(request);
	}

	@ApiOperation(value = "视频鉴定-提交表单", tags = { "视频鉴定-zxy" })
	@RequestMapping(value = "/post", method = RequestMethod.POST)
	@ResponseBody
	public ResultDto<RestVideoAppraisalPostResponse> post(@Valid @RequestBody DogVideoAppraisalVo vo,
			HttpServletRequest request, HttpServletResponse response) {

		return dogVideoAppraisalService.post(vo, request);
	}

	@ApiOperation(value = "视频鉴定-获取用户信息", tags = { "视频鉴定-zxy" })
	@RequestMapping(value = "/getMember/{memberCode}", method = RequestMethod.GET)
	@ResponseBody
	public ResultDto<VideoMemberResponse> getMember(
			@ApiParam(name = "memberCode", value = "memberCode") @PathVariable String memberCode,
			HttpServletResponse response) {
		return dogVideoAppraisalService.getMember(memberCode);
	}

//	@ApiOperation(value = "视频鉴定-绑定芯片", tags = { "视频鉴定-zxy" })
	@ApiOperation(value = "3.8.2绑定芯片" ,tags = { "3.8.2" } )
	@RequestMapping(value = "/bindChip", method = RequestMethod.POST)
	@ResponseBody
	public void bindChip(@Valid @RequestBody DogVideoBindChipVo vo, HttpServletRequest request,HttpServletResponse response) throws IOException {
		dogVideoAppraisalService.bindChip(vo);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

//	@ApiOperation(value = "视频鉴定-获取购物车" , tags = { "视频鉴定-zxy" })
//	@ApiResponses({ @ApiResponse(code = 200, message = "{\n" + "	    \"rc\": 0,\n" + "	    \"msg\": \"OK\",\n"
//			+ "	    \"items\": [\n" + "	        {\n" + "	            \"addTime\": \"2020-07-13 19:20:47\",\n"
//			+ "	            \"chargingItemId\": \"25\",\n" + "	            \"chargingItemName\": \"证书变更补做\",\n"
//			+ "	            \"price\": \"60.00\",\n" + "	            \"num\": \"1\",\n"
//			+ "	            \"totalPrice\": \"60.00\",\n"
//			+ "	            \"id\": \"13de25622b2e4fcc846da44a3d2636a4\",\n"
//			+ "	            \"businessTable\": \"dog_pedigree_certified_redo\",\n"
//			+ "	            \"businessIds\": \"702babe5011e4281b65e48401355bb21\"\n" + "	        }\n" + "	    ]\n"
//			+ "	}") })
//	@RequestMapping(value = "/cart/getCartByIds", method = RequestMethod.GET)
//	@ResponseBody
//	public void getCartByIds(HttpServletRequest request, HttpServletResponse response) throws IOException {
//		String cartIds = request.getParameter("cartIds");
//		if (StringUtils.isBlank(cartIds)) {
//			throw new ZAException(ZAErrorCode.ZA_ERROR, "获取参数错误，请重试");
//		}
//		String[] ids = cartIds.split(",");
//		List<PaymentCart> carts = paymentCartService.getMyCart(false);
//		List<PaymentCart> cartList = new ArrayList<>();
//		for (PaymentCart model : carts) {
//			for (String id : ids) {
//				if (model.getId().equals(id)) {
//					cartList.add(model);
//				}
//			}
//		}
//		JSONArray array = new JSONArray();
//		for (int i = 0; i < cartList.size(); i++) {
//			PaymentCart cart = cartList.get(i);
//			JSONObject object = new JSONObject();
//			object.put("addTime", DateUtils.formatDate(cart.getAddTime(), "yyyy-MM-dd HH:mm:ss"));
//			object.put("chargingItemId", cart.getChargingItemId());
//			object.put("chargingItemName", cart.getChargingItemName());
//			object.put("price", cart.getPrice());
//			object.put("num", cart.getNum());
//			object.put("totalPrice", cart.getTotalPrice());
//			object.put("id", cart.getId());
//			object.put("businessTable", cart.getBusinessTable());
//			object.put("businessIds", cart.getBusinessIds());
//			array.add(object);
//		}
//		RESTResponse result = new RESTResponse("items", array);
//		ServletUtils.writeResponse(response, result);
//	}

//	@ApiOperation(value = "视频鉴定-下单" ,tags = { "视频鉴定-zxy" })
//	@RequestMapping(value = "/order", method = RequestMethod.POST)
//	@ResponseBody
//	public void cartToOrder(@ApiParam(name = "json", value = "{\n" + "	\"del\": \"13333333333\",\n"
//			+ "	\"receiverAddress\": \"漷县镇侯黄庄村606号海润犬舍\",\n"
//			+ "	\"carts\": [\"13de25622b2e4fcc846da44a3d2636a4\"],\n" + "	\"receiver\": \"刘载春\",\n"
//			+ "	\"postcode\": \"101112\",\n" + "	\"receiverCity\": \"北京市\",\n"
//			+ "	\"token\": \"eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJ7XCJ1c2VySWRcIjpcIjEyODI1MTYxNzc0NjEwMzA5MTNcIixcImxvZ2luVHlwZVwiOlwibmV3YXBwXCIsXCJtb2JpbGVcIjpcIjEzMzMzMzMzMzMzXCIsXCJjbHViXCI6XCJcIixcInRoaXJkVXNlclwiOntcImNrdVwiOlwiMzI5XCIsXCJzeXNcIjpcIjEyODI1MTYxNzc0NjEwMzA5MTNcIn0sXCJjdXJyZW50Q2x1YlVzZXJJZFwiOlwiXCJ9IiwiaXNzIjoiZGV2ZWxvcCIsImV4cCI6MTU5NzIyNTk5MSwiaWF0IjoxNTk0NjMzOTkxfQ.1Qy3VcZa_j1Zvr_Zryv6QMw-FhzFQPMErBPt6vTKgbY\",\n"
//			+ "	\"receiverProvince\": \"北京市\"\n" + "}") @RequestBody String json, HttpServletRequest request,
//			HttpServletResponse response) throws IOException {
//		JSONObject object = JSONObject.fromObject(json);
//		JSONArray carts = object.getJSONArray("carts");
//		Member member = UserUtils.getLoginMember();
//		Object[] ids = carts.toArray();
//		PaymentOrder order = new PaymentOrder();
//		order.setReceiveProvince(object.getString("receiverProvince"));
//		order.setReceiveCity(object.getString("receiverCity"));
//		if (object.get("receiverArea") == null) {
//			order.setReceiveArea("");
//		} else {
//			order.setReceiveArea(object.get("receiverArea").toString());
//		}
//		order.setReceiveAddress(object.getString("receiverAddress"));
//		order.setReceivePostCode(object.getString("postcode"));
//		order.setReceiveDel(object.getString("del"));
//		order.setReceiver(object.getString("receiver"));
//		order.setMemberCode(member.getMemberCode());
//		order.setMemberName(member.getName());
//		// 如果使用优惠券，减去相应的金额
//		String couponId = null;
//		if (object.get("couponId") != null) {
//			couponId = object.getString("couponId");
//		}
//		String id = restOrderService.cartToOrder(ids, order, couponId);
//		JSONObject jo = new JSONObject();
//		jo.put("id", id);
//		ServletUtils.writeResponse(response, new RESTResponse("data", jo));
//	}

}
