package com.cku.partner.club.web;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogPedigreeCertifiedChangeService;
import com.cku.oa.sampling.entity.Sampling;
import com.cku.oa.sampling.enums.SamplingDogSourceTypeEnum;
import com.cku.oa.sampling.service.SamplingService;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;
import com.cku.partner.club.service.ClubMemberService;
import com.cku.partner.club.service.HospitalService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * user chaixueteng 2016年10月12日
 */
@Controller
@RequestMapping(value = "/partner/hospital")
public class hospitalController extends BaseController {
	@Autowired
	private OrgService orgService;
	@Autowired
	private HospitalService hospitalService;
	@Autowired
	private DogChipService dogChipService;
	@Autowired
	private ClubMemberService clubMemberService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;
	@Autowired
	private SamplingService samplingService;

	@ModelAttribute
	public Org get(@RequestParam(required = false) String id) {
		Org entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = orgService.get(id);
		}
		if (entity == null) {
			entity = new Org();
		}
		return entity;
	}

	/**
	 * 新生犬管理
	 * 
	 * @Author chaixueteng
	 * @2016年10月10日下午3:32:48
	 */
	@RequestMapping(value = "birthList")
	public String birthList(DogBirthCertificate dogBirthCertificate, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		dogBirthCertificate.setAddUser(loginName);
		Page<DogBirthCertificate> page = dogBirthCertificateService
				.findHospitalBirthPage(new Page<DogBirthCertificate>(request, response), dogBirthCertificate);
		model.addAttribute("page", page);
		return "partner/hospital/dogBirthCertificateList";
	}

	/**
	 * 新生犬管理
	 * 
	 * @Author chaixueteng
	 * @2016年10月10日下午3:32:48
	 */
	@RequestMapping(value = "birthOldList")
	public String birthOldList(DogBirthCertificate dogBirthCertificate, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		dogBirthCertificate.setAddUser(loginName);
		Page<DogBirthCertificate> page = dogBirthCertificateService
				.findOldHospitalBirthPage(new Page<DogBirthCertificate>(request, response), dogBirthCertificate);
		model.addAttribute("page", page);
		return "partner/hospital/dogBirthCertificateOldList";
	}

	/**
	 * 新生犬录入页
	 * 
	 * @Author chaixueteng
	 * @2016年10月8日下午6:24:28
	 */
	@RequestMapping(value = "dogChipForm")
	public String dogChipForm(DogChip dogChip, Model model, RedirectAttributes redirectAttributes) {
		String birthCode = dogChip.getBirthCode();
		DogBirthCertificate birth = dogBirthCertificateService.getByBirthCerRegCode(birthCode);

		DogChip validDogChip = dogChipService.getByBirthCode(dogChip.getBirthCode());
		// 合作机构办理，金质证书不在生成证书号
		if (clubMemberService.validGoldenPedigreeCertified(validDogChip.getBirthCode(), validDogChip.getHaddleWay())) {
			addMessage(redirectAttributes, "暂不支持金质证书办理，请前往DNA留存进行采样包绑定!");
			return "redirect:/partner/hospital/birthList?repage";
		}

		model.addAttribute("dogChip", dogChip);
		model.addAttribute("birthCode", birthCode);
		if (StringUtils.isBlank(birth.getPedigreeCertified())) {
			if (StringUtils.isBlank(birth.getIdentificationFlag())) {
				return "partner/hospital/dogChipForm";
			} else {
				return "partner/hospital/dogChipNewForm";
			}
		}
		return "redirect:/partner/hospital/birthList?repage";
	}

	/**
	 * 录入芯片
	 * 
	 * @Author chaixueteng
	 * @2016年10月13日下午4:05:44
	 */
	@RequestMapping(value = "add")
	public String add(HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttributes) {

		String identificationFlag = request.getParameter("xinpian2");
		String birthCerRegCode = request.getParameter("birthCerRegCode");
		String dna = request.getParameter("dna");

		DogChip validDogChip = dogChipService.getByBirthCode(birthCerRegCode);
		// 合作机构办理，金质证书不在生成证书号
		if (clubMemberService.validGoldenPedigreeCertified(validDogChip.getBirthCode(), validDogChip.getHaddleWay())) {
			addMessage(redirectAttributes, "暂不支持金质证书办理，请前往DNA留存进行采样包绑定!");
			return "redirect:/partner/hospital/birthList?repage";
		}

		hospitalService.add(birthCerRegCode, identificationFlag, dna);
		return "redirect:/partner/hospital/birthList?repage";
	}

	/**
	 * 录入芯片
	 * 
	 * @Author chaixueteng
	 * @2016年10月13日下午4:05:44
	 */
	@RequestMapping(value = "addNew")
	public String addNew(HttpServletRequest request, HttpServletResponse response, Model model,
			RedirectAttributes redirectAttributes) {
		String birthCode = request.getParameter("birthCode");
		String chipCode = request.getParameter("chipCode");
		String dna = request.getParameter("dna");
		String samplingCode = request.getParameter("samplingCode");
		DogChip validDogChip = dogChipService.getByBirthCode(birthCode);
		// 合作机构办理，金质证书不在生成证书号
		if (clubMemberService.validGoldenPedigreeCertified(validDogChip.getBirthCode(), validDogChip.getHaddleWay())) {
			addMessage(redirectAttributes, "暂不支持金质证书办理，请前往DNA留存进行采样包绑定!");
			return "redirect:/partner/hospital/birthList?repage";
		}
		try {
			hospitalService.addNew(birthCode, chipCode, dna, samplingCode);
		} catch (Exception e) {
			model.addAttribute("birthCode", birthCode);
			return "partner/hospital/dogChipNewForm";
		}
		return "redirect:/partner/hospital/birthList?repage";
	}

	/**
	 * 根据出生纸和标识码查询
	 * 
	 * @Author chaixueteng
	 * @2016年10月12日下午4:26:03
	 */
	@RequestMapping(value = "searchChipMessage")
	@ResponseBody
	public Object searchChipMessage(HttpServletRequest request, HttpServletResponse response) {
		Map<String, String> map = new HashMap<String, String>();
		try {
			String birthCode = request.getParameter("birthCode");
			String snCode = request.getParameter("snCode");
			map = hospitalService.searchChipMessage(birthCode, snCode);
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 国外证书换发管理
	 * 
	 * @Author chaixueteng
	 * @2017年5月10日下午3:32:48
	 */
	@RequestMapping(value = "dogPedigreeCertifiedChangelist")
	public String dogPedigreeCertifiedChangelist(DogPedigreeCertifiedChange dogPedigreeCertifiedChange,
			HttpServletRequest request, HttpServletResponse response, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String orgId = org.getId();
		dogPedigreeCertifiedChange.setOrgId(orgId);
		dogPedigreeCertifiedChange.setReviewState("1");
		dogPedigreeCertifiedChange.setIsCanceled("0");
		Page<DogPedigreeCertifiedChange> page = dogPedigreeCertifiedChangeService
				.findPage(new Page<DogPedigreeCertifiedChange>(request, response), dogPedigreeCertifiedChange);
		model.addAttribute("page", page);
		return "partner/hospital/dogPedigreeCertifiedChangeList";
	}

	/**
	 * 国外换发芯片的
	 * 
	 * @param id
	 * @param model
	 * @return
	 * @author chaixueteng
	 * @2017年5月10日下午3:32:48
	 */
	@RequestMapping(value = "dogCertifiedChangeChipForm")
	public String dogCertifiedChangeChipForm(String id, Model model) {
		model.addAttribute("dogPedigreeCertifiedChange", dogPedigreeCertifiedChangeService.get(id));
		return "partner/hospital/dogCertifiedChangeChipForm";
	}

	/**
	 * 国外证书换发采集dna
	 * 
	 * @return
	 * @author chaixueteng
	 * @2017年5月10日下午3:32:48
	 */
	@RequestMapping(value = "dogCertifiedChangeDNAForm")
	public String dogCertifiedChangeDNAForm(String id, Model model) {
		DogPedigreeCertifiedChange dogPedigreeCertifiedChange = dogPedigreeCertifiedChangeService.get(id);
		model.addAttribute("dogPedigreeCertifiedChange", dogPedigreeCertifiedChange);
		// 有无占用采样包
		Sampling sampling = samplingService.getByDogCode(dogPedigreeCertifiedChange.getOverseasPedigreeCertified(),
				SamplingDogSourceTypeEnum.OVERSEAS_PEDIGREE_CERTIFIED);
		if (sampling != null) {
			model.addAttribute("samplingCode", sampling.getSamplingCode());
		}

		return "partner/hospital/dogCertifiedChangeDNAForm";
	}

	/**
	 * 芯片确认页面
	 * 
	 * @param id
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "dogCertifiedChangeChipYesForm")
	public String dogCertifiedChangeChipYesForm(String id, Model model) {
		model.addAttribute("dogPedigreeCertifiedChange", dogPedigreeCertifiedChangeService.get(id));
		return "partner/hospital/dogCertifiedChangeChipYesForm";
	}
}
