package com.cku.oa.timedtask.service;

import com.cku.oa.dog.service.DogDnaArchiveService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

/**
 * 遗传疾病同步任务
 *
 * @author yuanshuai
 * @date 2023/8/8 10:46
 */
@Service
@Transactional(readOnly = true)
public class GeneticDiseaseSyncTask extends JobActingService {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private DogDnaArchiveService dogDnaArchiveService;

    @SuppressWarnings("finally")
    @Transactional(readOnly = false)
    int doJob() {
        int count = 0;
        try {
            count = dogDnaArchiveService.syncGeneticDisease();
        } catch (Exception e) {
            logger.info("同步遗传疾病失败：" + e.getMessage());
            count = -1;
        }
        logger.info("修改数据,执行条数：" + count);
        return count;
    }

    @Override
    @SuppressWarnings("finally")
    @Transactional(readOnly = false)
    public int executeOnce() {
        int count = 0;
        try {
            SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
            count = dogDnaArchiveService.syncGeneticDisease();
        } catch (Exception e) {
            logger.info("同步遗传疾病失败：" + e.getMessage());
            count = -1;
        }
        logger.info("修改数据,执行条数：" + count);
        return count;
    }

}