/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.zalog;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 系统业务流水Entity
 * @author lyy
 * @version 2016-07-08
 */
public class SysZaLog extends DataEntity<SysZaLog> {
	
	private static final long serialVersionUID = 1L;
	private String id;
	private String payoutState;		// 支付状态
	private String reviewState;		// 审核状态
	private String processState;		// 处理状态
	private String nowState;		// 当前处于的业务状态
	private String errorInfo;		// 错误信息
	private String successInfo;		// 成功信息
	private String operator;		// 申请人
	private String censor;		// 审核人
	private Date addTime;		// 添加时间
	private String reviewRemarks;		// 审核原因
	private String memberCode;//会员号
	private String tableName; //业务表名
	private String businessId;//业务表主键
	private String runningNumber;//流水号

	@Override
	public String getId() {
		return id;
	}

	@Override
	public void setId(String id) {
		this.id = id;
	}
	@Length(min=0, max=2, message="支付状态长度必须介于 0 和 2 之间")
	public String getPayoutState() {
		return payoutState;
	}

	public void setPayoutState(String payoutState) {
		this.payoutState = payoutState;
	}
	
	@Length(min=0, max=2, message="审核状态长度必须介于 0 和 2 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}
	
	@Length(min=0, max=2, message="处理状态长度必须介于 0 和 2 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}
	
	@Length(min=0, max=50, message="当前处于的业务状态长度必须介于 0 和 50 之间")
	public String getNowState() {
		return nowState;
	}

	public void setNowState(String nowState) {
		this.nowState = nowState;
	}
	
	@Length(min=0, max=255, message="错误信息长度必须介于 0 和 255 之间")
	public String getErrorInfo() {
		return errorInfo;
	}

	public void setErrorInfo(String errorInfo) {
		this.errorInfo = errorInfo;
	}
	
	@Length(min=0, max=255, message="成功信息长度必须介于 0 和 255 之间")
	public String getSuccessInfo() {
		return successInfo;
	}

	public void setSuccessInfo(String successInfo) {
		this.successInfo = successInfo;
	}
	
	@Length(min=0, max=64, message="申请人长度必须介于 0 和 64 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}
	
	@Length(min=0, max=64, message="审核人长度必须介于 0 和 64 之间")
	public String getCensor() {
		return censor;
	}

	public void setCensor(String censor) {
		this.censor = censor;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAddTime() {
		return addTime;
	}

	public void setAddTime(Date addTime) {
		this.addTime = addTime;
	}
	
	@Length(min=0, max=255, message="审核原因长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public String getBusinessId() {
		return businessId;
	}

	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}

	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}
}