/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 身份证验证功能
 * 
 * @author yuanshuai
 * @date 2017-5-23
 */
public class IDCard {

	private static final long serialVersionUID = 1L;
	private String id;
	private String realName;// 真实姓名
	private String idCard;// 身份证号
	private Integer qualified;// 是否合格（0为不合格，1为合格）
	protected String remarks; // 备注
	protected String createBy; // 创建者
	protected Date createDate; // 创建日期
	protected String updateBy; // 更新者
	protected Date updateDate; // 更新日期
	protected String delFlag; // 删除标记（0：正常；1：删除；2：审核）

	public IDCard(String idCard, String realName) {
		this.idCard = idCard;
		this.realName = realName;
	}

	public void preInsert() {
		setId(IdGen.uuid());
		User user = UserUtils.getUser();
		if (StringUtils.isBlank(user.getId())) {
			user.setId("1");
		}
		this.updateBy = user.getId();
		this.createBy = user.getId();

//		if (user.getId() == null) {
//			User u = UserUtils.getLoginUser();
//			// 如果loginUser还是空，则设为管理员添加
//			if (StringUtils.isBlank(u.getId())) {
//				u.setId("1");
//			}
//			this.updateBy = u.getId();
//			this.createBy = u.getId();
//		}
		this.updateDate = new Date();
		this.createDate = this.updateDate;
		this.createDate = this.updateDate;
		this.delFlag = "0";
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getRealName() {
		return realName;
	}

	public void setRealName(String realName) {
		this.realName = realName;
	}

	public String getIdCard() {
		return idCard;
	}

	public void setIdCard(String idCard) {
		this.idCard = idCard;
	}

	public Integer getQualified() {
		return qualified;
	}

	public void setQualified(Integer qualified) {
		this.qualified = qualified;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getCreateBy() {
		return createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public String getUpdateBy() {
		return updateBy;
	}

	public void setUpdateBy(String updateBy) {
		this.updateBy = updateBy;
	}

	public Date getUpdateDate() {
		return updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	public String getDelFlag() {
		return delFlag;
	}

	public void setDelFlag(String delFlag) {
		this.delFlag = delFlag;
	}

}