/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import org.hibernate.validator.constraints.Length;

import java.util.Date;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 收件记录Entity
 * @author fanhuibin
 * @version 2016-08-31
 */
public class ExpressReceive extends DataEntity<ExpressReceive> {
	
	private static final long serialVersionUID = 1L;
	private String memberCode;		// 会员号
	private String memberName;		// 会员姓名
	private String content;		// 发件内容/收件内容,(会员卡、血统证书等)
	private String expressType;		// 快递类型
	private String expressName;		// 快递名
	private String expressNo;		// 快递单号
	private Date receiveDate;		// 收件日期
	private Date postDate;		// 发件日期
	private String phone;		// 电话
	private String receiveRemarks; //收件的备注
	private String contentName;
	
	private Date beginCreateDate;//开始条件
	private Date endCreateDate;//结束日期
	public String getContentName() {
		return "CKU血统证书|出生纸|FCI血统证书|DNA存档|配种证明|出口证书申请|犬主变更申请|证书补做申请|会员登记申请|犬舍登记申请|退费申请|新生犬芯片埋植申请|犬舍所有人变更申请|犬舍名称变更申请|投诉文件|其他";
	}

	public void setContentName(String contentName) {
		this.contentName = "CKU血统证书|出生纸|FCI血统证书|DNA存档|配种证明|出口证书申请|犬主变更申请|证书补做申请|会员登记申请|犬舍登记申请|退费申请|新生犬芯片埋植申请|犬舍所有人变更申请|犬舍名称变更申请|投诉文件|其他";
	}

	public String getReceiveRemarks() {
		return receiveRemarks;
	}

	public void setReceiveRemarks(String receiveRemarks) {
		this.receiveRemarks = receiveRemarks;
	}

	public ExpressReceive() {
		super();
	}

	public ExpressReceive(String id){
		super(id);
	}

	@Length(min=0, max=60, message="会员号长度必须介于 0 和 60 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=0, max=100, message="会员姓名长度必须介于 0 和 100 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}
	
	@Length(min=0, max=255, message="发件内容/收件内容,(会员卡、血统证书等)长度必须介于 0 和 255 之间")
	@NotNull
	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}
	
	@Length(min=0, max=100, message="快递类型长度必须介于 0 和 100 之间")
	public String getExpressType() {
		return expressType;
	}

	public void setExpressType(String expressType) {
		this.expressType = expressType;
	}
	
	@Length(min=0, max=50, message="快递名长度必须介于 0 和 50 之间")
	public String getExpressName() {
		return expressName;
	}

	public void setExpressName(String expressName) {
		this.expressName = expressName;
	}
	
	@Length(min=0, max=50, message="快递单号长度必须介于 0 和 50 之间")
	public String getExpressNo() {
		return expressNo;
	}

	public void setExpressNo(String expressNo) {
		this.expressNo = expressNo;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReceiveDate() {
		return receiveDate;
	}

	public void setReceiveDate(Date receiveDate) {
		this.receiveDate = receiveDate;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPostDate() {
		return postDate;
	}

	public void setPostDate(Date postDate) {
		this.postDate = postDate;
	}
	
	@Length(min=0, max=64, message="电话长度必须介于 0 和 64 之间")
	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}


}