/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 待邮寄物品Entity
 * 
 * @author fanhuibin
 * @version 2016-09-01
 */
public class ExpressQueue extends DataEntity<ExpressQueue> {

	private static final long serialVersionUID = -4139776651092921566L;

	private String memberCode; // 会员号
	private String memberName; // 会员姓名
	private String province; // 省份
	private String city; // 城市
	private String area; // 区域
	private String street; // 街道
	private String runningNumber; // 流水号
	private String phone; // 收件人的收获地址
	private String itemName; // item_name
	private String receiver; // 收件人
	private String postcode; // 邮政编码

	private String expressSendId;
	private String businessTable;
	private String businessId;
	private String chargeItemId; // 收费项目
	private Boolean samplingFlag; // 采样包标识
	private Boolean reissueSamplingFlag; // 补寄采样包标识
	private String reissueSamplingCode; // 补寄采样包编号

	public String getExpressSendId() {
		return expressSendId;
	}

	public void setExpressSendId(String expressSendId) {
		this.expressSendId = expressSendId;
	}

	public String getBusinessId() {
		return businessId;
	}

	public String getBusinessTable() {
		return businessTable;
	}

	public void setBusinessTable(String businessTable) {
		this.businessTable = businessTable;
	}

	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}

	public String getReceiver() {
		return receiver;
	}

	public void setReceiver(String receiver) {
		this.receiver = receiver;
	}

	public ExpressQueue() {
		super();
	}

	public ExpressQueue(String id) {
		super(id);
	}

	@Length(min = 1, max = 60, message = "会员号长度必须介于 1 和 60 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 1, max = 100, message = "会员姓名长度必须介于 1 和 100 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	@Length(min = 1, max = 40, message = "省份长度必须介于 1 和 40 之间")
	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	@Length(min = 1, max = 60, message = "城市长度必须介于 1 和 60 之间")
	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	@Length(min = 1, max = 300, message = "街道长度必须介于 1 和 300 之间")
	public String getStreet() {
		return street;
	}

	public void setStreet(String street) {
		this.street = street;
	}

	@Length(min = 1, max = 50, message = "流水号长度必须介于 1 和 50 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 20, message = "收件人的收获地址长度必须介于 0 和 20 之间")
	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	@Length(min = 1, max = 300, message = "item_name长度必须介于 1 和 300 之间")
	public String getItemName() {
		return itemName;
	}

	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	public String getPostcode() {
		return postcode;
	}

	public void setPostcode(String postcode) {
		this.postcode = postcode;
	}

	public String getChargeItemId() {
		return chargeItemId;
	}

	public void setChargeItemId(String chargeItemId) {
		this.chargeItemId = chargeItemId;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public Boolean getSamplingFlag() {
		return samplingFlag;
	}

	public void setSamplingFlag(Boolean samplingFlag) {
		this.samplingFlag = samplingFlag;
	}

	public Boolean getReissueSamplingFlag() {
		return reissueSamplingFlag;
	}

	public void setReissueSamplingFlag(Boolean reissueSamplingFlag) {
		this.reissueSamplingFlag = reissueSamplingFlag;
	}

	public String getReissueSamplingCode() {
		return reissueSamplingCode;
	}

	public void setReissueSamplingCode(String reissueSamplingCode) {
		this.reissueSamplingCode = reissueSamplingCode;
	}
	
}