package com.cku.oa.statistics.web;

import java.text.ParseException;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.statistics.entity.SaPaymentDetail;
import com.cku.oa.statistics.service.SaPaymentDetailService;

/**
 * 年费拆分到月Controller
 * @author fanhuibin
 * @version 2017-02-21
 */
@Controller
@RequestMapping(value = "${adminPath}/statistics/saAnnualSplit")
public class SaPaymentDetailController extends BaseController {

	@Autowired
	private SaPaymentDetailService saPaymentDetailService;
	
	@ModelAttribute
	public SaPaymentDetail get(@RequestParam(required=false) String id) {
		SaPaymentDetail entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = saPaymentDetailService.get(id);
		}
		if (entity == null){
			entity = new SaPaymentDetail();
		}
		return entity;
	}
	
	@RequiresPermissions("statistics:saAnnualSplit:view")
	@RequestMapping(value = {"list", ""})
	public String list(SaPaymentDetail saAnnualSplit, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<SaPaymentDetail> page = saPaymentDetailService.findPage(new Page<SaPaymentDetail>(request, response), saAnnualSplit); 
		model.addAttribute("page", page);
		return "oa/statistics/saAnnualSplitList";
	}
	
	/**
	 * 初始化拆分,使用该方法拆分之后需要调用
	 * @return
	 */
	@RequestMapping(value="initSplit")
	public void initSplit(){
		try {
			saPaymentDetailService.initSplit("2017-11-01 00:00:00","2017-11-30 23:59:59",2017);
			//saPaymentDetailService.exportBalance();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@RequiresPermissions("statistics:saAnnualSplit:view")
	@RequestMapping(value = "form")
	public String form(SaPaymentDetail saAnnualSplit, Model model) {
		model.addAttribute("saAnnualSplit", saAnnualSplit);
		return "oa/statistics/saAnnualSplitForm";
	}

	@RequiresPermissions("statistics:saAnnualSplit:edit")
	@RequestMapping(value = "save")
	public String save(SaPaymentDetail saAnnualSplit, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, saAnnualSplit)){
			return form(saAnnualSplit, model);
		}
		saPaymentDetailService.save(saAnnualSplit);
		addMessage(redirectAttributes, "保存年费拆分到月成功");
		return "redirect:"+Global.getAdminPath()+"/statistics/saAnnualSplit/?repage";
	}
	
	@RequiresPermissions("statistics:saAnnualSplit:edit")
	@RequestMapping(value = "delete")
	public String delete(SaPaymentDetail saAnnualSplit, RedirectAttributes redirectAttributes) {
		saPaymentDetailService.delete(saAnnualSplit);
		addMessage(redirectAttributes, "删除年费拆分到月成功");
		return "redirect:"+Global.getAdminPath()+"/statistics/saAnnualSplit/?repage";
	}

}