package com.cku.oa.statistics.strategy;

import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.statistics.entity.SaPaymentDetail;
import com.cku.oa.statistics.service.SaPaymentDetailService;
import com.thinkgem.jeesite.common.utils.StringUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

public class SplitYearToMonthWithTowStrategy implements InitSplitStrategy  {
    private SaPaymentDetailService saPaymentDetailService;
    private HashMap<String,RelationShipEntity> relationShipMap;
    private HashMap<String,BigDecimal> chargingPriceMap;
    private int step =12;
    private String stepType;

    public SplitYearToMonthWithTowStrategy(SaPaymentDetailService saPaymentDetailService, HashMap<String,RelationShipEntity> relationShipMap, HashMap<String,BigDecimal> chargingPriceMap,int step,String stepType) {
        this.saPaymentDetailService = saPaymentDetailService;
        this.relationShipMap =relationShipMap;
        this.chargingPriceMap = chargingPriceMap;
        this.step =step;
        this.stepType = stepType;
    }

    @Override
    public void initSplitOrderDetail(List<PaymentOrderDetail> orderDetailList, String id) {
        RelationShipEntity relationShipEntity = relationShipMap.get(id);
        orderDetailList.forEach( r ->{

            if(stepType.equals("cab")){
                BigDecimal cabPrice = chargingPriceMap.get(relationShipEntity.getCab());
                BigDecimal cabTotalPrice = chargingPriceMap.get(relationShipEntity.getCab()).multiply(new BigDecimal(r.getNum()));
                List<YearToMonthSplitEntity> list = YearToMonthSplitUtils.splitYearToMonth(r.getSplitBeginDate(),step,cabTotalPrice,cabPrice);
                for(YearToMonthSplitEntity ytm : list) {
                    SaPaymentDetail saDetail = new SaPaymentDetail();
                    saDetail.setPaymentNum(Integer.valueOf(r.getNum()));
                    saDetail.setMemberCode(r.getMemberCode());
                    saDetail.setChargeDate(ytm.getChargeDate());
                    saDetail.setPrice(ytm.getPrice());
                    saDetail.setRunningNumber(r.getOrderCode());
                    saDetail.setPaymentMoney(ytm.getPaymentMoney());
                    saDetail.setType(PAYMENT_TYPE_CAB);
                    saDetail.setSourceCharge(id);
                    saDetail.setChargeItemId(relationShipEntity.getCab());
                    saDetail.setOrderId(r.getId());
                    saDetail.setPaymentTime((r.getPaymentOrder()!=null &&r.getPaymentOrder().getPaymentTime()!=null)?r.getPaymentOrder().getPaymentTime():r.getAddTime());
                    saDetail.setDeptId(relationShipEntity.getDept());
                    saDetail.setInstallmentEndDate(ytm.getInstallmentEndDate());
                    saDetail.setInstallmentBeginDate(ytm.getInstallmentBeginDate());
                    saPaymentDetailService.save(saDetail);
                }


                SaPaymentDetail saDetail = new SaPaymentDetail();
                saDetail.setMemberCode(r.getMemberCode());
                saDetail.setChargeDate(r.getAddTime());
                saDetail.setRunningNumber(r.getOrderCode());
                saDetail.setType(PAYMENT_TYPE_CKU);
                saDetail.setSourceCharge(id);
                saDetail.setChargeItemId(relationShipEntity.getCku());

                BigDecimal ckuPrice = chargingPriceMap.get(relationShipEntity.getCku());
                saDetail.setPaymentNum(Integer.valueOf(r.getNum()));
                saDetail.setPrice(ckuPrice.toString());
                saDetail.setPaymentMoney(new BigDecimal(r.getNum()).multiply(ckuPrice).toString());

                saDetail.setOrderId(r.getId());
                saDetail.setPaymentTime((r.getPaymentOrder()!=null &&r.getPaymentOrder().getPaymentTime()!=null)?r.getPaymentOrder().getPaymentTime():r.getAddTime());
                saDetail.setDeptId(relationShipEntity.getDept());
                saPaymentDetailService.save(saDetail);
            }


        });
    }

    @Override
    public void initSplitRecord(List<PaymentRecord> recordList, String id) {
        RelationShipEntity relationShipEntity = relationShipMap.get(id);
        recordList.forEach( r ->{
            if(stepType.equals("cab")){
                BigDecimal cabPrice = chargingPriceMap.get(relationShipEntity.getCab());
                Integer chargingItemNum = r.getChargingItemNum()==null?1:r.getChargingItemNum();
                BigDecimal cabTotalPrice = chargingPriceMap.get(relationShipEntity.getCab()).multiply(new BigDecimal(chargingItemNum));
                List<YearToMonthSplitEntity> list = null;

                //如果不是扣费输入分摊区间，走正常拆分 按支付时间向后拆分
                if(StringUtils.isBlank(r.getIsInstallment()) || "0".equals(r.getIsInstallment())){
                    list = YearToMonthSplitUtils.splitYearToMonth(r.getSplitBeginDate(),step,cabTotalPrice,cabPrice);
                }else{
                    //如果输入分摊区间，走新规拆分 按支付时间 和 拆分时间做对比
                    list = YearToMonthSplitUtils.splitYearToMonthWithInstallment(r.getSplitBeginDate(),r.getInstallmentStartDate(),r.getInstallmentEndDate(),step,cabTotalPrice,cabPrice);
                }
                for(YearToMonthSplitEntity ytm : list){
                    SaPaymentDetail saDetail = new SaPaymentDetail();
                    saDetail.setPaymentNum(r.getChargingItemNum()==null?1:Integer.valueOf(r.getChargingItemNum()));
                    saDetail.setMemberCode(r.getMemberCode());
                    saDetail.setChargeDate(ytm.getChargeDate());
                    saDetail.setPrice(ytm.getPrice());
                    saDetail.setRunningNumber(r.getRunningNumber());
                    saDetail.setPaymentMoney(ytm.getPaymentMoney());

                    saDetail.setType(PAYMENT_TYPE_CAB);
                    saDetail.setChargeItemId(relationShipEntity.getCab());
                    saDetail.setSourceCharge(id);
                    saDetail.setRecordId(r.getId());
                    saDetail.setPaymentTime(r.getPaymentTime());
                    saDetail.setDeptId(relationShipEntity.getDept());
                    saDetail.setInstallmentBeginDate(ytm.getInstallmentBeginDate());
                    saDetail.setInstallmentEndDate(ytm.getInstallmentEndDate());
                    saPaymentDetailService.save(saDetail);
                }


                SaPaymentDetail saDetail = new SaPaymentDetail();
                saDetail.setPaymentNum(r.getChargingItemNum()==null?1:Integer.valueOf(r.getChargingItemNum()));
                saDetail.setMemberCode(r.getMemberCode());
                saDetail.setChargeDate(r.getCreateDate());
                saDetail.setRunningNumber(r.getRunningNumber());
                saDetail.setPaymentMoney(r.getPaymentAmount());

                saDetail.setType(PAYMENT_TYPE_CKU);
                saDetail.setChargeItemId(relationShipEntity.getCku());
                saDetail.setSourceCharge(id);

                BigDecimal ckuPrice = chargingPriceMap.get(relationShipEntity.getCku());
                saDetail.setPrice(ckuPrice.toString());
                saDetail.setPaymentMoney(ckuPrice.multiply(new BigDecimal(r.getChargingItemNum() == null ? 1 : r.getChargingItemNum())).toString());

                saDetail.setRecordId(r.getId());
                saDetail.setPaymentTime(r.getPaymentTime());
                saDetail.setDeptId(relationShipEntity.getDept());
                saPaymentDetailService.save(saDetail);
            }



        });
    }
}
