package com.cku.oa.show.entity;

import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Title: 赛事排序犬种组实体
 * Company: cab
 *
 * @author yuanshuai
 * @date 2018/3/22 10:38
 */
public class ShowSortGroup {

    private Map<String, ShowSortBreed> showBreedMap;
    private List<ShowSortBreed> showSortBreedList;
    private String typeGroup;
    private int num;
    private int sort;
    private String percent;
    private Date startTime;
    private Date endTime;
    private Date costTime;

    public ShowSortGroup() {
        showBreedMap = Maps.newLinkedHashMap();
    }

    public ShowSortGroup(String typeGroup) {
        this();
        this.typeGroup = typeGroup;
    }

    /**
     * @Description： map转List并清空map
     * @author: yuanshuai
     * @date: 2018/3/26 16:39
     */
    public void mapToList() {
        showSortBreedList = new ArrayList<>(showBreedMap.values());
        showBreedMap.clear();
    }

    public Map<String, ShowSortBreed> getShowBreedMap() {
        return showBreedMap;
    }

    public void setShowBreedMap(Map<String, ShowSortBreed> showBreedMap) {
        this.showBreedMap = showBreedMap;
    }

    public String getTypeGroup() {
        return typeGroup;
    }

    public void setTypeGroup(String typeGroup) {
        this.typeGroup = typeGroup;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getCostTime() {
        return costTime;
    }

    public void setCostTime(Date costTime) {
        this.costTime = costTime;
    }

    public List<ShowSortBreed> getShowSortBreedList() {
        return showSortBreedList;
    }

    public void setShowSortBreedList(List<ShowSortBreed> showSortBreedList) {
        this.showSortBreedList = showSortBreedList;
    }

    public int getSort() {
        return sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public String getPercent() {
        return percent;
    }

    public void setPercent(String percent) {
        this.percent = percent;
    }

    public int getNum() {
        return num;
    }

    public void setNum(int num) {
        this.num = num;
    }
}
