package com.cku.oa.shop.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import com.cku.core.ZAException;
import com.cku.oa.shop.dao.ShopGoodsDao;
import com.cku.oa.shop.entity.ShopGoods;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.shop.entity.ShopCarts;
import com.cku.oa.shop.dao.ShopCartsDao;

/**
 * 商城购物车临时Service
 * @author lyy
 * @version 2016-08-23
 */
@Service
@Transactional(readOnly = true)
public class ShopCartsService extends CrudService<ShopCartsDao, ShopCarts> {
	@Autowired
	private ShopGoodsDao shopGoodsDao;
	public ShopCarts get(String id) {
		return super.get(id);
	}
	
	public List<ShopCarts> findList(ShopCarts shopCarts) {
		return super.findList(shopCarts);
	}
	
	public Page<ShopCarts> findPage(Page<ShopCarts> page, ShopCarts shopCarts) {
		return super.findPage(page, shopCarts);
	}

	/**
	 * 1，添加临时购物车表，如果买过商品，则商品数量增加，如果没有买过商品，则新建
	 * 2，
	 * @param shopCarts
     */
	@Transactional(readOnly = false)
	public void save(ShopCarts shopCarts,String type) {
		//查询出添加商品
		ShopGoods shopGoods = shopGoodsDao.get(new ShopGoods(shopCarts.getGoodsId()));
		//1,判断商品，限购，总数量
		String limit = shopGoods.getLimits();
		String sum = shopGoods.getNum();
		String goodsNum = shopCarts.getGoodsNum();
		if(Integer.parseInt(goodsNum)> Integer.parseInt(limit) && !"0".equals(limit)){
			throw new ZAException(-1,"购买商品数量超出限购数量！");
		}
		if(Integer.parseInt(sum)<=0 || Integer.parseInt(goodsNum)>Integer.parseInt(sum)){
			throw new ZAException(-1,"购买商品数量超出商品剩余数量！");
		}
		//查询出购物车已有的商品
		List<ShopCarts> list = dao.findListByMemberCode(shopCarts.getMemberCode());
		//是买赠商品
		ShopCarts buyGoodsCarts = null;

		if(("1".equals(shopGoods.getBuyGifts()) && Integer.parseInt(shopCarts.getGoodsNum())>=5) || ("2".equals(shopGoods.getBuyGifts()) && Integer.parseInt(shopCarts.getGoodsNum())>=10)){
			if(list!=null && list.size()>0){
				for(ShopCarts sc : list){
					if(sc.getGoodsId().equals(shopCarts.getBuyGiftsGoods()) && "1".equals(sc.getIsBuyGifts())){
						buyGoodsCarts = sc;
						break;
					}
				}
			}
			//查询出赠品，判断赠品剩余数量是否足够
			ShopGoods buyShopGoods = shopGoodsDao.get(new ShopGoods(shopCarts.getBuyGiftsGoods()));
			String buySum = buyShopGoods.getNum();
			String buyGoodsNum = shopCarts.getBuyGiftsNum();
			if(Integer.parseInt(buySum)<=0 || Integer.parseInt(buyGoodsNum)>Integer.parseInt(buySum)){
				throw new ZAException(-1,"赠品数量超出商品剩余数量！");
			}

			if(buyGoodsCarts!=null){
				int nowNum = Integer.parseInt(buyGoodsCarts.getGoodsNum())+Integer.parseInt(shopCarts.getBuyGiftsNum());
				buyGoodsCarts.setGoodsNum(nowNum+"");
				buyGoodsCarts.setTotalPrice("0");
			}else{
				buyGoodsCarts = new ShopCarts();
				buyGoodsCarts.setMemberCode(shopCarts.getMemberCode());
				buyGoodsCarts.setMemberName(shopCarts.getMemberName());
				buyGoodsCarts.setGoodsName(buyShopGoods.getName());
				buyGoodsCarts.setGoodsPrice(buyShopGoods.getPrice());
				buyGoodsCarts.setGoodsNum(shopCarts.getBuyGiftsNum());
				buyGoodsCarts.setGoodsId(shopCarts.getBuyGiftsGoods());
				buyGoodsCarts.setTotalPrice("0");
				buyGoodsCarts.setAddDate(new Date());
				buyGoodsCarts.setIsBuyGifts("1");
			}
			super.save(buyGoodsCarts);
			shopGoodsDao.updateNum(shopCarts.getBuyGiftsGoods(),(Integer.parseInt(buyShopGoods.getNum())-Integer.parseInt(shopCarts.getBuyGiftsNum()))+"");
		}
		//正常商品
		ShopCarts updatesc = null;
		if(list!=null && list.size()>0){
			for(ShopCarts sc : list){
				if(sc.getGoodsId().equals(shopCarts.getGoodsId()) && "0".equals(sc.getIsBuyGifts())){
					updatesc = sc;
					break;
				}
			}
		}
		if(updatesc!=null){
			//修改商品
			int nowNum = Integer.parseInt(updatesc.getGoodsNum())+Integer.parseInt(shopCarts.getGoodsNum());
			if(nowNum> Integer.parseInt(limit) && !"0".equals(limit)){
				throw new ZAException(-1,"购买商品数量超出限购数量！");
			}
			updatesc.setGoodsNum(nowNum+"");
			//后台不计算分区价格
			if(type!=null && "client".equals(type)){
				//分区计价
				if("1".equals(shopGoods.getIsInterval())){
					if(shopGoods.getInterval1Num().equals(shopGoods.getInterval2Num())){
						if(nowNum<Integer.parseInt(shopGoods.getInterval1Num())){
							updatesc.setGoodsPrice(shopGoods.getInterval1Price());
						}else{
							updatesc.setGoodsPrice(shopGoods.getInterval2Price());
						}
					}else{
						if(nowNum<Integer.parseInt(shopGoods.getInterval1Num())){
							updatesc.setGoodsPrice(shopGoods.getInterval1Price());
						}else if(nowNum<Integer.parseInt(shopGoods.getInterval2Num())){
							updatesc.setGoodsPrice(shopGoods.getInterval2Price());
						}else{
							updatesc.setGoodsPrice(shopGoods.getInterval3Price());
						}
					}
				}
			}
			//判断正常商品，的赠品与新添加是不是一致的商品
			String buyGiftsContent = updatesc.getBuyGiftsContent();
			if(shopCarts.getBuyGiftsGoods()!=null && !"".equals(shopCarts.getBuyGiftsGoods()) && shopCarts.getBuyGiftsNum()!=null && !"".equals(shopCarts.getBuyGiftsNum())){
				if(buyGiftsContent!=null && !"".equals(buyGiftsContent)){
					JSONArray ja = JSONArray.fromObject(buyGiftsContent);
					boolean isExist = false;
					for(int i=0;i<ja.size();i++){
						JSONObject jo = ja.getJSONObject(i);
						if(jo.getString("id").equals(shopCarts.getBuyGiftsGoods())){
							jo.put("num",Integer.parseInt(jo.getString("num"))+Integer.parseInt(shopCarts.getBuyGiftsNum()));
							isExist = true;
							break;
						}
					}
					if(!isExist){
						ja.add(toChild(shopCarts.getBuyGiftsGoods(),shopCarts.getBuyGiftsNum()));
					}
					updatesc.setBuyGiftsContent(ja.toString());
				}else{
					updatesc.setBuyGiftsContent(JSONArray.fromObject(Arrays.asList(toChild(shopCarts.getBuyGiftsGoods(),shopCarts.getBuyGiftsNum()))).toString());
				}
			}
			BigDecimal bigNowNum = new BigDecimal(nowNum);
			BigDecimal bigGoodsPrice = new BigDecimal(updatesc.getGoodsPrice());
			updatesc.setTotalPrice(bigNowNum.multiply(bigGoodsPrice).toString());
		}else{
			//新增商品
			BigDecimal bigNowNum = new BigDecimal(shopCarts.getGoodsNum());
			Integer nowNum = Integer.parseInt(shopCarts.getGoodsNum());
			//后台不计算分区价格
			if(type!=null && "client".equals(type)) {
				//分区计价
				if ("1".equals(shopGoods.getIsInterval())) {
					if (shopGoods.getInterval1Num().equals(shopGoods.getInterval2Num())) {
						if (nowNum < Integer.parseInt(shopGoods.getInterval1Num())) {
							shopCarts.setGoodsPrice(shopGoods.getInterval1Price());
						} else {
							shopCarts.setGoodsPrice(shopGoods.getInterval2Price());
						}
					} else {
						if (nowNum < Integer.parseInt(shopGoods.getInterval1Num())) {
							shopCarts.setGoodsPrice(shopGoods.getInterval1Price());
						} else if (nowNum < Integer.parseInt(shopGoods.getInterval2Num())) {
							shopCarts.setGoodsPrice(shopGoods.getInterval2Price());
						} else {
							shopCarts.setGoodsPrice(shopGoods.getInterval3Price());
						}
					}
				}
			}
			BigDecimal bigGoodsPrice = new BigDecimal(shopCarts.getGoodsPrice());
			shopCarts.setTotalPrice(bigNowNum.multiply(bigGoodsPrice).toString());
			shopCarts.setAddDate(new Date());
			shopCarts.setIsBuyGifts("0");
			if(shopCarts.getBuyGiftsGoods()!=null && !"".equals(shopCarts.getBuyGiftsGoods()) && shopCarts.getBuyGiftsNum()!=null && !"".equals(shopCarts.getBuyGiftsNum())){
				shopCarts.setBuyGiftsContent(JSONArray.fromObject(Arrays.asList(toChild(shopCarts.getBuyGiftsGoods(),shopCarts.getBuyGiftsNum()))).toString());
			}

			updatesc = shopCarts;
		}
		shopGoodsDao.updateNum(shopCarts.getGoodsId(),(Integer.parseInt(shopGoods.getNum())-Integer.parseInt(shopCarts.getGoodsNum()))+"");
		super.save(updatesc);
	}
	/**
	 * 转化JSONObject
	 * @param id
	 * @param num
     * @return
     */
	public static JSONObject toChild(String id,String num){
		JSONObject jo = new JSONObject();
		jo.put("id",id);
		jo.put("num",num);
		return jo;
	}

	/**
	 * 得到正常商品
	 * @param memberCode
	 * @param goodsId
     * @return
     */
	public ShopCarts getCommonCarts(String memberCode,String goodsId){
		return dao.getCommonCarts(memberCode,goodsId);
	};
	/**
	 * 删除商品
	 * @param shopCarts
     */
	@Transactional(readOnly = false)
	public void subtractGoods(ShopCarts shopCarts) {
		//每次删除的数量
		int stepNum = 1;
		ShopGoods shopGoods = shopGoodsDao.get(shopCarts.getGoodsId());
		ShopCarts buyShopCarts = null;
		//如果此商品是买赠商品，删除赠品数量
		if("2".equals(shopGoods.getBuyGifts())){
			stepNum = 10;
		}else if("1".equals(shopGoods.getBuyGifts())){
			stepNum = 5;
		}
		//删除本商品
		Integer delNum = Integer.parseInt(shopCarts.getGoodsNum())-stepNum;
		if(delNum>0){
			//分区计价
			if("1".equals(shopGoods.getIsInterval())){
				if(shopGoods.getInterval1Num().equals(shopGoods.getInterval2Num())){
					if(delNum<Integer.parseInt(shopGoods.getInterval1Num())){
						shopCarts.setGoodsPrice(shopGoods.getInterval1Price());
					}else{
						shopCarts.setGoodsPrice(shopGoods.getInterval2Price());
					}
				}else{
					if(delNum<Integer.parseInt(shopGoods.getInterval1Num())){
						shopCarts.setGoodsPrice(shopGoods.getInterval1Price());
					}else if(delNum<Integer.parseInt(shopGoods.getInterval2Num())){
						shopCarts.setGoodsPrice(shopGoods.getInterval2Price());
					}else{
						shopCarts.setGoodsPrice(shopGoods.getInterval3Price());
					}
				}
			}
			BigDecimal bigDelNum = new BigDecimal(delNum);
			BigDecimal bigGoodsPrice = new BigDecimal(shopCarts.getGoodsPrice());
			shopCarts.setGoodsNum(bigDelNum.toString());
			shopCarts.setTotalPrice(bigDelNum.multiply(bigGoodsPrice).toString());
			//删除赠品
			if(shopCarts.getBuyGiftsContent()!=null && !"".equals(shopCarts.getBuyGiftsContent())){
				JSONArray ja = JSONArray.fromObject(shopCarts.getBuyGiftsContent());
				JSONObject jo = ja.getJSONObject(0);
				buyShopCarts = dao.getBuyGift(shopCarts.getMemberCode(),jo.getString("id"));
				Integer buyShopCartsNum = Integer.parseInt(buyShopCarts.getGoodsNum());
				//增加数量
				Integer insertNum = Integer.parseInt(jo.getString("num"));
				//原始数量
				Integer owninsertNum = Integer.parseInt(jo.getString("num"));
				//原始总量
				Integer ownCount = 0;
				if (stepNum==5) {
					if(owninsertNum<=1){
						ownCount = 5-stepNum;
					}else{
						if(owninsertNum%3==0){
							ownCount = owninsertNum/3*10-stepNum;
						}else{
							ownCount = owninsertNum/3*10+5-stepNum;
						}
					}

				} else if (stepNum==10) {
					ownCount = ownCount+owninsertNum/2*10-stepNum;
				}


				if (stepNum==5) {
					// 5返1，10返3
					if (ownCount >= 10) {
						if(ownCount-((ownCount/10)*10)>=5){
							insertNum = (ownCount / 10 * 3)+1;
						}else{
							insertNum = ownCount / 10 * 3;
						}

					} else if (ownCount >= 5) {
						insertNum = 1;
					}else{
						insertNum = 0;
					}
				} else if (stepNum==10) {
					// 10返2
					if (ownCount >= 10) {
						insertNum = ownCount / 10 * 2;
					}else{
						insertNum = 0;
					}
				}
				if(insertNum<=0){
					ja.remove(0);
				}else{
					jo.put("num",insertNum);
				}

				shopCarts.setBuyGiftsContent(ja.toString());
				//赠品商品数量添加
				ShopGoods buyGoods = shopGoodsDao.get(new ShopGoods(jo.getString("id")));
				shopGoodsDao.updateNum(jo.getString("id"),(Integer.parseInt(buyGoods.getNum())+(owninsertNum-insertNum))+"");
				buyShopCarts.setGoodsNum(buyShopCartsNum-(owninsertNum-insertNum)+"");
				//保存赠品
				if(buyShopCartsNum-(owninsertNum-insertNum)==0){
					super.delete(buyShopCarts);
				}else{
					super.save(buyShopCarts);
				}
			}
			//本商品数量添加
			ShopGoods ownGoods = shopGoodsDao.get(new ShopGoods(shopCarts.getGoodsId()));
			shopGoodsDao.updateNum(shopCarts.getGoodsId(),(Integer.parseInt(ownGoods.getNum())+stepNum)+"");
			//保存修改主商品
			super.save(shopCarts);
		}else{
			//删除赠品
			if(shopCarts.getBuyGiftsContent()!=null && !"".equals(shopCarts.getBuyGiftsContent())){
				JSONArray ja = JSONArray.fromObject(shopCarts.getBuyGiftsContent());
				for(int i=0;i<ja.size();i++){
					JSONObject jo = ja.getJSONObject(i);
					ShopCarts delBuyShopCarts = dao.getBuyGift(shopCarts.getMemberCode(),jo.getString("id"));
					//赠品商品数量添加
					ShopGoods buyGoods = shopGoodsDao.get(new ShopGoods(jo.getString("id")));
					shopGoodsDao.updateNum(jo.getString("id"),(Integer.parseInt(buyGoods.getNum())+jo.getInt("num"))+"");
					if(delBuyShopCarts.getGoodsNum().equals(jo.getString("num"))){
						super.delete(delBuyShopCarts);
					}else{
						delBuyShopCarts.setGoodsNum(Integer.parseInt(delBuyShopCarts.getGoodsNum())-Integer.parseInt(jo.getString("num"))+"");
						super.save(delBuyShopCarts);
					}
				}
			}
			//本商品数量添加
			ShopGoods ownGoods = shopGoodsDao.get(new ShopGoods(shopCarts.getGoodsId()));
			shopGoodsDao.updateNum(shopCarts.getGoodsId(),(Integer.parseInt(ownGoods.getNum())+Integer.parseInt(shopCarts.getGoodsNum()))+"");
			//删除商品
			super.delete(shopCarts);
		}

	}

	/**
	 * 添加商品
	 * @param shopCarts
     */
	@Transactional(readOnly = false)
	public void addGoods(ShopCarts shopCarts) {
		//查询出添加商品
		ShopGoods shopGoods = shopGoodsDao.get(new ShopGoods(shopCarts.getGoodsId()));
		//每次增加的数量
		int stepNum = 1;
		//赠品
		ShopCarts buyShopCarts = null;
		//如果此商品是买赠商品，增加赠品数量
		if("2".equals(shopGoods.getBuyGifts())){
			stepNum = 10;
		}else if("1".equals(shopGoods.getBuyGifts())){
			stepNum = 5;
		}
		//添加本商品
		Integer addNum = Integer.parseInt(shopCarts.getGoodsNum())+stepNum;
		//1,判断商品，限购，总数量
		String limit = shopGoods.getLimits();
		String sum = shopGoods.getNum();
		if(addNum> Integer.parseInt(limit) && !"0".equals(limit)){
			throw new ZAException(-1,"购买商品数量超出限购数量！");
		}
		if(Integer.parseInt(sum)<=0 || stepNum>Integer.parseInt(sum)){
			throw new ZAException(-1,"购买商品数量超出商品剩余数量！");
		}
		//分区计价
		if("1".equals(shopGoods.getIsInterval())){
			if(shopGoods.getInterval1Num().equals(shopGoods.getInterval2Num())){
				if(addNum<Integer.parseInt(shopGoods.getInterval1Num())){
					shopCarts.setGoodsPrice(shopGoods.getInterval1Price());
				}else{
					shopCarts.setGoodsPrice(shopGoods.getInterval2Price());
				}
			}else{
				if(addNum<Integer.parseInt(shopGoods.getInterval1Num())){
					shopCarts.setGoodsPrice(shopGoods.getInterval1Price());
				}else if(addNum<Integer.parseInt(shopGoods.getInterval2Num())){
					shopCarts.setGoodsPrice(shopGoods.getInterval2Price());
				}else{
					shopCarts.setGoodsPrice(shopGoods.getInterval3Price());
				}
			}
		}
		//重新计算总价
		BigDecimal bigAddNum = new BigDecimal(addNum);
		BigDecimal bigGoodsPrice = new BigDecimal(shopCarts.getGoodsPrice());
		shopCarts.setGoodsNum(bigAddNum.toString());
		shopCarts.setTotalPrice(bigAddNum.multiply(bigGoodsPrice).toString());
		//添加赠品
		if(shopCarts.getBuyGiftsContent()!=null && !"".equals(shopCarts.getBuyGiftsContent())){
			JSONArray ja = JSONArray.fromObject(shopCarts.getBuyGiftsContent());
			JSONObject jo = ja.getJSONObject(0);
			buyShopCarts = dao.getBuyGift(shopCarts.getMemberCode(),jo.getString("id"));
			Integer buyShopCartsNum = Integer.parseInt(buyShopCarts.getGoodsNum());

			//增加数量
			Integer insertNum = Integer.parseInt(jo.getString("num"));
			//原始数量
			Integer owninsertNum = Integer.parseInt(jo.getString("num"));
			//原始总量
			Integer ownCount = stepNum;
			if (stepNum==5) {
				if(owninsertNum<=1){
					ownCount = ownCount+5;
				}else{
					if(owninsertNum%3==0){
						ownCount = ownCount+owninsertNum/3*10;
					}else{
						ownCount = ownCount+owninsertNum/3*10+5;
					}
				}

			} else if (stepNum==10) {
				ownCount = ownCount+owninsertNum/2*10;
			}
			if (stepNum==5) {
				// 5返1，10返3
				if (ownCount >= 10) {
					if(ownCount-((ownCount/10)*10)>=5){
						insertNum = (ownCount / 10 * 3)+1;
					}else{
						insertNum = ownCount / 10 * 3;
					}

				} else if (ownCount >= 5) {
					insertNum = 1;
				}
			} else if (stepNum==10) {
				// 10返2
				if (ownCount >= 10) {
					insertNum = ownCount / 10 * 2;
				}
			}
			//修改本品的赠品记录
			jo.put("num",insertNum);
			shopCarts.setBuyGiftsContent(ja.toString());
			if(buyShopCartsNum<=0 || (insertNum-owninsertNum)>buyShopCartsNum){
				throw new ZAException(-1,"赠品数量超出商品剩余数量！");
			}
			buyShopCarts.setGoodsNum(buyShopCartsNum+(insertNum-owninsertNum)+"");
			//增品减少
			ShopGoods buyGoods = shopGoodsDao.get(new ShopGoods(jo.getString("id")));
			shopGoodsDao.updateNum(jo.getString("id"),(Integer.parseInt(buyGoods.getNum())-(insertNum-owninsertNum))+"");
		}
		//保存赠品
		if(buyShopCarts!=null){
			super.save(buyShopCarts);
		}
		//本商品数量减少
		ShopGoods ownGoods = shopGoodsDao.get(new ShopGoods(shopCarts.getGoodsId()));
		shopGoodsDao.updateNum(shopCarts.getGoodsId(),(Integer.parseInt(ownGoods.getNum())-stepNum)+"");
		//保存修改主商品
		super.save(shopCarts);
	}
	@Transactional(readOnly = false)
	public void delete(ShopCarts shopCarts) {
		//删除方法
		ShopCarts selCart = dao.get(shopCarts);
		String isBuy = selCart.getIsBuyGifts();
		//不是赠品
		if("0".equals(isBuy)){
			List<ShopCarts> clist = dao.findListByMemberCode(selCart.getMemberCode());
			if(selCart.getBuyGiftsContent()!=null && !"".equals(selCart.getBuyGiftsContent()) && clist!=null && clist.size()>0){
				JSONArray ja = JSONArray.fromObject(selCart.getBuyGiftsContent());
				for(int i=0;i<ja.size();i++){
					JSONObject jo = ja.getJSONObject(i);
					for(ShopCarts sc :clist){
						if("1".equals(sc.getIsBuyGifts()) && jo.getString("id").equals(sc.getGoodsId()) ){
							if(Integer.parseInt(sc.getGoodsNum())>jo.getInt("num")){
								sc.setGoodsNum((Integer.parseInt(sc.getGoodsNum())-jo.getInt("num"))+"");
								super.save(sc);
							}else{
								super.delete(sc);
							}
							//赠品商品数量添加
							ShopGoods buyGoods = shopGoodsDao.get(new ShopGoods(jo.getString("id")));
							shopGoodsDao.updateNum(jo.getString("id"),(Integer.parseInt(buyGoods.getNum())+jo.getInt("num"))+"");
						}
					}
				}

			}

		}else{
			throw new ZAException(-1,"赠品不可以删除！");
		}
		//商品数量添加
		ShopGoods goods = shopGoodsDao.get(new ShopGoods(selCart.getGoodsId()));
		shopGoodsDao.updateNum(selCart.getGoodsId(),(Integer.parseInt(goods.getNum())+Integer.parseInt(selCart.getGoodsNum()))+"");
		super.delete(shopCarts);
	}

	public List<ShopCarts> findListByMemberCode(String memberCode){
		return dao.findListByMemberCode(memberCode);
	}

}