package com.cku.oa.sampling.enums;

import com.cku.oa.sys.entity.user.IEnum;

/**
 * 采样包流程状态
 */
public enum SamplingFlowStateEnum implements IEnum<Integer> {

	NO_USE(0, "未使用"),
	POST(1, "已邮寄"),
	SEND(2, "已送检"),
	SUCCESS(3, "检测成功"),
	FAILURE(4, "失败"),
	LOGOUT(5, "已注销");

	private Integer code;

	private String message;

	SamplingFlowStateEnum(Integer code, String message) {
		this.code = code;
		this.message = message;
	}

	@Override
	public Integer code() {
		return this.code;
	}

	@Override
	public String message() {
		return this.message;
	}

}
