package com.cku.oa.ipaddress.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * ip映射表Entity
 * @author ip映射表
 * @version 2019-10-18
 */
public class IpAddress extends DataEntity<IpAddress> {
	
	private static final long serialVersionUID = 1L;
	private String today;		// 时间
	private String ip;		// ip
	private Integer count;		// 当日请求
	
	public IpAddress() {
		super();
	}

	public IpAddress(String id){
		super(id);
	}

	@Length(min=0, max=32, message="时间长度必须介于 0 和 32 之间")
	public String getToday() {
		return today;
	}

	public void setToday(String today) {
		this.today = today;
	}
	
	@Length(min=0, max=32, message="ip长度必须介于 0 和 32 之间")
	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public Integer getCount() {
		return count;
	}

	public void setCount(Integer count) {
		this.count = count;
	}
	
	
	
}