/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.handler.dao.HandlerRegisterDao;
import com.cku.oa.handler.dao.HandlerShowDao;
import com.cku.oa.handler.entity.HandlerRegister;
import com.cku.oa.handler.entity.HandlerShow;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 活动Service
 * 
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Service
@Transactional(readOnly = true)
public class HandlerShowService extends CrudService<HandlerShowDao, HandlerShow> {

	@Autowired
	private SaPaymentDetailTotalService saPaymentDetailTotalService;
	@Autowired
	private HandlerRegisterDao handlerRegisterDao;

	public HandlerShow get(String id) {
		return super.get(id);
	}

	public List<HandlerShow> findList(HandlerShow handlerShow) {
		return super.findList(handlerShow);
	}

	public Page<HandlerShow> findPage(Page<HandlerShow> page, HandlerShow handlerShow) {
		return super.findPage(page, handlerShow);
	}

	public Page<HandlerShow> findExaminerPage(Page<HandlerShow> page, HandlerShow handlerShow) {
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		handlerShow.setPage(page);
		page.setList(dao.findExaminerPage(handlerShow));
		if ((pageNo - 1) * pageSize >= page.getCount()) {
			page.setList(new ArrayList<HandlerShow>(0));
		}
		return page;

	}

	@Transactional(readOnly = false)
	public void save(HandlerShow handlerShow) {
		// 验证时间
		Date startTime = handlerShow.getStartTime();
		Date endTime = handlerShow.getEndTime();
		Date registerEndTime = handlerShow.getRegisterEndTime();
		if (startTime.after(endTime)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "开始时间大于结束时间");
		} else if (registerEndTime.after(startTime)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "截止日期大于开始日期");
		}
		handlerShow.setShowCode(handlerShow.getShowCode().trim());
		HandlerShow oldHandlerShow = getShow(handlerShow.getShowCode());
		// 执行操作
//		List<ChildShows> childShowsList = handlerShow.getChildShowsList();
		String id = handlerShow.getId();
		if (null != id && !"".equals(id)) {// 修改
//			for (ChildShows childShows : childShowsList) {
//				if ("7".equals(handlerShow.getShowType())
//						&& ("none".equals(childShows.getTestLevel()) || "MASTER".equals(childShows.getTestLevel())))
//					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "宠物营养师考试，级别只能选A/B/C");
//				handlerShow.setShowCode(childShows.getShowCode());
//				handlerShow.setTestLevel(childShows.getTestLevel());
//				handlerShow.setFee(childShows.getFee());
//				handlerShow.preUpdate();
//				dao.update(handlerShow);
//			}
			if ("7".equals(handlerShow.getShowType())
					&& ("none".equals(handlerShow.getTestLevel()) || "MASTER".equals(handlerShow.getTestLevel()))) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "宠物营养师考试，级别只能选A/B/C");
			}
			
			if(null != oldHandlerShow && !oldHandlerShow.getId().equals(id)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "活动编号重复");
			}
			
			handlerShow.preUpdate();
			dao.update(handlerShow);
		} else {// 添加
//			for (ChildShows childShows : childShowsList) {
//				String showCode = childShows.getShowCode();
//				if (null != showCode && !"".equals(showCode)) {
//					if ("7".equals(handlerShow.getShowType())
//							&& ("none".equals(childShows.getTestLevel()) || "MASTER".equals(childShows.getTestLevel())))
//						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "宠物营养师考试，级别只能选A/B/C");
//					HandlerShow hs = new HandlerShow();
//					hs.setShowCode(showCode);
//					hs.setTestLevel(childShows.getTestLevel());
//					hs.setFee(childShows.getFee());
//					hs.setStartTime(handlerShow.getStartTime());
//					hs.setEndTime(handlerShow.getEndTime());
//					hs.setRegisterEndTime(handlerShow.getRegisterEndTime());
//					hs.setReferee(handlerShow.getReferee());
//					hs.setShowAddress(handlerShow.getShowAddress());
//					hs.setShowType(handlerShow.getShowType());
//					hs.setShowName(handlerShow.getShowName());
//					hs.setRemarks(handlerShow.getRemarks());
//					hs.setShowPhoto(handlerShow.getShowPhoto());
//					super.save(hs);
//				}
//			}
			if ("7".equals(handlerShow.getShowType())
					&& ("none".equals(handlerShow.getTestLevel()) || "MASTER".equals(handlerShow.getTestLevel()))) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "宠物营养师考试，级别只能选A/B/C");

			}
			
			if(oldHandlerShow != null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "活动编号重复");
			}
			
			super.save(handlerShow);
		}
	}

	@Transactional(readOnly = false)
	public void delete(HandlerShow handlerShow) {
		super.delete(handlerShow);
	}

	// 赛事地点
	public List<String> getShowAddress() {
		return dao.getShowAddress();
	}

	/**
	 * 根据赛事编号获取活动信息
	 * 
	 * @Author chaixueteng
	 * @2016年9月1日下午3:41:05
	 */
	public HandlerShow getShow(String showCode) {
		return dao.getShow(showCode);
	}
	
	public void updateRegisterNum(String showCode , int num) {
		dao.updateRegisterNum(showCode , num);
	}

	/**
	 * 重复赛事验证
	 * 
	 * @Author chaixueteng
	 * @2016年9月6日下午6:56:30
	 */
	public String codeCheck(String showCode, String id) {
		String[] codes = showCode.split(",");
		for (int i = 0; i < codes.length; i++) {
			List<HandlerShow> list = dao.getByShowCode(codes[i]);
			if (list.size() > 0) {
				String id2 = list.get(0).getId();
				if (id == null) {
					return "{\"rc\":1,\"showCode\":\"" + codes[i] + "\"}";
				} else {
					if (!id.equals(id2)) {
						return "{\"rc\":1,\"showCode\":\"" + codes[i] + "\"}";
					}
				}
			}
		}
		return "{\"rc\":0}";
	}

	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public int handlerShowEndReceive() {
		// 获取结束的比赛
		List<HandlerShow> shows = dao.findEndHandler();
		int count = 0;
		for (HandlerShow show : shows) {
			HandlerRegister entity = new HandlerRegister();
			entity.setShowCode(show.getShowCode());
			List<HandlerRegister> registers = handlerRegisterDao.findList(entity);
			if (!CollectionUtils.isEmpty(registers)) {
				for (HandlerRegister reginster : registers) {
					if (saPaymentDetailTotalService.financeConfirmTime(reginster.getRunningNumber()) > 0) {
						count++;
					}
				}
			}
		}

		if (!CollectionUtils.isEmpty(shows)) {
			dao.updateShowStatus(shows);
		}
		return count;
	}

}