/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.handler.entity.HandlerDiploma;

/**
 * 结业证书DAO接口
 * @author 柴雪腾
 * @version 2016-08-08
 */
@MyBatisDao
public interface HandlerDiplomaDao extends CrudDao<HandlerDiploma> {
	///////////////////////////////////////////////---牵犬师---////////////////////////////
	//审核
	void review(HandlerDiploma handlerDiploma);
	//生成证书号
	void createCode(HandlerDiploma handlerDiploma);
	//未审核的结业列表
	List<HandlerDiploma> getDiplomaList();

	//导出的数据
	List<HandlerDiploma> getHandlerList(HandlerDiploma handlerDiploma);
	//重置打印
	void resetPrint(HandlerDiploma handlerDiploma);
	//获取结业证书等级
	List<String> getDiplomaLevel(String memberCode);
	//未处理的牵犬师结业证书
	int getHandlerDiplomaCount();
	///////////////////////////////////////////////---训犬师---////////////////////////////
	
	//训犬师列表
	List<HandlerDiploma> findTrainList(HandlerDiploma handlerDiploma);
	//训犬师列表App
	List<HandlerDiploma> findTrainListByApp(HandlerDiploma handlerDiploma);

	//重置打印
	void resetTarinPrint(HandlerDiploma handlerDiploma);
	//导出的数据
	List<HandlerDiploma> getTrainList(HandlerDiploma handlerDiploma);

	//生成证书号
	void createCodeTrain(HandlerDiploma handlerDiploma);
	//未审核的结业列表
	List<HandlerDiploma> getTrainDiplomaList();
	//未处理的训犬师结业证书
	int getTrainDiplomaCount();
	//得到输送学员数
	int getCount(String schoolNameCn);
	
	////////////////////////////////////////////
	
	//CKU官网 根据证书号或会员号查询证书
	List<HandlerDiploma> getByKey(@Param("key")String key, @Param("handlerType")String handlerType);
	
	int countBySchoolId(@Param("schoolId")String schoolId,@Param("endDate")String endDate);
}