/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.web;

import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.groomer.service.GroomerDiplomaService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.schools.mrschool.service.SchoolsCourseService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 美容师结业证书Controller
 * @author cxt
 * @version 2016-07-15
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerDiploma")
public class GroomerDiplomaController extends BaseController {

	@Autowired
	private GroomerDiplomaService groomerDiplomaService;
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	@Autowired
	private MemberService memberService;
	@Autowired
	private SchoolsCourseService schoolsCourseService;
	@ModelAttribute
	public GroomerDiploma get(@RequestParam(required=false) String id) {
		GroomerDiploma entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = groomerDiplomaService.get(id);
		}
		if (entity == null){
			entity = new GroomerDiploma();
		}
		return entity;
	}

	@RequiresPermissions("groomer:groomerDiploma:view")
	@RequestMapping(value = {"list", ""})
	public String list(GroomerDiploma groomerDiploma, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GroomerDiploma> page = groomerDiplomaService.findPage(new Page<GroomerDiploma>(request, response), groomerDiploma);
		model.addAttribute("page", page);
		return "oa/groomer/groomerDiplomaList";
	}

	@RequiresPermissions("groomer:groomerDiploma:edit")
	@RequestMapping(value = "form")
	public String form(GroomerDiploma groomerDiploma, Model model) {
		TrainingInstitution ti = new TrainingInstitution();
		List<TrainingInstitution> findList = trainingInstitutionDao.findGroomerList(ti);
		model.addAttribute("findList", findList);
		model.addAttribute("groomerDiploma", groomerDiploma);
		return "oa/groomer/groomerDiplomaForm";
	}
	@RequestMapping(value = "addform")
	public String addform(GroomerDiploma groomerDiploma, Model model) {
		TrainingInstitution ti = new TrainingInstitution();
		List<TrainingInstitution> findList = trainingInstitutionDao.findGroomerList(ti);
		model.addAttribute("findList", findList);
		model.addAttribute("groomerDiploma", groomerDiploma);
		return "oa/groomer/groomerDiplomaAdd";
	}

	/**
	 * 查看
	 * @Author chaixueteng
	 * @2016年8月27日上午10:38:52
	 */
	@RequiresPermissions("groomer:groomerDiploma:view")
	@RequestMapping(value = "view")
	public String view(GroomerDiploma groomerDiploma, Model model) {
		model.addAttribute("groomerDiploma", groomerDiploma);
		return "oa/groomer/groomerDiplomaView";
	}


	@RequiresPermissions("groomer:groomerDiploma:edit")
	@RequestMapping(value = "save")
	public String save(GroomerDiploma groomerDiploma, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, groomerDiploma)){
			return form(groomerDiploma, model);
		}
		try {
			groomerDiplomaService.save(groomerDiploma);
		} catch (Exception e) {
			addMessage(redirectAttributes,e.getMessage());
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerDiploma/addform";
		}
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerDiploma/?repage";
	}


	@RequiresPermissions("groomer:groomerDiploma:edit")
	@RequestMapping(value = "delete")
	public String delete(GroomerDiploma groomerDiploma, RedirectAttributes redirectAttributes) {
		groomerDiplomaService.delete(groomerDiploma);
		addMessage(redirectAttributes, "删除美容师结业证书成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerDiploma/?repage";
	}

	@RequestMapping(value = "reviewSave")
	public String reviewSave(GroomerDiploma groomerDiploma,RedirectAttributes redirectAttributes) throws Exception{
		try {
			groomerDiplomaService.review(groomerDiploma);
		} catch (Exception e) {
			addMessage(redirectAttributes,e.getMessage());
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerDiploma/review?id="+groomerDiploma.getId();
		}
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerDiploma/?repage";
	}
	/**
	 * 结业证书审核
	 * @Author chaixueteng
	 * @2016年9月2日下午2:26:21
	 */
	@RequiresPermissions("groomer:groomerDiploma:audit")
	@RequestMapping(value = "review")
	public String review(GroomerDiploma groomerDiploma, Model model, RedirectAttributes redirectAttributes) throws Exception{
		model.addAttribute("groomerDiploma", groomerDiploma);
		return "oa/groomer/groomerDiplomaAudit";
	}

	/**
	 * 生成证书编号和签发日期(批量)
	 * @Author chaixueteng
	 * @2016年8月17日上午10:00:36
	 */
	@RequiresPermissions("groomer:groomerDiploma:create")
	@RequestMapping("createCode")
	@ResponseBody
	public Object createCode(HttpServletRequest request, HttpServletResponse response){
		Map<String,Object> map=new HashMap<String,Object>();
		map.put("rc", "0");
		String id = request.getParameter("id");
		try {
			groomerDiplomaService.createCode(id);
		} catch (Exception e) {
			map.put("rc", "1");
        	map.put("msg", e.getMessage());
		}
		return map;
	}
	/**
	 * 生成证书编号和签发日期
	 * @Author chaixueteng
	 * @2016年8月17日上午10:00:36
	 */
	@RequiresPermissions("groomer:groomerDiploma:create")
	@RequestMapping("createCodeOne")
	public String createCodeOne(String id){
		groomerDiplomaService.createCode(id);
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerDiploma/?repage";
	}
	/**
	 * 证书导出
	 * @Author chaixueteng
	 * @2016年8月3日下午6:35:57
	 */
	@RequiresPermissions("groomer:groomerDiploma:export")
	@RequestMapping("export")
	public String export(GroomerDiploma groomerDiploma,HttpServletResponse response, RedirectAttributes redirectAttributes){
		try {
			groomerDiplomaService.export(groomerDiploma,response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出赛事信息失败！失败信息："+e.getMessage());
		}
		return null;
	}

	/**
	 * 批量通过
	 * @Author chaixueteng
	 * @2016年8月15日上午10:39:48
	 */
	@RequiresPermissions("groomer:groomerDiploma:audit")
	@RequestMapping("listSubmit")
	@ResponseBody
	public Object listSubmit(HttpServletRequest request, HttpServletResponse response,RedirectAttributes redirectAttributes){
		Map<String,Object> map=new HashMap<String,Object>();
		map.put("rc", "0");
		String id = request.getParameter("id");
		try {
			groomerDiplomaService.listSubmit(id);
		} catch (Exception e) {
			map.put("rc", "1");
        	map.put("msg", e.getMessage());
		}
		return map;
	}
	/**
	 * 打印
	 * @Author chaixueteng
	 * @2016年8月22日下午5:47:16
	 */
	@RequiresPermissions("groomer:groomerDiploma:print")
	@RequestMapping(value = "groomerDiplomaPrint")
	public String groomerDiplomaPrint(GroomerDiploma groomerDiploma, HttpServletRequest request, HttpServletResponse response, Model model) {
		GroomerDiploma gd =groomerDiplomaService.print(groomerDiploma);
		model.addAttribute("groomerDiploma", gd);
        return "oa/groomer/groomerDiplomaPrint";
    }
	/**
	 * 重置打印
	 * @Author chaixueteng
	 * @2016年8月22日下午5:47:58
	 */
	@RequiresPermissions("groomer:groomerDiploma:resetPrint")
	@RequestMapping(value = "resetPrint")
	public String resetPrint(String id, RedirectAttributes redirectAttributes){
		groomerDiplomaService.resetPrint(id);
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerDiploma/?repage";
	}


	/**
	 * 添加结业证书记录校验
	 * @Author chaixueteng
	 * @2017年7月11日下午7:57:46
	 */
	@RequestMapping(value = "getByMemberCode")
	@ResponseBody
	public Object getByMemberCode(HttpServletRequest requset){
		String memberCode = requset.getParameter("memberCode");
		return schoolsCourseService.checkStudent(memberCode);
	}


}