package com.cku.oa.groomer.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.groomer.dao.GroomerRegisterDao;
import com.cku.oa.groomer.dao.GroomerShowDao;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerShow;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * 美容师活动Service
 *
 * @author cxt
 * @version 2016-07-14
 */
@Service
@Transactional(readOnly = true)
public class GroomerShowService extends CrudService<GroomerShowDao, GroomerShow> {
	@Autowired
	private GroomerRegisterDao groomerRegisterDao;

	@Autowired
	private SaPaymentDetailTotalService saPaymentDetailTotalService;

	public GroomerShow get(String id) {
		return super.get(id);
	}

	public List<GroomerShow> findList(GroomerShow groomerShow) {
		return super.findList(groomerShow);
	}

	@Transactional(readOnly = false)
	public Page<GroomerShow> findPage(Page<GroomerShow> page, GroomerShow groomerShow) {
		Page<GroomerShow> findPage = super.findPage(page, groomerShow);
		return findPage;
	}

	@Transactional(readOnly = false)
	public void save(GroomerShow groomerShow) throws ZAException {
		// 验证时间
		validateTime(groomerShow);
		validateShowType(groomerShow);
		super.save(groomerShow);
	}

	/**
	 * 校验美容活动分类和类型的关系
	 *
	 * @author yuanshuai
	 * @date 2021/12/23 15:57
	 */
	private void validateShowType(GroomerShow groomerShow) {
		if (!"1".equals(groomerShow.getShowCategory())
				&& ("cathedra".equals(groomerShow.getShowType()) || "team".equals(groomerShow.getShowType()))) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "国际宠物美容师认证、CKU国际宠物洗护师认证、宠物造型师&国际宠物美容师认证，活动类型无法报名讲座或团体挑战赛！");
		}
	}

	@Transactional(readOnly = false)
	public void delete(GroomerShow groomerShow) {
		super.delete(groomerShow);
	}

	// 校验活动表的开始时间和结束时间及截止日期的关系
	public void validateTime(GroomerShow groomerShow) throws ZAException {
		Date startTime = groomerShow.getStartTime();
		Date endTime = groomerShow.getEndTime();
		Date registerEndTime = groomerShow.getRegisterEndTime();
		if (startTime.after(endTime)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "开始时间大于结束时间");
		}
		if (registerEndTime.after(startTime)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "截止日期大于开始日期");
		}
	}

	// 得到赛事类型
	public String getShowType(String showCode) {
		Map<String, String> map = getShowTypeMap(showCode);
		if (Objects.isNull(map)) {
			return null;
		}
		return JSONObject.fromObject(map).toString();
	}

	// 得到赛事类型
	public Map<String, String> getShowTypeMap(String showCode) {
		if (showCode != null && !"".equals(showCode)) {
			String[] code = showCode.split("-");
			System.out.println(code.length);
			String showCodeType = "";
			if (code.length > 2) {
				showCodeType = code[2];
			}
			GroomerShow show = dao.getShowType(showCode);
			Map<String, String> map = new HashMap<String, String>();
			map.put("showType", show.getShowType());
			map.put("showName", show.getShowName());
			map.put("showCodeType", showCodeType);
			return map;
		}
		return null;
	}

	public GroomerShow getShowCode(String showCode) {
		return dao.getShowCode(showCode);
	}

	// 得到赛事信息
	public String getShowMessage(String id) {
		if (id != null && !"".equals(id)) {
			GroomerShow groomerShow = dao.get(id);
			String testLevel = groomerShow.getTestLevel();
			String[] split = testLevel.split(",");
			return JSONArray.fromObject(split).toString();
		}
		return null;
	}

	/**
	 * 美容活动赛事重复验证
	 *
	 * @param id
	 * @Author chaixueteng
	 * @2016年9月6日下午5:20:24
	 */
	public String codeCheck(String showCode, String id) {
		List<GroomerShow> list = dao.getByShowCode(showCode);
		if (list.size() > 0) {
			String id2 = list.get(0).getId();
			if (id == null) {
				return "{\"rc\":false}";
			} else {
				if (!id.equals(id2)) {
					return "{\"rc\":false}";
				}
			}
		}
		return "{\"rc\":true}";
	}

	public Page<GroomerShow> findStatisticsPage(Page<GroomerShow> page, GroomerShow groomerShow) {
		Page<GroomerShow> findPage = super.findPage(page, groomerShow);
		List<GroomerShow> list = findPage.getList();
		long allShow = 0;// 场次
		long allfee = 0;// 收入总计
		long shower = 0;// 报名人数
		for (GroomerShow gs : list) {
			long feeNum = 0; // 总报名费收入
			long cancelFeeNum = 0;// 退赛费
			long dogNum = 0; // 参赛犬只
			long memberNum = 0;// 报名人数
			long leaveNum = 0;// 退赛人数
			long cancel = 0; // 请假人数
			long allFeeNum = 0;// 实际总额
			String showCode = gs.getShowCode();
			List<GroomerRegister> register = groomerRegisterDao.getRegister(showCode);
			memberNum = register.size();// 报名人数
			if (memberNum != 0) {
				for (GroomerRegister groomerRegister : register) {
					StringBuilder showDogBreed = new StringBuilder()
							.append(StringUtils.isBlank(groomerRegister.getShowDogBreed()) ? ""
									: groomerRegister.getShowDogBreed());
					if (showDogBreed.length() > 0) {
						showDogBreed.append(",");
					}
					showDogBreed.append(StringUtils.isBlank(groomerRegister.getShowDogBreedExtra()) ? ""
							: groomerRegister.getShowDogBreedExtra());
					if (showDogBreed.toString().contains(",")) {
						String[] split = showDogBreed.toString().split(",");
						for (int i = 0; i < split.length; i++) {
							if (!split[i].equals("无") || !"".equals(split[i])) {
								dogNum += 1;
							}
						}
					} else {
						dogNum += 1;
					}
					String fee = groomerRegister.getFee();
					if (fee.contains(".")) {
						String s = fee.replaceAll(".0+?$", "");
						feeNum += Long.parseLong(s);// 本场参赛费用累加
					} else {
						feeNum += Long.parseLong(fee);
					}
					String showLeave = groomerRegister.getShowLeave();// 退赛
					String leaveCancel = groomerRegister.getLeaveCancel();// 取消
					if ("1".equals(showLeave)) {
						leaveNum += 1;// 退赛人数累加
						if (fee.contains(".")) {
							String s = fee.replaceAll(".0+?$", "");
							cancelFeeNum += Long.parseLong(s);
						} else {
							cancelFeeNum += Long.parseLong(fee);
						}
					}
					if ("1".equals(leaveCancel)) {
						cancel += 1;// 请假人数累加
						if (fee.contains(".")) {
							String s = fee.replaceAll(".0+?$", "");
							cancelFeeNum += Long.parseLong(s);// 本场参赛费用累加
						} else {
							cancelFeeNum += Long.parseLong(fee);
						}
					}
				}
			}
			gs.setDogNum(dogNum);
			gs.setAllFeeNum(allFeeNum);
			gs.setMemberNum(memberNum);// 总人数
			gs.setFeeNum(feeNum);// 报名费总计
			gs.setLeaveNum(leaveNum);// 退赛人数
			gs.setCancel(cancel);// 请假人数
			gs.setCancelFeeNum(cancelFeeNum);
			gs.setAllFeeNum(feeNum - cancelFeeNum);
		}

		return findPage;
	}

	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public int groomerShowEndReceive() {
		// 获取今日结束的比赛/考试
		List<GroomerShow> shows = dao.findEndGroomer();
		int count = 0;
		for (GroomerShow show : shows) {
			GroomerRegister entity = new GroomerRegister();
			entity.setShowCode(show.getShowCode());
			List<GroomerRegister> registers = groomerRegisterDao.findList(entity);
			if (!CollectionUtils.isEmpty(registers)) {
				for (GroomerRegister reginster : registers) {
					if (saPaymentDetailTotalService.financeConfirmTime(reginster.getRunningNumber()) > 0) {
						count++;
					}
				}
			}
		}
		if (!CollectionUtils.isEmpty(shows)) {
			dao.updateShowStatus(shows);
		}
		return count;
	}

	public static void main(String[] args) {
		String a = null;
		System.out.println(new StringBuilder().append("").length());
	}
}