/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.constant.Constants;
import com.cku.oa.groomer.dao.GroomerQualificationCertificateDao;
import com.cku.oa.groomer.dao.GroomerRegisterDao;
import com.cku.oa.groomer.entity.*;
import com.cku.oa.groomer.enums.QualificationCertificateLevelEnum;
import com.cku.oa.groomer.enums.QualificationCertificateSourceEnum;
import com.cku.oa.groomer.vo.GroomerQualificationCertificateVO;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.FileService;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.service.user.GroomerMemberService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.Img2Base64Util;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 美容师资格证书Service
 *
 * @author cxt
 * @version 2016-07-22
 */
@Service
@Transactional(readOnly = true)
public class GroomerQualificationCertificateService
		extends CrudService<GroomerQualificationCertificateDao, GroomerQualificationCertificate> {

	@Autowired
	public GroomerMemberService groomerMemberService;
	@Autowired
	public RemindService remindService;
	@Autowired
	public GroomerRegisterDao groomerRegisterDao;
	@Autowired
	public ExpressQueueService expressQueueService;
	@Autowired
	public MemberService memberService;
	@Autowired
	private FileService fileService;

	@Autowired
	private GroomerShowRefereeService groomerShowRefereeService;

	@Autowired
	private FciGroomerQualificationCertificateService fciGroomerQualificationCertificateService;

	public GroomerQualificationCertificate get(String id) {
		return super.get(id);
	}

	public List<GroomerQualificationCertificate> findList(
			GroomerQualificationCertificate groomerQualificationCertificate) {
		return super.findList(groomerQualificationCertificate);
	}

	public List<GroomerQualificationCertificate> findListByMember(List<Member> memberList) {
		return dao.findListByMember(memberList);
	}

	public Page<GroomerQualificationCertificate> findPage(Page<GroomerQualificationCertificate> page,
	                                                      GroomerQualificationCertificate groomerQualificationCertificate) {
		groomerQualificationCertificate.setPage(page);
		logger.info("GroomerQualificationCertificateService findPage param : {}", JSONObjectUtils.toJsonString(groomerQualificationCertificate));
		List<GroomerQualificationCertificate> list = dao.queryGroomerQualificationCertificateAllInfo(groomerQualificationCertificate);
		logger.info("GroomerQualificationCertificateService queryGroomerQualificationCertificateAllInfo result : {}", JSONObjectUtils.toJsonString(list));

		page.setList(list);
		/*List<GroomerQualificationCertificate> pageList = page.getList();
		if (CollectionUtils.isNotEmpty(pageList)) {
			List<String> ids = list.stream().filter(item -> item.getPaymentState() != null && item.getPaymentState().equals("2"))
					.map(GroomerQualificationCertificate::getId).collect(Collectors.toList());
			logger.info("fciGroomerQualificationCertificateService.queryFciGroomerQualificationCertificateList ids : {}", JSONObjectUtils.toJsonString(ids));
			List<FciGroomerQualificationCertificate> fciGroomerQualificationCertificates = fciGroomerQualificationCertificateService.queryFciGroomerQualificationCertificateList(ids);
			logger.info("fciGroomerQualificationCertificateService.queryFciGroomerQualificationCertificateList result : {}", JSONObjectUtils.toJsonString(fciGroomerQualificationCertificates));
			Map<String, FciGroomerQualificationCertificate> map = new HashMap<>();
			if (CollectionUtils.isNotEmpty(fciGroomerQualificationCertificates)) {
				map = fciGroomerQualificationCertificates.stream().collect(Collectors.toMap(FciGroomerQualificationCertificate::getCertificateId, Function.identity(), (o,n) -> n));
			}
			for (GroomerQualificationCertificate qualificationCertificate : pageList) {
				qualificationCertificate.setFciGroomerQualificationCertificate(map.get(qualificationCertificate.getId()));
				Member member = memberService.getByMemberCode(qualificationCertificate.getMemberCode());
				Boolean b = MemberUtil.queryActiveMemberOrGroomerMember(member);

				qualificationCertificate.getGroomerShow().setEndDate();
			}
		}*/
		return page;
	}

	public Page<GroomerQualificationCertificate> findPageByJg(Page<GroomerQualificationCertificate> page,
														  GroomerQualificationCertificate groomerQualificationCertificate) {
		groomerQualificationCertificate.setPage(page);
		logger.info("GroomerQualificationCertificateService findPageByJg param : {}", JSONObjectUtils.toJsonString(groomerQualificationCertificate));
		List<GroomerQualificationCertificate> list = dao.queryGroomerQualificationCertificateAllInfoByJG(groomerQualificationCertificate);
		logger.info("GroomerQualificationCertificateService queryGroomerQualificationCertificateAllInfoByJG result : {}", JSONObjectUtils.toJsonString(list));

		page.setList(list);
		/*List<GroomerQualificationCertificate> pageList = page.getList();
		if (CollectionUtils.isNotEmpty(pageList)) {
			List<String> ids = list.stream().filter(item -> item.getPaymentState() != null && item.getPaymentState().equals("2"))
					.map(GroomerQualificationCertificate::getId).collect(Collectors.toList());
			logger.info("fciGroomerQualificationCertificateService.queryFciGroomerQualificationCertificateList ids : {}", JSONObjectUtils.toJsonString(ids));
			List<FciGroomerQualificationCertificate> fciGroomerQualificationCertificates = fciGroomerQualificationCertificateService.queryFciGroomerQualificationCertificateList(ids);
			logger.info("fciGroomerQualificationCertificateService.queryFciGroomerQualificationCertificateList result : {}", JSONObjectUtils.toJsonString(fciGroomerQualificationCertificates));
			Map<String, FciGroomerQualificationCertificate> map = new HashMap<>();
			if (CollectionUtils.isNotEmpty(fciGroomerQualificationCertificates)) {
				map = fciGroomerQualificationCertificates.stream().collect(Collectors.toMap(FciGroomerQualificationCertificate::getCertificateId, Function.identity(), (o,n) -> n));
			}
			for (GroomerQualificationCertificate qualificationCertificate : pageList) {
				qualificationCertificate.setFciGroomerQualificationCertificate(map.get(qualificationCertificate.getId()));
				Member member = memberService.getByMemberCode(qualificationCertificate.getMemberCode());
				Boolean b = MemberUtil.queryActiveMemberOrGroomerMember(member);

				qualificationCertificate.getGroomerShow().setEndDate();
			}
		}*/
		return page;
	}

	@Transactional(readOnly = false)
	public void save(GroomerQualificationCertificate groomerQualificationCertificate) {
		String nameEn = groomerQualificationCertificate.getMember().getNameEn();
		if (StringUtils.isNotBlank(nameEn)) {
			String id = groomerQualificationCertificate.getMember().getId();
			Member byMemberCode = memberService.get(id);
			byMemberCode.setNameEn(nameEn);
			memberService.updateNameEn(byMemberCode);
		}
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = groomerQualificationCertificate.getFciGroomerQualificationCertificate();
		if (Objects.nonNull(fciGroomerQualificationCertificate)) {
			fciGroomerQualificationCertificateService.save(fciGroomerQualificationCertificate);
		}
		super.save(groomerQualificationCertificate);
	}

	@Transactional(readOnly = false)
	public void delete(GroomerQualificationCertificate groomerQualificationCertificate) {
		super.delete(groomerQualificationCertificate);
	}

	/**
	 * 成绩录入通过生成证书
	 *
	 * @Author chaixueteng
	 * @2016年8月20日下午3:58:15
	 */
	@Transactional(readOnly = false)
	public void saveCertificate(GroomerQualificationCertificate groomerQualificationCertificate) {
		String memberCode = groomerQualificationCertificate.getMemberCode();
		String levelEn = groomerQualificationCertificate.getLevelEn();
		List<GroomerQualificationCertificate> list = dao.eqCertificate(memberCode, levelEn, groomerQualificationCertificate.getCertificateType());
		if (list.size() <= 0) {
			dao.insertCertificate(groomerQualificationCertificate);
		} else {// 如果同会员号同级别已有证书信息 则
			for (GroomerQualificationCertificate groomerQualificationCertificate2 : list) {
				groomerQualificationCertificate2.setRemarks("第二次考同级别证书,本证书作废!");
				dao.deleteCertificate(groomerQualificationCertificate2);
			}
			dao.insertCertificate(groomerQualificationCertificate);
		}
	}

	/**
	 * 查询会员的最新的级别
	 *
	 * @Author chaixueteng
	 * @2016年7月25日下午4:11:06
	 */
	public GroomerQualificationCertificate getLevel(String memberCode) {
		List<GroomerQualificationCertificate> list = dao.getLevel(memberCode);
		if (list.size() > 0) {
			GroomerQualificationCertificate gqc = list.get(0);
			if ("MASTER".equals(gqc.getLevelEn().trim())) {// 如果是教师资格证书
				return gqc;
			} else {// 不存在教师级证书 返回最大的级别
				return list.get(list.size() - 1);
			}
		}
		return null;
	}

	/**
	 * 生成资格证书号
	 *
	 * @Author chaixueteng
	 * @2016年8月3日下午1:40:03
	 */
	@Transactional(readOnly = false)
	public void createCode(String id) {
		GroomerQualificationCertificate gqc = super.get(id);
		// 生成证书号
		// 获取年份
		SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy");
		String certificateCode = null;
		try {
			String format = sDateFormat.format(new Date());
			// 证书生成号的年份改为赛事编号的年份
			// 造型师
			if ("3".equals(gqc.getCertificateType())) {
				// 判断申领状态
				if ("0".equals(gqc.getCertificateState())) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "宠物造型师申领状态必须为已申领");
				}
				if ("宠物造型师".equals(gqc.getLevelEn())) {
					// 宠物造型师
					certificateCode = getcertificateCode("S");
				}
				if ("金牌宠物造型师".equals(gqc.getLevelEn())) {
					// 金牌宠物造型师
					certificateCode = getcertificateCode("G");
				}
			} else if ("2".equals(gqc.getCertificateType())) {// 宠物美容师
				if ("国际高级宠物美容师".equals(gqc.getLevelEn())) {
					// 宠物造型师
					certificateCode = getcertificateCodeI("ISPG");
				}
				if ("国际宠物美容师".equals(gqc.getLevelEn())) {
					// 金牌宠物造型师
					certificateCode = getcertificateCodeI("IPG");
				}
			} else if ("4".equals(gqc.getCertificateType())) {
				certificateCode = getcertificateCodeIGA("IGA");
			} else if ("6".equals(gqc.getCertificateType())) {
				/**
				 * 6为派多格资格证书，同CKU资格证书一样的逻辑
				 */
				Date takeCertificateDate = sDateFormat.parse(gqc.getGroomerRegister().getShowCode().substring(0, 4));
				certificateCode = SysCodeUtil.getPDGGroomerQualificationCertificateCode(gqc.getLevelEn(),
						takeCertificateDate);
			} else if ("7".equals(gqc.getCertificateType())) {
				/**
				 * 7为Fci美容大赛资格证书，同CKU资格证书一样的逻辑
				 */
				Date takeCertificateDate = sDateFormat.parse(gqc.getGroomerRegister().getShowCode().substring(0, 4));
				certificateCode = SysCodeUtil.getPDGGroomerQualificationCertificateCode(gqc.getLevelEn(),
						takeCertificateDate);
			} else if ("8".equals(gqc.getCertificateType())) {
				certificateCode = getCatNurseCertificateCode(gqc.getLevelEn());
			} else {// 资格证书
				Date takeCertificateDate = sDateFormat.parse(gqc.getGroomerRegister().getShowCode().substring(0, 4));
				if ("MASTER".equals(gqc.getLevelEn())) {
					certificateCode = SysCodeUtil.getGroomerQualificationCertificateCode("M", takeCertificateDate);
				} else {
					certificateCode = SysCodeUtil.getGroomerQualificationCertificateCode(gqc.getLevelEn(),
							takeCertificateDate);
				}
			}
		} catch (ParseException e) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "赛事编号格式有误,请确保赛事编号前4位为年份");
		}

		// 保存证书号
		GroomerQualificationCertificate qualificationCertificate = new GroomerQualificationCertificate();
		qualificationCertificate.setId(id);
		qualificationCertificate.setCertificateCode(certificateCode);
		qualificationCertificate.setIssueDate(new Date());
		qualificationCertificate.setProccessState("1");
		qualificationCertificate.setProccessTime(new Date());
		dao.createCode(qualificationCertificate);

		if ("1".equals(gqc.getCertificateType())) {
			// 第一次申领资格证书 更改美容师会员为正式会员 类型为资格证书
			if (dao.checkFistApply(gqc.getMemberCode()) > 0) {
				groomerMemberService.updateMember(gqc.getMemberCode());
			}
		}

		remindService.addRemind("已收到您的申请，美容师资格证书制作周期为十个工作日，完成后通过快递寄出。请您随时关注会员中心里的快递信息，感谢您的支持！", gqc.getMemberCode());
		remindService.addMemberRemind("已收到您的申请，美容师资格证书制作周期为十个工作日，完成后通过快递寄出。感谢您的支持！", gqc.getMemberCode());
	}

	/**
	 * @Description: 宠物造型师
	 * @author: zhangxiang
	 * @date: 2021/4/16 14:11
	 */
	public synchronized String getcertificateCode(String name) {
		String yearStr = com.cku.util.DateUtils.getStringDateFormatter(new Date(), "yyyy");
		StringBuilder certificateNumPrefix = new StringBuilder().append("CKUPCC").append("-").append(name).append("-")
				.append(Calendar.getInstance().get(Calendar.YEAR));
		Integer maxNum = dao.selectMaxCertificateNum(certificateNumPrefix.toString()) + 1;
		// certificateNumPrefix.append(String.format("%04d", maxNum));
		return "CKUPCC" + "-" + name + "-" + yearStr
				+ SysCodeUtil.stringFormat(Long.parseLong(maxNum.toString()), "000");
	}

	/**
	 * @Description: 国际宠物美容师证书
	 * @author: zhangxiang
	 * @date: 2021/4/16 14:11
	 */
	public synchronized String getcertificateCodeI(String name) {
		String yearStr = com.cku.util.DateUtils.getStringDateFormatter(new Date(), "yyyy");
		StringBuilder certificateNumPrefix = new StringBuilder().append("CKU").append("-").append(name).append("-")
				.append(Calendar.getInstance().get(Calendar.YEAR));
		Integer maxNum = dao.selectMaxCertificateNumI(certificateNumPrefix.toString()) + 1;
		return "CKU" + "-" + name + "-" + yearStr + SysCodeUtil.stringFormat(Long.parseLong(maxNum.toString()), "0000");
	}

	public synchronized String getcertificateCodeIGA(String name) {
		LocalDate localDate = LocalDate.now();
		String year = Integer.toString(localDate.getYear());
		String month = Integer.toString(localDate.getMonthValue());
		String key = "CKU-" + name + "-" + year.substring(2, year.length()) + (month.length() < 2 ? "0" + month : month);
		int maxNum = dao.selectMaxCertificateNum(key);

		String number = "";
		if (maxNum == 0) {
			number = "0011";
		} else {
			number = SysCodeUtil.stringFormat(Long.parseLong(Integer.toString(maxNum + 1)), "0000");
		}
//		String yearStr = com.cku.util.DateUtils.getStringDateFormatter(new Date(), "yyyy");
//		StringBuilder certificateNumPrefix = new StringBuilder().append("CKU").append("-").append(name).append("-")
//				.append(Calendar.getInstance().get(Calendar.YEAR));
//		Integer maxNum = dao.selectMaxCertificateNumI(certificateNumPrefix.toString()) + 1;
//		return "CKU" + "-" + name + "-" + yearStr + SysCodeUtil.stringFormat(Long.parseLong(maxNum.toString()), "0000");
		return key + number;
	}


	public static void main(String[] args) {

	}

	/**
	 * 批量提醒
	 *
	 * @Author chaixueteng
	 * @2016年8月3日下午4:27:51
	 */
	@Transactional(readOnly = false)
	public void reminder(String ids) throws ZAException {
		String[] id = ids.split(",");
		for (int i = 0; i < id.length; i++) {
			GroomerQualificationCertificate gqc = dao.get(id[i]);
			String paymentState = gqc.getPaymentState();
			String memberCode = gqc.getMemberCode();
			String registerId = gqc.getRegisterId();
			GroomerRegister register = groomerRegisterDao.get(registerId);
			if (register != null) {
				Date date = new Date();
				Date gradeTime = register.getGradeTime();// 录入成绩的时间
				Calendar ca = Calendar.getInstance();
				ca.setTime(gradeTime);
				ca.add(Calendar.DATE, 180);// num为增加的天数，可以改变的
				Date date2 = ca.getTime();
				int day = getDay(date, date2);
				String showName = register.getGroomerShow().getShowName();
				// 未申领的才提醒
				if ("1".equals(paymentState)) {
					remindService.addMemberRemind("您参加" + showName.trim() + "的成绩将于" + day + "天后到期，请您及时申领资格证书，逾期将不可以办理。",
							memberCode);
				}
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "数据异常,请联系管理员");
			}
		}

	}

	/**
	 * 美容师资格证书导出(搜索维度)
	 *
	 * @throws IOException
	 * @Author chaixueteng
	 * @2016年8月3日下午4:49:12
	 */
	public void export(GroomerQualificationCertificate groomerQualificationCertificate, HttpServletResponse response)
			throws IOException {
		/*List<GroomerQualificationCertificate> gqcList = dao.getCertificateList(groomerQualificationCertificate);*/
		List<GroomerQualificationCertificateVO> gqcList = dao.exportGroomerQualificationCertificates(groomerQualificationCertificate);
		for (GroomerQualificationCertificateVO gqc : gqcList) {
			gqc.setGender("male".equals(gqc.getGender()) ? "男" : "女");
			if ("4".equals(gqc.getCertificateType())) {
				gqc.setLevelCn(DictUtils.getDictLabel(gqc.getLevelCn(), "groomer_nurse_level", null));

			}
		}
		String fileName = "美容师资格证书.xlsx";
		if ("2".equals(groomerQualificationCertificate.getCertificateType())) {
			fileName = "国际宠物美容师证书.xlsx";
		}
		if ("3".equals(groomerQualificationCertificate.getCertificateType())) {
			fileName = "宠物造型师证书.xlsx";
		}
		if ("4".equals(groomerQualificationCertificate.getCertificateType())) {
			fileName = "国际宠物洗护师证书.xlsx";
		}
		new ExportExcel("", GroomerQualificationCertificateVO.class, 2).setDataList(gqcList).write(response, fileName)
				.dispose();
	}

	/**
	 * 打印美容师资格证书
	 *
	 * @Author chaixueteng
	 * @2016年8月23日上午11:16:56
	 */
	@Transactional(readOnly = false)
	public GroomerQualificationCertificate print(String id) {
		GroomerQualificationCertificate gqc = super.get(id);
		SysContext sysContext = new SysContext(null, null, null);
		sysContext.noStateExecute(sysContext, "美容师资格证书打印", gqc.getMemberCode(), "groomer_qualification_certificate",
				gqc.getId(), gqc.getRunningNumber(), (str) -> {
				});
		gqc.setPrintState("1");
		dao.resetPrint(gqc);
		GroomerQualificationCertificate groomerQualificationCertificate = dao.print(id);
		Date takeCertificateDate = groomerQualificationCertificate.getTakeCertificateDate();
		Date issueDate = groomerQualificationCertificate.getIssueDate();
		String taskDate = "";
		String issDate = "";
		if (takeCertificateDate != null) {
			taskDate = DateUtils.formatDate(takeCertificateDate, "yyyy年M月d日");
		}
		if (issueDate != null) {
			if ("8".equals(groomerQualificationCertificate.getCertificateType())) {
				issDate = DateUtils.formatDate(issueDate, "yyyy-M-d");
			} else {
				issDate = DateUtils.formatDate(issueDate, "yyyy年M月d日");
			}
		}
		groomerQualificationCertificate.setTaskDate(taskDate);
		groomerQualificationCertificate.setIssDate(issDate);
		groomerQualificationCertificate.setId(id);
		if ("4".equals(groomerQualificationCertificate.getCertificateType())) {
			// 推送消息
			expressQueueService.push(gqc.getMemberCode(), gqc.getRunningNumber(), "美容师洗护证书", gqc.getCertificateCode(),
					null); // GYH2 TODO


		} else {
			// 推送消息
			expressQueueService.push(gqc.getMemberCode(), gqc.getRunningNumber(), "美容师资格证书", gqc.getCertificateCode(),
					null); // GYH2 TODO
		}

		ByteArrayOutputStream outPut = null;
		if (groomerQualificationCertificate.getMember().getAvatar() != null
				&& groomerQualificationCertificate.getMember().getAvatar().startsWith("http")) {
			groomerQualificationCertificate.setAvatarBase64(groomerQualificationCertificate.getMember().getAvatar());
		} else {
			try {
				BaseFile file = fileService.get(groomerQualificationCertificate.getMember().getAvatar());
				if (Objects.nonNull(file)) {
					outPut = new ByteArrayOutputStream();
					fileService.fileDownload(file, outPut);
					groomerQualificationCertificate.setAvatarBase64(
							"data:" + file.getType() + ";base64," + Img2Base64Util.getImgStr(outPut.toByteArray()));
				}
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				try {
					if (outPut != null)
						outPut.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		/*GroomerShowReferee groomerShowReferee = groomerShowRefereeService.getLikeGroomerShowReferee(groomerQualificationCertificate.getReviewer());
		logger.info("----------------------groomerShowReferee : {}---------------------------", JSONObjectUtils.toJsonString(groomerShowReferee));
		//判空
		if (Objects.nonNull(groomerShowReferee)) {
			//裁判名称
			groomerQualificationCertificate.setReferee((groomerQualificationCertificate.getReferee() == null ? "" : groomerQualificationCertificate.getReferee()) + groomerShowReferee.getRefereeNameEn() + ",");
			//拿到裁判签名
			BaseFile file = fileService.get(groomerShowReferee.getRefereeSignaturePhoto());
			ByteArrayOutputStream outPut1 = null;
			if (Objects.nonNull(file)) {
				outPut1 = new ByteArrayOutputStream();
				fileService.fileDownload(file, outPut1);
				groomerQualificationCertificate.setRefereeSignaturePicBase64("data:" + file.getType() + ";base64," + Img2Base64Util.getImgStr(outPut1.toByteArray()));
			}
		}*/
		groomerQualificationCertificate.setReferee(groomerQualificationCertificate.getReviewer());
		return groomerQualificationCertificate;
	}

	/**
	 * 重置打印
	 *
	 * @Author chaixueteng
	 * @2016年8月25日下午6:18:23
	 */
	@Transactional(readOnly = false)
	public void resetPrint(String id) {
		GroomerQualificationCertificate gqc = super.get(id);
		gqc.setPrintState("0");
		dao.resetPrint(gqc);
	}

	/**
	 * 未处理的资格证书申请
	 *
	 * @Author chaixueteng
	 * @2016年8月31日上午9:49:47
	 */
	public int getAuditCount() {
		return dao.getAuditCount();
	}

	/**
	 * 指定日期加上天数后的日期
	 */
	public int getDay(Date beginDate, Date endDate) {
		// 将转换的两个时间对象转换成Calendard对象
		Calendar can1 = Calendar.getInstance();
		can1.setTime(beginDate);
		Calendar can2 = Calendar.getInstance();
		can2.setTime(endDate);
		// 拿出两个年份
		int year1 = can1.get(Calendar.YEAR);
		int year2 = can2.get(Calendar.YEAR);
		// 天数
		int days = 0;
		Calendar can = null;
		// 如果can1 < can2
		// 减去小的时间在这一年已经过了的天数
		// 加上大的时间已过的天数
		if (can1.before(can2)) {
			days -= can1.get(Calendar.DAY_OF_YEAR);
			days += can2.get(Calendar.DAY_OF_YEAR);
			can = can1;
		} else {
			days -= can2.get(Calendar.DAY_OF_YEAR);
			days += can1.get(Calendar.DAY_OF_YEAR);
			can = can2;
		}
		for (int i = 0; i < Math.abs(year2 - year1); i++) {
			// 获取小的时间当前年的总天数
			days += can.getActualMaximum(Calendar.DAY_OF_YEAR);
			// 再计算下一年。
			can.add(Calendar.YEAR, 1);
		}
		System.out.println("天数差：" + days);
		return days;
	}

	/**
	 * 定时任务 每天凌晨1点执行删除(逻辑)180天未申领的资格证书
	 *
	 * @Author chaixueteng
	 * @2016年9月5日下午7:20:54
	 */
	@Transactional(readOnly = false)
	public int deleteQualificationCertificate() {
		int count = 0;
		/*
		 * GroomerQualificationCertificate groomerQualificationCertificate = new
		 * GroomerQualificationCertificate();
		 * groomerQualificationCertificate.setPaymentState("1");
		 * groomerQualificationCertificate.setDelFlag("0");
		 * List<GroomerQualificationCertificate> List =
		 * dao.findAllList(groomerQualificationCertificate); Calendar calendar =
		 * Calendar.getInstance();//日历对象 for (GroomerQualificationCertificate gqc :
		 * List) { if (gqc.getGroomerRegister()!=null) { Date gradeTime =
		 * gqc.getGroomerRegister().getGradeTime(); String paymentState =
		 * gqc.getPaymentState(); if
		 * (gradeTime!=null&&StringUtils.isNotBlank(paymentState)&&"1".equals(
		 * paymentState)) {//180天未缴费删除 calendar.setTime(gradeTime);//设置当前日期
		 * calendar.add(Calendar.DATE, 180);//天数+180 long timeInMillis =
		 * calendar.getTimeInMillis(); long time = new Date().getTime(); if
		 * (timeInMillis<time) {//超过180未申领 就删除该资格证书 dao.delete(gqc); count=count+1; } }
		 * } }
		 */
		return count;
	}

	/**
	 * 领取胸花
	 *
	 * @Author chaixueteng
	 * @2016年9月22日下午1:59:52
	 */
	public void updateCorsage(GroomerQualificationCertificate certificate) {
		dao.updateCorsage(certificate);
	}

	/**
	 * 根据报名id 得到资格证书
	 *
	 * @Author chaixueteng
	 * @2016年9月29日下午4:05:50
	 */
	public GroomerQualificationCertificate getRegister(String id) {
		return dao.getRegister(id);
	}

	/**
	 * 获取国际洗护师证书信息获取全部的报名信息
	 *
	 * @param memberCode
	 * @return
	 */
	public List<GroomerRegister> findNurseRegisterList(String memberCode) {
		return dao.findNurseRegisterList(memberCode);
	}

	/**
	 * 根据会员号查询资格证书（分页）
	 *
	 * @param memberCode
	 * @return
	 */
	public List<GroomerRegister> queryCertificateList(String memberCode, Integer pageNum, Integer pageSize) {
		logger.info("根据会员号查询资格证书 APP 使用 queryCertificateList param : {}, pageNum : {}, pageSize : {}", memberCode, pageNum, pageSize);
		List<GroomerRegister> groomerRegisters = dao.queryCertificateList(memberCode, pageNum, pageSize);
		logger.info("根据会员号查询资格证书 APP 使用 queryCertificateList result : {}", JSONObjectUtils.toJsonString(groomerRegisters));
		return groomerRegisters;
	}

	/**
	 * 根据会员和级别进行重复校验
	 *
	 * @author yuanshuai
	 * @since 2024/2/19 16:39
	 */
	public Boolean repeatValidateByMemberAndLevel(String memberCode, String levelEn) {
		return dao.findCountByMemberAndLevel(memberCode, levelEn) > Constants.NUM_ZERO;
	}

	/**
	 * 通过美容资格证书换发生成资格证书
	 * @author yuanshuai
	 * @since 2024/2/20 15:15
	 */
	@Transactional(readOnly = false)
	public void generateQualificationCertificate(GroomerQualificationCertificateChange groomerQCC) {
		Date now = new Date();
		GroomerQualificationCertificate gqc = new GroomerQualificationCertificate();
		gqc.preInsert();
		gqc.setCertificateSource(String.valueOf(groomerQCC.getCertificateSource()));
		gqc.setCertificateType("1");
		gqc.setCertificateCode(null);
		gqc.setRegisterId(null);
		gqc.setMemberCode(groomerQCC.getMemberCode());
		gqc.setCorsage(null);
		gqc.setPrintState("0");
		gqc.setRunningNumber(groomerQCC.getRunningNumber());
		gqc.setPaymentState("2");
		gqc.setPaymentTime(groomerQCC.getPaymentTime());
		gqc.setReviewState("0");
		gqc.setIssueDate(now);
		gqc.setProccessState("1");
		gqc.setProccessTime(now);
		gqc.setTakeCertificateDate(groomerQCC.getPaymentTime());
		gqc.setReviewer(groomerQCC.getReviewer());
		gqc.setIsFree("1");
		gqc.setLevelEn(groomerQCC.getCkuCertificateLevel());
		gqc.setLevelCn(DictUtils.getDictLabel(groomerQCC.getCkuCertificateLevel(), "groomer_qualification_level", null));
		//生成证书号
		String certificateCode;
		if (QualificationCertificateLevelEnum.MASTER.code().equals(gqc.getLevelEn())) {
			certificateCode = SysCodeUtil.getGroomerQualificationCertificateCode("M", groomerQCC.getPaymentTime());
		} else {
			certificateCode = SysCodeUtil.getGroomerQualificationCertificateCode(gqc.getLevelEn(), groomerQCC.getPaymentTime());
		}
		gqc.setCertificateCode(certificateCode);
		saveCertificate(gqc);
	}

	public GroomerQualificationCertificate getGroomerQualificationCertificateById(String id){
		logger.info("GroomerQualificationCertificateService getGroomerQualificationCertificateById id : {}", id);
		GroomerQualificationCertificate groomerQualificationCertificate = dao.getGroomerQualificationCertificateById(id);
		logger.info("GroomerQualificationCertificateService getGroomerQualificationCertificateById result : {}", JSONObjectUtils.toJsonString(groomerQualificationCertificate));
		return groomerQualificationCertificate;
	}

	/**
	 * 根据会员号和赛事级别查询资格证书
	 *
	 * @param memberCode
	 * @return
	 */
	public GroomerQualificationCertificate getByMemberCodeAndLevel(String memberCode, String showLevel) {
		logger.info("根据会员号查询资格证书 APP 使用 getByMemberCodeAndLevel param : {}", memberCode);
		GroomerQualificationCertificate groomerQualificationCertificate = dao.getByMemberCodeAndLevel(showLevel, memberCode);
		logger.info("根据会员号查询资格证书 APP 使用 getByMemberCodeAndLevel result : {}", JSONObjectUtils.toJsonString(groomerQualificationCertificate));
		return groomerQualificationCertificate;
	}

	/**
	 * 根据赛事活动查询派多格证书是否存在
	 *
	 * @param showCode
	 * @param memberCode
	 * @return
	 */
	public List<GroomerQualificationCertificate> getPdgByShowCodeAndMemberCode(String showCode, String memberCode) {
		logger.info("根据赛事编号和级别 查询 getPdgByShowCodeAndMemberCode param memberCode : {}, showCode : {}", memberCode, showCode);
		List<GroomerQualificationCertificate> groomerQualificationCertificateList = dao.getPdgByShowCodeAndMemberCode(showCode, memberCode);
		logger.info("根据赛事编号和级别 getPdgByShowCodeAndMemberCode result : {}", JSONObjectUtils.toJsonString(groomerQualificationCertificateList));
		return groomerQualificationCertificateList;
	}

	public void insertCertificate(GroomerQualificationCertificate qualificationCertificate) {
		dao.insertCertificate(qualificationCertificate);
	}

	/**
	 * @Description: 伴侣猫洗护
	 * @author: zhangxiang
	 * @date: 2021/4/16 14:11
	 */
	public synchronized String getCatNurseCertificateCode(String level) {
		// 获取当前年份后两位（动态）
		int currentYear = Calendar.getInstance().get(Calendar.YEAR) % 100;
		String yearSuffix = String.format("/%02d", currentYear); // 格式化为两位数

		// 确定证书类型前缀
		String typePrefix;
		switch (level) {
			case "PRIMARY LEVEL":
				typePrefix = "CKUGC-PRI";
				break;
			case "PROFESSIONAL LEVEL":
				typePrefix = "CKUGC-PRO";
				break;
			case "MASTER":
				typePrefix = "CKUGC-MAS";
				break;
			default:
				throw new IllegalArgumentException("Invalid test level");
		}

		// 查询当前年份该类型的最大序号
		int maxNum = dao.selectCatNurseMaxCertificateNum(yearSuffix);

		// 生成新序号（5位数字）
		Integer newNum = maxNum + 1;
		logger.info("-----yearSuffix : {},--------newNum : {}", yearSuffix, newNum);
		if ("/25".equals(yearSuffix) && newNum.compareTo(1) == 0) {
			newNum = 18;
		}
		String formattedNum = String.format("%05d", newNum); // 补零到5位

		// 构建完整证书号
		String newCertificate = typePrefix + formattedNum + yearSuffix;
		return newCertificate;
	}
}