package com.cku.oa.groomer.mq;

import java.time.LocalDateTime;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.cku.config.DelayedExchangeConfig;
import com.thinkgem.jeesite.common.config.Global;

@Component
public class DelayedMessageProducer {

	protected Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private RabbitTemplate rabbitTemplate;

	public void sendDelayedMessage(String message, Integer second) {
		String ROUTING_KEY = DelayedExchangeConfig.ROUTING_KEY;
		if (Global.isDevMode()) {
			String prefix = Global.getConfig("rabbitmq.queue.name.prefix");
			if (StringUtils.isNotBlank(prefix)) {
				logger.debug("++++++++prefix:" + prefix);
				ROUTING_KEY = prefix + "." + ROUTING_KEY;
			}
		}

		logger.debug("=============发送：" + LocalDateTime.now());
		logger.debug("=============内容：" + message);

		rabbitTemplate.convertAndSend(DelayedExchangeConfig.EXCHANGE_NAME, ROUTING_KEY, message,
				messagePostProcessor -> {
					messagePostProcessor.getMessageProperties().setDelay(second * 1000); // 设置延迟时间，单位毫秒
					return messagePostProcessor;
				});
	}

}
