package com.cku.oa.groomer.enums;

import com.cku.oa.sys.entity.user.IEnum;

import java.util.Objects;

/**
 * 实操考试状态
 * 对应数据字典 handler_grade
 * @author hjx
 */
public enum OperationExamStatusEnum implements IEnum<Integer> {

	FAIL(0, "未通过"),

	MISS_EXAM(1, "缺考"),

	PASSED(2, "通过"),

	EXCELLENT(3, "优秀奖"),

	EXTREMELY_EXCELLENT(4, "特别优秀奖"),

	BEST_OVERALL(12, "全场最佳"),

	FIRST(8, "第一名"),

	SECOND(9, "第二名"),

	THIRD(10, "第三名"),

	BE_PROMOTED(11, "晋级"),


	;

	private Integer code;

	private String message;

	OperationExamStatusEnum(Integer code, String message) {
		this.code = code;
		this.message = message;
	}

	public static OperationExamStatusEnum codeOf(Integer code) {
		for (OperationExamStatusEnum operationExamStatusEnum : OperationExamStatusEnum.values()) {
			if (Objects.equals(operationExamStatusEnum.getCode(), code)) {
				return operationExamStatusEnum;
			}
		}
		return null;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	@Override
	public Integer code() {
		return this.code;
	}

	@Override
	public String message() {
		return this.message;
	}

}
