/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.dao;

import java.util.List;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 美容师报名表DAO接口
 * 
 * @author cxt
 * @version 2016-07-14
 */
@MyBatisDao
public interface GroomerRegisterDao extends CrudDao<GroomerRegister> {
	// 成绩列表
	public List<GroomerRegister> findGradePage(GroomerRegister groomerRegister);

	// 根据会员号查询培训机构
	public String getSchoolNameCn(String memberCode);

	// 保存成绩
	public int inputGrade(GroomerRegister gr);

	// 修改请假取消的状态
	public void updateLeaveFlag(GroomerRegister groomerRegister);

	// 获取要导出的报名列表
	public List<GroomerRegister> getRegisterList(GroomerRegister groomerRegister);

	// 保存证件照带审核
	public void saveImage(GroomerRegister groomerRegister);

	// 得到考试的报名数
	public int getRegisterCount();

	// 得到比赛的报名数
	public int getRegisterMatchCount();

	// 报名信息
	public List<GroomerRegister> getRegister(String showCode);

	// 重复报名校验
	public List<GroomerRegister> getByRegister(@Param("memberCode") String memberCode,
			@Param("showCode") String showCode);

	public List<GroomerRegister> getGroomerRegister(@Param("memberCode") String memberCode);

	/**
	 *
	 * @Description：重置美容报名审核状态（宠爱王国使用） @author: zhuoHeng
	 * @version: 2016年12月15日 上午10:09:13
	 */
	public void changeReviewState(@Param("id") String id);

	// 领取资格证书（成绩为通过且同级别只显示一条）
	public List<GroomerRegister> findListWrite(GroomerRegister register);

	void refundGroomerRegister(@Param("vo") GroomerRegister vo, @Param("ids") Set<String> ids);
	
	public List<GroomerRegister> findListByMember(@Param("memberList")List<Member> memberList , @Param("showCode")String showCode);

}