/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.service;

import java.util.ArrayList;
import java.util.List;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.finance.dao.PaymentChargingItemDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.CacheUtils;

import edu.emory.mathcs.backport.java.util.Arrays;

/**
 * 收费项目Service
 *
 * @author lyy
 * @version 2016-07-21
 */
@Service
@Transactional(readOnly = true)
public class PaymentChargingItemService extends CrudService<PaymentChargingItemDao, PaymentChargingItem> {

	public PaymentChargingItem get(String id) {
		return super.get(id);
	}

	public List<PaymentChargingItem> findList(PaymentChargingItem paymentChargingItem) {
		return super.findList(paymentChargingItem);
	}

	public List<PaymentChargingItem> getFeesAndCharges() {
		return dao.getFeesAndCharges();
	}

	public List<PaymentChargingItem> findAllList(PaymentChargingItem paymentChargingItem) {
		List<PaymentChargingItem> result = null;
		if (CacheUtils.get("chargingItems") == null) {
			result = dao.findAllList(paymentChargingItem);
			CacheUtils.put("chargingItems", result);
		} else {
			result = (List<PaymentChargingItem>) CacheUtils.get("chargingItems");
		}

		return result;
	}

	public Page<PaymentChargingItem> findPage(Page<PaymentChargingItem> page, PaymentChargingItem paymentChargingItem) {
		return super.findPage(page, paymentChargingItem);
	}

	@Transactional(readOnly = false)
	public void save(PaymentChargingItem paymentChargingItem) {
		super.save(paymentChargingItem);
	}

	@Transactional(readOnly = false)
	public void delete(PaymentChargingItem paymentChargingItem) {
		super.delete(paymentChargingItem);
	}

	public PaymentChargingItem getByShortName(String shortName) {
		return dao.getByShortName(shortName);
	}

	/**
	 * @param code
	 *            根据部门编号查询部门的收费项
	 * @return
	 */
	public List<PaymentChargingItem> findListByDeptCode(String code) {
		List<PaymentChargingItem> reslut = new ArrayList<PaymentChargingItem>();
		List<PaymentChargingItem> list = dao.findListByDeptCode(code);
		// 非财务部门不可以退费
		if (code != null && code.length() > 0) {
			for (PaymentChargingItem paymentChargingItem : list) {
				if (!paymentChargingItem.getName().contains("退费")) {
					reslut.add(paymentChargingItem);
				}
			}
		} else {
			reslut = list;
		}
		return reslut;
	}

	/**
	 *	获得所有退费收费项
	 * @author yuanshuai
	 * @date 2021/5/24 14:29
	 */
	public List<PaymentChargingItem> findRefundItemList() {
		return dao.findRefundItemList();
	}

	public List<PaymentChargingItem> findListByIds(List<String> ids) {
		return dao.findListByIds(ids);
	}

	public List<PaymentChargingItem> findTypeList(String type) {
		return dao.findTypeList(type);
	}

	/**
	 * @Description：根据收费项目名称获取收费项目编号
	 * @author: zhuoHeng
	 * @version: 2016年7月25日 下午3:47:17
	 */
	public String getPaymentCode(String name) {

		String id;
		PaymentChargingItem PaymentChargingItem = new PaymentChargingItem();
		StringBuffer sb = new StringBuffer();
		sb.append("犬只参赛费（");
		sb.append(name + "）");
		PaymentChargingItem = dao.getPaymentCode(sb.toString());
		id = PaymentChargingItem.getId();

		return id;
	}
	
	public PaymentChargingItem getByName(String name) {
		return dao.getPaymentCode(name);
	}
	
	/**
	 * 通用通过收费项名称查收费项ID
	 * @param name
	 * @return
	 */
	public String getPaymentCodeGeneral(String name) {
		PaymentChargingItem PaymentChargingItem = dao.getPaymentCode(name);
		return PaymentChargingItem.getId();
	}

	/**
	 * @description: 根据收费项目shortName前缀查询
	 * @author: laiguanglong
	 * @date: 2016年7月29日 下午2:25:41
	 */
	public List<PaymentChargingItem> getByShortNamePrefix(String shortName) {
		return dao.getByShortNamePrefix(shortName);
	}

	/**
	 * 根据skuId获取列表
	 * @author yuanshuai
	 * @date 2023/6/19 11:38
	 */
	public List<PaymentChargingItem> findListBySkuId(String skuId) {
		if (StringUtils.isBlank(skuId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"商品ID为空");
		}
		return dao.findListBySkuId(skuId);
	}
	
	public List<PaymentChargingItem> findListByShortNames(String shortNames) {
		return  dao.findListByShortNames(Arrays.asList(shortNames.split(",")));
	}
	
	public String getShortNames(String ids) {
		List<PaymentChargingItem> list = dao.findListByIds(Arrays.asList(ids.split(",")));
		StringBuilder sb = new StringBuilder();
		list.stream().forEach(a->{
			sb.append(a.getShortName()).append(",");
		});
		return sb.substring(0,sb.length()-1);
	}
}