/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * OA订单录入组合收费项Entity
 *
 * @author 赖广龙
 * @version 2017-06-23
 */
public class PaymentChargingItemGroup extends DataEntity<PaymentChargingItemGroup> {

	private static final long serialVersionUID = 1L;
	private String name; // 名称
	private String price; // 金额
	private String couponDefId; // 金额
	private String businessRefund;// 业务退款 0不支持,1支持

	private String expansion1;

	private String expansion2;

	public String getExpansion1() {
		return expansion1;
	}

	public void setExpansion1(String expansion1) {
		this.expansion1 = expansion1;
	}

	public String getExpansion2() {
		return expansion2;
	}

	public void setExpansion2(String expansion2) {
		this.expansion2 = expansion2;
	}

	public String getBusinessRefund() {
		return businessRefund;
	}

	public void setBusinessRefund(String businessRefund) {
		this.businessRefund = businessRefund;
	}

	public PaymentChargingItemGroup() {
		super();
	}

	public PaymentChargingItemGroup(String id) {
		super(id);
	}

	@Length(min = 1, max = 60, message = "名称长度必须介于 1 和 60 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	public String getCouponDefId() {
		return couponDefId;
	}

	public void setCouponDefId(String couponDefId) {
		this.couponDefId = couponDefId;
	}

}