package com.cku.oa.dog.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.dog.entity.DogDnaParentsCompare;
import com.cku.oa.dog.entity.DogDnaParentsCompareAudit;
import com.cku.oa.dog.service.DogDnaParentsCompareAuditService;
import com.cku.oa.dog.service.DogDnaParentsCompareService;
import com.cku.oa.dog.vo.DogDnaParentsCompareVO;
import com.cku.oa.finance.service.PaymentOrderService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * DNA双亲比对Controller
 * 
 * @author lgl
 * @version 2016-11-24
 */
@Controller
@RequestMapping(value = "${adminPath}/dogdnaparentscompare/dogDnaParentsCompare")
public class DogDnaParentsCompareController extends BaseController {

	@Autowired
	private DogDnaParentsCompareService dogDnaParentsCompareService;

	@Autowired
	private DogDnaParentsCompareAuditService dogDnaParentsCompareAuditService;

	private final static String REPAGE = "redirect:" + Global.getAdminPath()
			+ "/dogdnaparentscompare/dogDnaParentsCompare/?repage";

	private final static String AUTHORITY_PRDFIX = "dogdnaparentscompare:dogDnaParentsCompare:";

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(@RequestParam(required = true) String runningNumber,
			@RequestParam(required = true) String chargingItemId, @RequestParam(required = true) String memberCode,
			Model model) {
		model.addAttribute("dogDnaParentsCompare", new DogDnaParentsCompare(runningNumber, chargingItemId, memberCode));
		return "oa/dog/dogdnaparentscompare/dogDnaParentsCompareOrderAdd";
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "add")
	@ResponseBody
	public Object add(DogDnaParentsCompare dogDnaParentsCompare) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogDnaParentsCompareService.add(dogDnaParentsCompare);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderList")
	public String orderList(DogDnaParentsCompare dogDnaParentsCompare, Model model) {
		List<DogDnaParentsCompare> list = dogDnaParentsCompareService.findList(dogDnaParentsCompare);
		// 双亲比对列表页面显示父母犬血统证书号
		dogDnaParentsCompareService.setParentsInfo(list);

		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(list.stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<DogDnaParentsCompareVO> list2 = list.stream().map(a -> {
			DogDnaParentsCompareVO b = new DogDnaParentsCompareVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		model.addAttribute("list", list2);

		return "oa/dog/dogdnaparentscompare/dogDnaParentsCompareOrderList";
	}

	@ModelAttribute
	public DogDnaParentsCompare get(@RequestParam(required = false) String id) {
		DogDnaParentsCompare entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogDnaParentsCompareService.get(id);
		}
		if (entity == null) {
			entity = new DogDnaParentsCompare();
		}
		return entity;
	}

	@Autowired
	private PaymentOrderService paymentOrderService;

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = { "list", "" })
	public String list(DogDnaParentsCompare dogDnaParentsCompare, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Page<DogDnaParentsCompareVO> pageResp = dogDnaParentsCompareService
				.findPageFB(new Page<DogDnaParentsCompare>(request, response), dogDnaParentsCompare);
		model.addAttribute("page", pageResp);
		return "oa/dog/dogdnaparentscompare/dogDnaParentsCompareList";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = "form")
	public String form(DogDnaParentsCompare dogDnaParentsCompare, Model model) {
		model.addAttribute("dogDnaParentsCompare", dogDnaParentsCompare);
		return "oa/dog/dogdnaparentscompare/dogDnaParentsCompareForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "save")
	public String save(DogDnaParentsCompare dogDnaParentsCompare, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogDnaParentsCompare)) {
			return form(dogDnaParentsCompare, model);
		}
		dogDnaParentsCompareService.save(dogDnaParentsCompare);
		addMessage(redirectAttributes, "保存DNA双亲比对信息成功");
		return REPAGE;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "delete")
	@RequestMapping(value = "delete")
	public String delete(DogDnaParentsCompare dogDnaParentsCompare, RedirectAttributes redirectAttributes) {
		dogDnaParentsCompareService.delete(dogDnaParentsCompare);
		addMessage(redirectAttributes, "删除DNA双亲比对信息成功");
		return REPAGE;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "auditForm")
	public String auditForm(String id, Model model) {
		model.addAttribute("dogDnaParentsCompare", dogDnaParentsCompareService.get(id));
		return "oa/dog/dogdnaparentscompare/dogDnaParentsCompareAuditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "audit")
	@ResponseBody
	public Object audit(DogDnaParentsCompare dogDnaParentsCompare) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogDnaParentsCompareService.audit(dogDnaParentsCompare);
		} catch (Exception e) {
			logger.warn("审核失败", e);
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "delete")
	@RequestMapping(value = "cancel")
	public String cancel(DogDnaParentsCompare dogDnaParentsCompare, RedirectAttributes redirectAttributes) {
		dogDnaParentsCompareService.cancel(dogDnaParentsCompare);
		addMessage(redirectAttributes, "撤销DNA双亲比对信息成功");
		return REPAGE;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "downgrade")
	@RequestMapping(value = "downgrade")
	public String downgrade(DogDnaParentsCompare dogDnaParentsCompare, RedirectAttributes redirectAttributes) {
		try {
			dogDnaParentsCompareService.downgrade(dogDnaParentsCompare);
			addMessage(redirectAttributes, "降级金质证书成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "降级失败：" + e.getMessage());
		}
		return REPAGE;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "auditFMdogForm")
	public String toAuditFMdogPage(String id, Model model) {
		model.addAttribute("dogDnaParentsCompareAudit", dogDnaParentsCompareAuditService.getByCompareId(id));
		return "oa/dog/dogdnaparentscompare/dogDnaParentsCompareFMdogAuditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "auditFMdog")
	@ResponseBody
	public Object auditFMdog(DogDnaParentsCompareAudit dogDnaParentsCompareAudit) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogDnaParentsCompareAuditService.auditFMdog(dogDnaParentsCompareAudit);
		} catch (Exception e) {
			logger.warn("审核失败", e);
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

}