/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.web;

import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogNoseDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogNose;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.dog.service.DogTypeShowService;
import com.cku.oa.dog.vo.request.DogChipNoSwapRequest;
import com.cku.restful.v1.dog.service.RestDogService;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.beanvalidator.BeanValidators;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 犬只信息管理Controller
 *
 * @author zhuoHeng
 * @version 2016-08-03
 */
@Controller
@RequestMapping(value = "${adminPath}/dog/dog")
public class DogController extends BaseController {

	@Autowired
	private DogService dogService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogTypeShowService dogTypeShowService;
	@Autowired
	private RestDogService restDogService;
	@Autowired
	private DogNoseDao dogNoseDao;
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogDao dogDao;

	@ModelAttribute
	public Dog get(@RequestParam(required = false) String id) {
		Dog entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogService.get(id);
		}
		if (entity == null) {
			entity = new Dog();
		}
		return entity;
	}

	@RequiresPermissions("dog:dog:view")
	@RequestMapping(value = {"list", ""})
	public String list(Dog dog, HttpServletRequest request, HttpServletResponse response, Model model,
					   @ModelAttribute("importError") String importError) throws UnsupportedEncodingException {
		/*
		 * //---- redis改造 start by zhuoHeng---- Page<Dog> page = new Page<Dog>(request,
		 * response); //获取请求参数 String parameter = request.getParameterMap().toString();
		 * //redis中查询是否有符合该key的数据 List<String> str =
		 * JedisUtils.getList(CaCheCode.DOG+parameter,true,CaCheCode.CACHE_SECONDS);
		 * //有则将redis中的数据赋值给list，无则查询数据库并将查询出的数据存入redis if(str == null){ page =
		 * dogService.findPage(new Page<Dog>(request, response), dog); List<Dog> dogList
		 * = page.getList(); List<Object> list = new ArrayList<Object>();
		 *
		 * for (Dog d : dogList) { list.add(d); } //缓存当前查询条件下的列表数据
		 * JedisUtils.setObjectList(CaCheCode.DOG+parameter,list,CaCheCode.CACHE_SECONDS
		 * ); //缓存当前查询条件下的列表数据总数 JedisUtils.set(CaCheCode.DOG_COUNT+parameter,
		 * Long.toString(page.getCount()), CaCheCode.CACHE_SECONDS); } else {
		 * //获取当前查询条件下的列表数据总数 String count =
		 * JedisUtils.get(CaCheCode.DOG_COUNT+parameter,true,CaCheCode.CACHE_SECONDS);
		 * page.setCount(Long.valueOf(count)); dog.setPage(page); List<Dog> dogList =
		 * new ArrayList<Dog>(); //获取当前查询条件下的缓存数据 List<Object> list =
		 * JedisUtils.getObjectList(CaCheCode.DOG+parameter); for (Object obj : list) {
		 * dogList.add((Dog)obj);
		 *
		 * } page.setList(dogList); } //---- redis改造 end by zhuoHeng----
		 * model.addAttribute("page", page); if("230".equals(dog.getDogBreed())){ return
		 * "oa/dog/dog/dogListTibetanMastiff"; } else { return "oa/dog/dog/dogList"; }
		 */
		Page<Dog> page = dogService.findPage(new Page<Dog>(request, response), dog);
		if (!CollectionUtils.isEmpty(page.getList())) {
			for (Dog data : page.getList()) {
				data.setEcertFlag(StringUtils.isBlank(data.getEcertFlag()) ? "0" : data.getEcertFlag());
				DogBirthCertificate certificate = dogBirthCertificateDao
						.getByBirthCerRegCode(data.getBirthCertificateLevelCode());
				DogNose dogNose = dogNoseDao.getByDogIdODogBirthCertificateId(
						(certificate == null ? "" : certificate.getId()), data.getId());
				if (dogNose != null) {
					data.setNoseFlag(dogNose.getId());
				} else {
					data.setNoseFlag("");
				}
				//处理人名出错
				data.setSecondDogOwner(StringEscapeUtils.unescapeHtml4(data.getSecondDogOwner()));
			}
		}

		model.addAttribute("page", page);
		model.addAttribute("importError", importError);
		if ("230".equals(dog.getDogBreed())) {
			return "oa/dog/dog/dogListTibetanMastiff";
		} else {
			return "oa/dog/dog/dogList";
		}
	}

	@RequiresPermissions("dog:dog:view")
	@RequestMapping(value = "form")
	public String form(Dog dog, Model model) {
		model.addAttribute("dogColorMarkList", dogColorMarkService.findAllList());
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		model.addAttribute("showDogBreedList", dogTypeShowService.findListByDogBreed(dog.getDogBreed()));
		model.addAttribute("dog", dog);
		return "oa/dog/dog/dogForm";
	}

	@RequiresPermissions("dog:dog:view")
	@RequestMapping(value = "save")
	public String save(Dog dog, Model model, RedirectAttributes redirectAttributes) {
		boolean hasPermission = false;
		if (!StringUtils.isEmpty(dog.getId())) {
			hasPermission = SecurityUtils.getSubject().isPermitted("dog:dog:edit");
		} else {
			hasPermission = SecurityUtils.getSubject().isPermitted("dog:dog:add");
		}
		if (hasPermission) {
			if (!beanValidator(model, dog)) {
				return form(dog, model);
			}
			if (dog.getNameEn() != null) {
				// 防止提交的特殊字符被转义
				dog.setNameEn(StringEscapeUtils.unescapeHtml4(dog.getNameEn()));
				dog.setSecondDogOwner(StringEscapeUtils.unescapeHtml4(dog.getSecondDogOwner()));
				dog.setDogOwner(StringEscapeUtils.unescapeHtml4(dog.getDogOwner()));
			}
			if (StringUtils.isNotEmpty(dog.getSecondDogOwner())) {
				dog.setSecondDogOwner(StringEscapeUtils.unescapeHtml4(dog.getSecondDogOwner()));
			}
			try {
				dogService.save(dog);
				addMessage(redirectAttributes, "保存犬只信息成功");
			} catch (Exception e) {
				logger.info("保存犬只信息失败:" + e.getMessage());
				addMessage(redirectAttributes, "保存犬只信息失败:" + e.getMessage());
			}
		} else {
			throw new UnauthenticatedException();
		}
		String breed = "";
		if ("230".equals(dog.getDogBreed())) {
			breed = "&dogBreed=230";
		}
		return "redirect:" + Global.getAdminPath() + "/dog/dog/?repage" + breed;
	}

	@RequiresPermissions("dog:dog:delete")
	@RequestMapping(value = "delete")
	public String delete(Dog dog, RedirectAttributes redirectAttributes) {
		dogService.delete(dog);
		addMessage(redirectAttributes, "删除犬只信息成功");
		String breed = "";
		if ("230".equals(dog.getDogBreed())) {
			breed = "&dogBreed=230";
		}
		return "redirect:" + Global.getAdminPath() + "/dog/dog/?repage" + breed;
	}

	/**
	 * @Description：查询犬只家族信息
	 * @author: zhuoHeng
	 * @version: 2016年8月27日 下午4:09:34
	 */
	@RequestMapping(value = "dogFamily")
	@ResponseBody
	public String getDogFamily(HttpServletRequest request) {
		String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
		String dogInfo = dogService.getDogFamily(pedigreeCertifiedCode);
		return dogInfo;
	}

	/**
	 * @Description：犬只信息查看页
	 * @author: zhuoHeng
	 * @version: 2016年8月27日 下午4:10:29
	 */
	@RequiresPermissions("dog:dog:view")
	@RequestMapping(value = "view")
	public String view(Dog dog, Model model) {
		model.addAttribute("dogColorMarkList", dogColorMarkService.findAllList());
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		model.addAttribute("showDogBreedList", dogTypeShowService.findListByDogBreed(dog.getDogBreed()));
		model.addAttribute("dog", dog);
		return "oa/dog/dog/dogView";
	}

	@RequestMapping(value = "reviewPicture")
	public String reviewPicture(Dog dog, Model model) {
		model.addAttribute("dogColorMarkList", dogColorMarkService.findAllList());
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		model.addAttribute("showDogBreedList", dogTypeShowService.findListByDogBreed(dog.getDogBreed()));
		model.addAttribute("dog", dog);
		return "oa/dog/dog/dogReviewPictureForm";
	}

	/**
	 * @Description： 根据你公母犬证书号向上查询三代共30只犬只信息
	 * @author: zhuoHeng
	 * @version: 2016年8月31日 下午1:59:08
	 */
	@RequestMapping(value = "kinBreedMessage")
	public String kinBreedMessage(HttpServletRequest request, Model model) {

		String fPedigreeCertifiedCode = request.getParameter("fPedigreeCertifiedCode");
		String mPedigreeCertifiedCode = request.getParameter("mPedigreeCertifiedCode");
		Map<String, Map<String, String>> map = dogService.getDogFamilyMessage(fPedigreeCertifiedCode,
				mPedigreeCertifiedCode);
		List<String> kinBreedMessage = dogService.kinBreedMessage(fPedigreeCertifiedCode, mPedigreeCertifiedCode);
		Dog fDog = dogService.getByPedigreeCertifiedCode(fPedigreeCertifiedCode);
		Dog mDog = dogService.getByPedigreeCertifiedCode(mPedigreeCertifiedCode);
		model.addAttribute("fDog", fDog);
		model.addAttribute("mDog", mDog);
		model.addAttribute("map", map);
		model.addAttribute("kinBreedMessage", kinBreedMessage);

		return "oa/dog/dognewborn/kinBreedMessage";
	}

	/**
	 * @description: 打印血统证书
	 * @author: laiguanglong
	 * @date: 2016年8月30日 下午5:50:04
	 */
	// 公众号-血统证书-更新电子证书版本
	@RequiresPermissions("dog:dog:print")
	@RequestMapping(value = "print")
	public String print(Dog print, HttpServletRequest request, Model model) {
		Dog dog = get(print.getId());
		return dogService.processPrintBusiness(dog, model, Boolean.TRUE);
	}

	/**
	 * @description: 重置打印
	 * @author: laiguanglong
	 * @date: 2016年8月30日 下午5:50:15
	 */
	@RequiresPermissions("dog:dog:resetPrint")
	@RequestMapping(value = "resetPrint")
	@ResponseBody
	public ResultDto<Boolean> resetPrint(Dog print) {
		dogService.resetPrint(print.getId());
		String breed = "";
		if ("230".equals(print.getDogBreed())) {
			breed = "&dogBreed=230";
		}
		return ResultDto.success(Boolean.TRUE);
	}

	/**
	 * 犬只血统证书号 唯一性校验
	 *
	 * @Author chaixueteng
	 * @2016年9月8日下午6:39:03
	 */
	@RequestMapping(value = "codeCheck")
	@ResponseBody
	public String codeCheck(HttpServletRequest request, HttpServletResponse response) {
		String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
		String id = request.getParameter("id");
		return dogService.codeCheck(pedigreeCertifiedCode, id);
	}

	/**
	 * 芯片号 唯一性校验
	 *
	 * @Author chaixueteng
	 * @2016年9月8日下午6:39:03
	 */
	@RequestMapping(value = "checkIdentification")
	@ResponseBody
	public String checkIdentification(HttpServletRequest request, HttpServletResponse response) {
		String identificationFlag = request.getParameter("identificationFlag");
		String id = request.getParameter("id");
		return dogService.checkIdentification(identificationFlag, id);
	}

	/**
	 * 跳转犬只信息页面
	 *
	 * @Author chaixueteng
	 * @2016年9月8日下午6:39:03
	 */
	@RequestMapping(value = "toDogInfoPage")
	public String toDogInfoPage() {
		return "oa/dog/doginfo/dog_info";
	}

	/**
	 * 犬只信息
	 *
	 * @Author chaixueteng
	 * @2016年9月8日下午6:39:03
	 */
	@RequestMapping(value = "dogInfo")
	@ResponseBody
	public void dogInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.getByKey(request, true);
		if (result.getData() != null && result.getData().get("data") != null) {
			restDogService.desensitize((JSONObject) result.getData().get("data"));
		}
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * (培训牵犬师大赛 查询狗信息接口)
	 *
	 * @Author chaixueteng
	 * @2017年8月31日下午2:57:55
	 */
	@RequestMapping(value = "getDogMsg")
	@ResponseBody
	public Object getDogMsg(HttpServletRequest request, HttpServletResponse response) {
		String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("rc", "0");
		try {
			map = dogService.getDogMsg(pedigreeCertifiedCode);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * @Description： 导入犬只信息的模板
	 * @author: yuanshuai
	 * @date: 2019年5月30日10:49:37
	 */
	@RequiresPermissions("dog:dog:import")
	@RequestMapping(value = "import/template")
	public String importFileTemplate(HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			return dogService.importFileTemplate(response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入模板下载失败！失败信息：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/dog/dog/?repage";
	}

	/**
	 * 导入犬只信息
	 *
	 * @author: yuanshuai
	 * @date: 2019年5月30日10:49:41
	 */
	@RequiresPermissions("dog:dog:import")
	@RequestMapping(value = "import", method = RequestMethod.POST)
	public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			// 会员信息导入
			dogService.importMember(file);
			addMessage(redirectAttributes, "导入犬只信息成功！");
		} catch (Exception e) {
			redirectAttributes.addFlashAttribute("importError", "导入犬只信息失败！失败信息：##" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/dog/dog/?repage";
	}

	@RequestMapping("/dogPictureReviewState")
	public String dogPictureReviewStateCount(Model model, HttpServletResponse response, HttpServletRequest request, Dog dog) {
		//List<Dog> pictureReviewStateList = dogDao.getPictureReviewStateList();
		Page<Dog> page = dogService.findPicturePage(new Page<Dog>(request, response), dog);
		List<Dog> list = page.getList();
		for (Dog dog1 : list) {
			dog1.setColorFlag(dogColorMarkService.getDogColorMarkCnSimple(dog1.getColorFlag()));
			DogType dogType = dogTypeService.getByDogBreedCode(dog1.getDogBreed());
			String dogBreedCnName = dogType == null ? "" : dogType.getBreedCnName();
			dog1.setDogBreed(dogBreedCnName);
		}
		model.addAttribute("page", page);
		return "oa/dog/dog/dogPictureReview";
	}

	@RequestMapping("/pictureReview")
	public String pictureReview(HttpServletResponse response, HttpServletRequest request) {

		String id = request.getParameter("id");
		String pictureReviewState = request.getParameter("pictureReviewState");
		String pictureReviewRemark = request.getParameter("pictureReviewRemark");

		String[] split = id.split(",");
		for (int i = 0; i < split.length; i++) {
			Dog dog = dogDao.get(split[i]);
			if (dog != null) {
				dog.setPictureReviewRemark(pictureReviewRemark);
				dog.setPictureReviewState(pictureReviewState);
				dogDao.update(dog);
			}
		}

		return "redirect:" + Global.getAdminPath() + "/dog/dog/dogPictureReviewState/?repage";
	}

	@RequestMapping(value = "/select")
	public String editMemberType() {
		return "oa/dog/dog/reviewStateEditForm";
	}

	@RequiresPermissions("dog:dog:chipNoSwap")
	@RequestMapping(value = "chipNoSwapForm")
	public String chipNoSwapForm(Model model) {
		model.addAttribute("dogChipNoSwap", DogChipNoSwapRequest.builder().build());
		return "oa/dog/dog/dogChipNoSwapForm";
	}

	@ApiOperation(value = "根据出生纸编号交换犬只芯片号")
	@RequiresPermissions("dog:dog:chipNoSwap")
	@PostMapping(value = "/chipNoSwap/birthCode")
	@ResponseBody
	public ResultDto<Boolean> chipNoSwapByBirthCode(DogChipNoSwapRequest request) {
		try {
			BeanValidators.validateWithException(validator, request);
			dogService.chipNoSwapByBirthCode(request);
		} catch (ZAException e) {
			e.printStackTrace();
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, "芯片对调失败：" + e.getMessage());
		}
		return ResultDto.success(Boolean.TRUE);
	}
}