package com.cku.oa.dog.service;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogDnaParentsCompareAuditDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogDnaParentsCompareAudit;
import com.cku.oa.dog.enums.DnaParentsCompareApplySourceEnum;
import com.cku.oa.dog.enums.DogDnaParentsCompareAuditReviewStateEnum;
import com.cku.oa.dog.vo.DogDnaParentsCompareAuditVO;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.UserService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.restful.v1.dog.vo.response.GoldCertifiedAuditDetailResp;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * DNA双亲比对审核表Service
 * 
 * @author xx
 * @version 2024-04-25
 */
@Service
@Transactional(readOnly = true)
public class DogDnaParentsCompareAuditService
		extends CrudService<DogDnaParentsCompareAuditDao, DogDnaParentsCompareAudit> {

	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;

	@Autowired
	private MemberService memberService;

	@Autowired
	private DogService dogService;

	@Autowired
	private UserService userService;

	public DogDnaParentsCompareAudit get(String id) {
		return super.get(id);
	}

	public List<DogDnaParentsCompareAudit> findList(DogDnaParentsCompareAudit dogDnaParentsCompareAudit) {
		return super.findList(dogDnaParentsCompareAudit);
	}

	public Page<DogDnaParentsCompareAudit> findPage(Page<DogDnaParentsCompareAudit> page,
			DogDnaParentsCompareAudit dogDnaParentsCompareAudit) {
		return super.findPage(page, dogDnaParentsCompareAudit);
	}

	@Transactional(readOnly = false)
	public void save(DogDnaParentsCompareAudit dogDnaParentsCompareAudit) {
		super.save(dogDnaParentsCompareAudit);
	}

	@Transactional(readOnly = false)
	public void delete(DogDnaParentsCompareAudit dogDnaParentsCompareAudit) {
		super.delete(dogDnaParentsCompareAudit);
	}

	@Transactional(readOnly = false)
	public void save(String birthCode, String dogDnaParentsCompareId, Integer applySource) {
		String memberCode = null;
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.getParentsByBirthCerRegCode(birthCode);
		if (DnaParentsCompareApplySourceEnum.PEDIGREE_CERTIFIED_UPGRADE.code().equals(applySource)) {
			// 血统证书升级时，申请犬只的犬主与父母犬主为同一人时自动审核同意
			Dog dog = dogService.getByBirthCertificateLevelCode(birthCode);
			memberCode = dog.getMemberCode();
		} else if (DnaParentsCompareApplySourceEnum.BIRTH_APPLY.code().equals(applySource)) {
			// 登记卡申请时。申请犬只的新犬主与父母犬为同一人时自动审核同意
			memberCode = dogBirthCertificate.getTempMemberCode();
		} else {
			return;
		}

		if (!Objects.isNull(dogBirthCertificate)) {
			Member member = memberService.getByMemberCode(memberCode);
			DogDnaParentsCompareAudit dogDnaParentsCompareAudit = new DogDnaParentsCompareAudit();
			dogDnaParentsCompareAudit.setDogDnaParentsCompareId(dogDnaParentsCompareId);
			dogDnaParentsCompareAudit.setFdogPedigreeCertified(dogBirthCertificate.getFdogPedigreeCertified());
			dogDnaParentsCompareAudit.setMdogPedigreeCertified(dogBirthCertificate.getMdogPedigreeCertified());
//			String userId = UserUtils.getLoginUser().getId();
			// 父母犬审核人是本人时，设置为自动动通过
			if (StringUtils.equals(memberCode, dogBirthCertificate.getfMemberCode())) {
				dogDnaParentsCompareAudit.setFdogMemberCode(memberCode);
				dogDnaParentsCompareAudit.setFdogReviewState(DogDnaParentsCompareAuditReviewStateEnum.AGREED.code());
				dogDnaParentsCompareAudit.setFdogReviewUserId(member.getUserId());//审核人变为实际的公母犬主     userId 是否需要实际的操作人？
				dogDnaParentsCompareAudit.setFdogMemberName(member.getName());
				dogDnaParentsCompareAudit.setFdogReviewTime(new Date());
				dogDnaParentsCompareAudit.setFdogReviewRemarks("自动审核同意");
			} else {
				dogDnaParentsCompareAudit.setFdogReviewState(DogDnaParentsCompareAuditReviewStateEnum.UNAUDITED.code());
			}
			if (StringUtils.equals(memberCode, dogBirthCertificate.getMMemberCode())) {
				dogDnaParentsCompareAudit.setMdogMemberCode(memberCode);
				dogDnaParentsCompareAudit.setMdogReviewState(DogDnaParentsCompareAuditReviewStateEnum.AGREED.code());
				dogDnaParentsCompareAudit.setMdogReviewUserId(member.getUserId());
				dogDnaParentsCompareAudit.setMdogMemberName(member.getName());
				dogDnaParentsCompareAudit.setMdogReviewTime(new Date());
				dogDnaParentsCompareAudit.setMdogReviewRemarks("自动审核同意");
			} else {
				dogDnaParentsCompareAudit.setMdogReviewState(DogDnaParentsCompareAuditReviewStateEnum.UNAUDITED.code());
			}
			super.save(dogDnaParentsCompareAudit);
		}

	}

	public List<DogDnaParentsCompareAuditVO> findPageFC(Page<DogDnaParentsCompareAudit> page,
			DogDnaParentsCompareAuditVO dogDnaParentsCompareAudit) {
		dogDnaParentsCompareAudit.setPage(page);
		dogDnaParentsCompareAudit.setMemberCode(UserUtils.getLoginMember().getMemberCode());
		return dao.findPageFC(dogDnaParentsCompareAudit);
	}

	public GoldCertifiedAuditDetailResp detail(String id) {
		DogDnaParentsCompareAuditVO vo = dao.getByIdFC(id);
		if (Objects.isNull(vo)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未找到审核记录");
		}
		GoldCertifiedAuditDetailResp resp = new GoldCertifiedAuditDetailResp();
		BeanUtils.copyProperties(vo, resp);
		resp.setPedigreeCertifiedCode(vo.getPedigreeCertified());
		if (StringUtils.isNotBlank(vo.getBirthCode())) {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateService
					.getParentsByBirthCerRegCode(vo.getBirthCode());
			resp.setFmdogBreedCertifiedCode(dogBirthCertificate.getFmdogBreedCertifiedCode());
		}
		if (StringUtils.isNotBlank(vo.getFdogReviewUserId())) {
			Member member = memberService.getByUserId(vo.getFdogReviewUserId());
			User user = UserUtils.get(vo.getFdogReviewUserId());
			// 工作人员后台审核的需要显示协会
			resp.setFdogReviewUser("1".equals(user.getUserType()) ? "协会" : member.getName());
		}
		if (StringUtils.isNotBlank(vo.getMdogReviewUserId())) {
			Member member = memberService.getByUserId(vo.getMdogReviewUserId());
			User user = UserUtils.get(vo.getMdogReviewUserId());
			// 工作人员后台审核的需要显示协会
			resp.setMdogReviewUser("1".equals(user.getUserType()) ? "协会" : member.getName());
		}

		return resp;
	}

	public DogDnaParentsCompareAuditVO getByIdFC(String id) {
		return dao.getByIdFC(id);
	}

	@Transactional(readOnly = false)
	public int updateAuditById(DogDnaParentsCompareAudit entity) throws Exception {
		entity.preUpdate();
		return dao.updateAuditById(entity);
	}

	public DogDnaParentsCompareAuditVO getByCompareId(String dogDnaParentsCompareId) {
		DogDnaParentsCompareAuditVO vo = dao.getByCompareId(dogDnaParentsCompareId);
		Set<String> userIdSet = new HashSet<>();
		userIdSet.add(vo.getFdogReviewUserId());
		userIdSet.add(vo.getMdogReviewUserId());
		Map<String, String> nameMap = userService.getNameMapByIds(userIdSet.stream().collect(Collectors.toList()));
		vo.setFdogReviewUserName(
				StringUtils.isNotBlank(vo.getFdogReviewUserId()) ? nameMap.get(vo.getFdogReviewUserId()) : null);
		vo.setMdogReviewUserName(
				StringUtils.isNotBlank(vo.getMdogReviewUserId()) ? nameMap.get(vo.getMdogReviewUserId()) : null);
		return vo;
	}

	@Transactional(readOnly = false)
	public Boolean auditFMdog(DogDnaParentsCompareAudit dogDnaParentsCompareAudit) throws Exception {
		if (StringUtils.isBlank(dogDnaParentsCompareAudit.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "ID为空");
		}
		DogDnaParentsCompareAuditVO vo = getByIdFC(dogDnaParentsCompareAudit.getId());
		if (Objects.isNull(vo)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审核记录不可操作");
		}
		if (StringUtils.equals(vo.getFdogReviewState(), dogDnaParentsCompareAudit.getFdogReviewState())
				&& StringUtils.equals(vo.getMdogReviewState(), dogDnaParentsCompareAudit.getMdogReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未修改审核状态");
		}
		User user = UserUtils.getLoginUser();
		DogDnaParentsCompareAudit entity = new DogDnaParentsCompareAudit();
		entity.setId(dogDnaParentsCompareAudit.getId());
		boolean isdone = false;
		// 审核父犬
		if (!StringUtils.equals(vo.getFdogReviewState(), dogDnaParentsCompareAudit.getFdogReviewState()) && !StringUtils
				.equals(vo.getFdogReviewState(), DogDnaParentsCompareAuditReviewStateEnum.AGREED.code())) {
			//协会每次审核都要修改成当前犬主
			Dog dog = dogService.getByPedigreeCertifiedCode(vo.getFdogPedigreeCertified());
			entity.setFdogMemberCode(dog.getMemberCode());
			entity.setFdogMemberName(dog.getDogOwner());
			entity.setFdogReviewUserId(user.getId());
			entity.setFdogReviewTime(new Date());
			entity.setFdogReviewState(dogDnaParentsCompareAudit.getFdogReviewState());
			entity.setFdogReviewRemarks(dogDnaParentsCompareAudit.getFdogReviewRemarks());
			isdone = true;
		}
		// 审核母犬
		if (!StringUtils.equals(vo.getMdogReviewState(), dogDnaParentsCompareAudit.getMdogReviewState()) && !StringUtils
				.equals(vo.getMdogReviewState(), DogDnaParentsCompareAuditReviewStateEnum.AGREED.code())) {
			Dog dog = dogService.getByPedigreeCertifiedCode(vo.getMdogPedigreeCertified());
			entity.setMdogMemberCode(dog.getMemberCode());
			entity.setMdogMemberName(dog.getDogOwner());
			entity.setMdogReviewUserId(user.getId());
			entity.setMdogReviewTime(new Date());
			entity.setMdogReviewState(dogDnaParentsCompareAudit.getMdogReviewState());
			entity.setMdogReviewRemarks(dogDnaParentsCompareAudit.getMdogReviewRemarks());
			isdone = true;
		}
		if (isdone) {
			updateAuditById(entity);
		}

		return Boolean.TRUE;

	}

	public Boolean cherkByOrderCodes(List<String> orderCodes) {
		if(CollectionUtils.isEmpty(orderCodes)) {
			return Boolean.TRUE;
		}
		List<DogDnaParentsCompareAuditVO> auditList = dao.findByOrderCodes(orderCodes);
		auditList.forEach(audit -> {
			if (!Objects.isNull(audit)) {
				cherkAudit(audit, Boolean.FALSE);
			}
		});

		return Boolean.TRUE;
	}

	public void cherkAudit(DogDnaParentsCompareAuditVO audit, Boolean isParents) {
		String code = StringUtils.isNotBlank(audit.getPedigreeCertified()) ? audit.getPedigreeCertified()
				: audit.getBirthCode();
		if (!StringUtils.equals(audit.getMdogReviewState(), DogDnaParentsCompareAuditReviewStateEnum.AGREED.code())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					isParents ? "随金质证书同时办理的DNA位点业务，需父母犬主同意双亲比对后方可绑定采样包" : code + "母犬主未同意双亲对比！");
		}
		if (!StringUtils.equals(audit.getFdogReviewState(), DogDnaParentsCompareAuditReviewStateEnum.AGREED.code())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					isParents ? "随金质证书同时办理的DNA位点业务，需父母犬主同意双亲比对后方可绑定采样包" : code + "父犬主未同意双亲对比！");
		}
	}

	public Boolean cherkByOrderCode(String orderCode, String pedigreeCertified) {
		DogDnaParentsCompareAuditVO audit = dao.findByOrderCode(orderCode);
		if (!Objects.isNull(audit)) {
			Boolean isParents = StringUtils.equals(audit.getFdogPedigreeCertified(), pedigreeCertified)
					|| StringUtils.equals(audit.getMdogPedigreeCertified(), pedigreeCertified);
			cherkAudit(audit, isParents);
		}

		return Boolean.TRUE;
	}

	/**
	 * 判断能否邮寄，并按照订单号返回判断结果
	 * 返回false表示校验未通过
	 * 
	 * @param orderCodes
	 * @return
	 */
	public Map<String, Boolean> cherkByOrderCodesToMap(List<String> orderCodes) {
		Map<String, Boolean> map = Maps.newHashMap();
		if(CollectionUtils.isEmpty(orderCodes)) {
			return map;
		}
		List<DogDnaParentsCompareAuditVO> auditList = dao.findByOrderCodes(orderCodes);
		auditList.forEach(audit -> {
			if (!Objects.isNull(audit)) {
				Boolean f = !StringUtils.equals(audit.getMdogReviewState(),
						DogDnaParentsCompareAuditReviewStateEnum.AGREED.code())
						|| !StringUtils.equals(audit.getFdogReviewState(),
								DogDnaParentsCompareAuditReviewStateEnum.AGREED.code());
				map.put(audit.getRunningNumber(), !f);
			}
		});

		return map;
	}

}