/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬只等级贴纸申请Entity
 *
 * @author lgl
 * @version 2018-11-21
 */
public class DogStickerApply extends DataEntity<DogStickerApply> {

	private static final long serialVersionUID = 1L;
	private String identificationFlag; // 芯片号
	private String cabPassport; // 宠爱护照号
	private String dogBreed; // 犬种号
	private String dogGender; // 犬性别
	private String paymentMemberCode; // 付款会员号
	private String paymentMemberName; // 付款会员姓名
	private String applyClass; // 申请等级
	private String alreadyHaveClass; // 已有等级
	private String needNewPassport; // 是否需要新护照:0不需要;1需要
	private String needReturnOldPassport; // 是否需要寄回旧护照:0不需要;1需要
	private String registerCardPrintFlag; // 登记卡打印标识:NULL不需要打印;0未打印;1已打印
	private String stickerPrintFlag; // 贴纸打印标识:0未打印;1已打印
	private Date sendDate; // 邮寄日期
	private String pedigreeCertified; // 血统证书号
	private String nameEn; // 犬只英文名
	private String runningNumber; // 流水号
	private String paymentState; // 付款的状态：未支付1；已支付2
	private Date paymentTime; // 付款时间
	private String stickerStates;
	private String colorFlag;
	private String breedCnName;
	private String cabRegisterCode;
	private String kennnelName;
	private String businessStates;
	private Date birthday;

	private String ecertFlag; // 电子证书标记位：0否；1是

	private String birthCerRegCode;
	
	public String getEcertFlag() {
		return ecertFlag;
	}

	public void setEcertFlag(String ecertFlag) {
		this.ecertFlag = ecertFlag;
	}

	public String getBusinessStates() {
		return businessStates;
	}

	public void setBusinessStates(String businessStates) {
		this.businessStates = businessStates;
	}

	public String getKennnelName() {
		return kennnelName;
	}

	public void setKennnelName(String kennnelName) {
		this.kennnelName = kennnelName;
	}

	public String getCabRegisterCode() {
		return cabRegisterCode;
	}

	public void setCabRegisterCode(String cabRegisterCode) {
		this.cabRegisterCode = cabRegisterCode;
	}

	public Date getBirthday() {
		return birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	public String getBreedCnName() {
		return breedCnName;
	}

	public void setBreedCnName(String breedCnName) {
		this.breedCnName = breedCnName;
	}

	public String getColorFlag() {
		return colorFlag;
	}

	public void setColorFlag(String colorFlag) {
		this.colorFlag = colorFlag;
	}

	public String getStickerStates() {
		return stickerStates;
	}

	public void setStickerStates(String stickerStates) {
		this.stickerStates = stickerStates;
	}

	public DogStickerApply() {
		super();
	}

	public DogStickerApply(String id) {
		super(id);
	}

	@Length(min = 1, max = 20, message = "芯片号长度必须介于 1 和 20 之间")
	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}

	@Length(min = 1, max = 20, message = "宠爱护照号长度必须介于 1 和 20 之间")
	public String getCabPassport() {
		return cabPassport;
	}

	public void setCabPassport(String cabPassport) {
		this.cabPassport = cabPassport;
	}

	@Length(min = 1, max = 20, message = "犬种号长度必须介于 1 和 20 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	@Length(min = 1, max = 1, message = "犬性别长度必须介于 1 和 1 之间")
	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	@Length(min = 1, max = 20, message = "付款会员号长度必须介于 1 和 20 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min = 1, max = 20, message = "付款会员姓名长度必须介于 1 和 20 之间")
	public String getPaymentMemberName() {
		return paymentMemberName;
	}

	public void setPaymentMemberName(String paymentMemberName) {
		this.paymentMemberName = paymentMemberName;
	}

	@Length(min = 1, max = 50, message = "申请等级长度必须介于 1 和 50 之间")
	public String getApplyClass() {
		return applyClass;
	}

	public void setApplyClass(String applyClass) {
		this.applyClass = applyClass;
	}

	@Length(min = 1, max = 50, message = "已有等级长度必须介于 1 和 50 之间")
	public String getAlreadyHaveClass() {
		return alreadyHaveClass;
	}

	public void setAlreadyHaveClass(String alreadyHaveClass) {
		this.alreadyHaveClass = alreadyHaveClass;
	}

	public String getNeedNewPassport() {
		return needNewPassport;
	}

	public void setNeedNewPassport(String needNewPassport) {
		this.needNewPassport = needNewPassport;
	}

	public String getNeedReturnOldPassport() {
		return needReturnOldPassport;
	}

	public void setNeedReturnOldPassport(String needReturnOldPassport) {
		this.needReturnOldPassport = needReturnOldPassport;
	}

	@Length(min = 0, max = 1, message = "登记卡打印标识:NULL不需要打印;0未打印;1已打印长度必须介于 0 和 1 之间")
	public String getRegisterCardPrintFlag() {
		return registerCardPrintFlag;
	}

	public void setRegisterCardPrintFlag(String registerCardPrintFlag) {
		this.registerCardPrintFlag = registerCardPrintFlag;
	}

	@Length(min = 1, max = 1, message = "贴纸打印标识:0未打印;1已打印长度必须介于 1 和 1 之间")
	public String getStickerPrintFlag() {
		return stickerPrintFlag;
	}

	public void setStickerPrintFlag(String stickerPrintFlag) {
		this.stickerPrintFlag = stickerPrintFlag;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getSendDate() {
		return sendDate;
	}

	public void setSendDate(Date sendDate) {
		this.sendDate = sendDate;
	}

	@Length(min = 1, max = 20, message = "血统证书号长度必须介于 1 和 20 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	@Length(min = 1, max = 200, message = "犬只英文名长度必须介于 1 和 200 之间")
	public String getNameEn() {
		return nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}

	@Length(min = 1, max = 50, message = "流水号长度必须介于 1 和 50 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 1, max = 1, message = "付款的状态：未支付1；已支付2长度必须介于 1 和 1 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	// 后台查询条件
	private String identificationFlagLike; // 芯片号模糊查询条件
	private String pedigreeCertifiedLike; // 血统证书号模糊查询条件
	private String cabPassportLike; // 宠爱护照号模糊查询条件
	private String paymentMemberCodeLike; // 付款会员号模糊查询条件
	private String paymentMemberNameLike; // 付款会员姓名模糊查询条件
	private String applyClassLike; // 申请等级模糊查询条件
	private String identificationFlagAndPedigreeCertifiedLike; // 芯片号和血统证书号模糊查询条件
	private Date createDateStart; // 申请时间开始
	private Date createDateEnd; // 申请时间结束

	public String getIdentificationFlagLike() {
		return identificationFlagLike;
	}

	public void setIdentificationFlagLike(String identificationFlagLike) {
		this.identificationFlagLike = identificationFlagLike;
	}

	public String getPedigreeCertifiedLike() {
		return pedigreeCertifiedLike;
	}

	public void setPedigreeCertifiedLike(String pedigreeCertifiedLike) {
		this.pedigreeCertifiedLike = pedigreeCertifiedLike;
	}

	public String getCabPassportLike() {
		return cabPassportLike;
	}

	public void setCabPassportLike(String cabPassportLike) {
		this.cabPassportLike = cabPassportLike;
	}

	public String getPaymentMemberCodeLike() {
		return paymentMemberCodeLike;
	}

	public void setPaymentMemberCodeLike(String paymentMemberCodeLike) {
		this.paymentMemberCodeLike = paymentMemberCodeLike;
	}

	public String getPaymentMemberNameLike() {
		return paymentMemberNameLike;
	}

	public void setPaymentMemberNameLike(String paymentMemberNameLike) {
		this.paymentMemberNameLike = paymentMemberNameLike;
	}

	public String getApplyClassLike() {
		return applyClassLike;
	}

	public void setApplyClassLike(String applyClassLike) {
		this.applyClassLike = applyClassLike;
	}

	public String getIdentificationFlagAndPedigreeCertifiedLike() {
		return identificationFlagAndPedigreeCertifiedLike;
	}

	public void setIdentificationFlagAndPedigreeCertifiedLike(String identificationFlagAndPedigreeCertifiedLike) {
		this.identificationFlagAndPedigreeCertifiedLike = identificationFlagAndPedigreeCertifiedLike;
	}

	public Date getCreateDateStart() {
		return createDateStart;
	}

	public void setCreateDateStart(Date createDateStart) {
		this.createDateStart = createDateStart;
	}

	public Date getCreateDateEnd() {
		return createDateEnd;
	}

	public void setCreateDateEnd(Date createDateEnd) {
		this.createDateEnd = createDateEnd;
	}

	public String getBirthCerRegCode() {
		return birthCerRegCode;
	}

	public void setBirthCerRegCode(String birthCerRegCode) {
		this.birthCerRegCode = birthCerRegCode;
	}
	
	
}