/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 证书补做Entity
 * @author lgl
 * @version 2016-08-11
 */
public class DogPedigreeCertifiedRedo extends DataEntity<DogPedigreeCertifiedRedo> {

	private static final long serialVersionUID = 1L;
	private String dogId;		// 犬只信息表主键
	private String originalPedigreeCertified;		// 原血统证书号
	private String currentPedigreeCertified;		// 新血统证书号
	private String paymentMemberCode;		// 付款会员号
	private String operator;		// 操作人
	private String price;		// 价格
	private String changeType;		// 证书补做类型
	private String stickerFlag;//申请贴纸标识:0不申请;1申请
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核的意见
	private String runningNumber;		// 流水号
	private String paymentState;		// 付款的状态
	private Date paymentTime;		// 付款时间
	private Date processTime;		// 流程变更的时间
	private String processState;		// 流程状态
	private Date beginCreateDate;		// 开始 create_date
	private Date endCreateDate;		// 结束 create_date
	private String dogOwnerName;		// 犬主姓名
	private String dogGender;		// 犬性别
	private String paymentChargingItemId;		//收费项id
	private String dogBreed;		//犬种
	private String printState;		//打印状态
	private String token; //宠爱王国访问令牌
	private String callName;    //呼名

	public DogPedigreeCertifiedRedo() {
		super();
	}

	public DogPedigreeCertifiedRedo(String id){
		super(id);
	}

	public DogPedigreeCertifiedRedo(String runningNumber,String paymentChargingItemId,String paymentMemberCode){
		this.runningNumber = runningNumber;
		this.paymentChargingItemId = paymentChargingItemId;
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min=0, max=64, message="犬只信息表主键长度必须介于 0 和 64 之间")
	public String getDogId() {
		return dogId;
	}

	public void setDogId(String dogId) {
		this.dogId = dogId;
	}

	@Length(min=0, max=64, message="原血统证书号长度必须介于 0 和 64 之间")
	public String getOriginalPedigreeCertified() {
		return originalPedigreeCertified;
	}

	public void setOriginalPedigreeCertified(String originalPedigreeCertified) {
		this.originalPedigreeCertified = originalPedigreeCertified;
	}

	@Length(min=0, max=64, message="新血统证书号长度必须介于 0 和 64 之间")
	public String getCurrentPedigreeCertified() {
		return currentPedigreeCertified;
	}

	public void setCurrentPedigreeCertified(String currentPedigreeCertified) {
		this.currentPedigreeCertified = currentPedigreeCertified;
	}

	@Length(min=0, max=64, message="付款会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min=0, max=200, message="操作人长度必须介于 0 和 200 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min=0, max=64, message="证书补做类型长度必须介于 0 和 64 之间")
	public String getChangeType() {
		return changeType;
	}

	public void setChangeType(String changeType) {
		this.changeType = changeType;
	}

	public String getStickerFlag() {
		return stickerFlag;
	}

	public void setStickerFlag(String stickerFlag) {
		this.stickerFlag = stickerFlag;
	}

	@Length(min=0, max=20, message="审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min=0, max=50, message="审核的意见长度必须介于 0 和 50 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min=0, max=20, message="付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}

	@Length(min=0, max=20, message="流程状态长度必须介于 0 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public String getDogOwnerName() {
		return dogOwnerName;
	}

	public void setDogOwnerName(String dogOwnerName) {
		this.dogOwnerName = dogOwnerName;
	}

	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}

	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}

	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getCallName() {
		return callName;
	}

	public void setCallName(String callName) {
		this.callName = callName;
	}
}