/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.math.BigDecimal;
import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.cku.oa.sys.entity.Org;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 新生犬登记Entity
 * @author zhuoHeng
 * @version 2016-08-04
 */
public class DogChip extends DataEntity<DogChip> {

	private static final long serialVersionUID = 1L;
	private String birthCode;		// 出生纸编号
	private String dnaSaveWay;		// DNA留存方式:血样留存0；DNA位点分析1；暂不留存2
	private String isDnaParentsCompare;		// DNA双亲比对标记位：0否；1是
	private String paymentMemberCode;		// 付款会员号
	private String operator;		// 操作人
	private String price;		// 订单价格
	private String hospitalName;		// 医院名称
	private String hospitalCode;		// 医院编号
	private String bloodSaveFlag;		//是否采血(仅在血统证书业务该字段有用)：0未采血；1已采血
	private String dogChipChangeId;		// dog_chip_change表主键
	private Date delTime;		// 删除时间
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核的意见
	private String runningNumber;		// 流水号
	private String paymentState;		// 付款的状态
	private Date paymentTime;		// 付款时间
	private Date processTime;		// 流程变更的时间
	private String processState;		// 流程状态
	private Date sendDate;		// 邮寄日期
	private String stickerFlag;//申请贴纸标识:0不申请;1申请
	private String printSource;     //打印来源：null未打印；0OA打印；1合作机构打印
	private String printState;     //打印状态
	private String dogOwner;     //犬表犬主人字段
	private Date printTime;        //打印时间
	private Date endDate;		//查询条件申请时间使用的截止时间
	private Date chipInjectDate; //查询条件芯片注入时间的 开始时间
	private Date endInjectDate; //查询条件芯片注入时间的截止时间
	private String isCanceled;//撤销状态
	private Date canceledDate;//撤销开始时间
	private Date canceledEndDate;//撤销结束时间
	private Date processStartDate;//处理开始时间
	private Date processEndDate;//处理结束时间
	private String processUserId;//处理人id
	private Date applyDate;			// 申请日期
	private String ecertFlag;	//电子证书标记位：0否；1是
	private String isAll;	//是否整窝办理：是：1 、否：0
	private String haddleWay;	//办理方式：0、自助办理 1、合作机构办理

	private DogBirthCertificate dogBirthCertificate;
	private Org sysOrg;

	private String identificationFlag;		// 身份识别标志
	private String businessState;		// 业务状态

	private String dogBreed;  //犬只种类
	private String callName;    //呼名

	private String chipInjectFlag;    //地方俱乐部芯片代打标识
	private String fmdogBreedCertifiedCode;//配种证明号

	private String reviewStateExclud; // 排除的审核状态

	private String noseId;
	
	private String province;

	//鼻纹判空（0为空，1为录入）
	private String noseState;
	//芯片判空（0为空，1为录入）
	private String identificationFlagState;
	
	private BigDecimal floatingPrice = BigDecimal.ZERO;

	private String oldHaddleWay;
	public String getHaddleWay() {
		return haddleWay;
	}

	public void setHaddleWay(String haddleWay) {
		this.haddleWay = haddleWay;
	}

	public String getNoseId() {
		return noseId;
	}

	public void setNoseId(String noseId) {
		this.noseId = noseId;
	}

	public String getReviewStateExclud() {
		return reviewStateExclud;
	}

	public void setReviewStateExclud(String reviewStateExclud) {
		this.reviewStateExclud = reviewStateExclud;
	}

	public String getFmdogBreedCertifiedCode() {
		return fmdogBreedCertifiedCode;
	}

	public void setFmdogBreedCertifiedCode(String fmdogBreedCertifiedCode) {
		this.fmdogBreedCertifiedCode = fmdogBreedCertifiedCode;
	}


	public String getIsAll() {
		return isAll;
	}

	public void setIsAll(String isAll) {
		this.isAll = isAll;
	}

	public DogChip() {
		super();
	}

	public DogChip(String id){
		super(id);
	}

	@Length(min=0, max=64, message="出生纸编号长度必须介于 0 和 64 之间")
	public String getBirthCode() {
		return birthCode;
	}

	public void setBirthCode(String birthCode) {
		this.birthCode = birthCode;
	}

	public String getDnaSaveWay() {
		return dnaSaveWay;
	}

	public void setDnaSaveWay(String dnaSaveWay) {
		this.dnaSaveWay = dnaSaveWay;
	}

	public String getIsDnaParentsCompare() {
		return isDnaParentsCompare;
	}

	public void setIsDnaParentsCompare(String isDnaParentsCompare) {
		this.isDnaParentsCompare = isDnaParentsCompare;
	}

	@Length(min=0, max=64, message="付款会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min=0, max=64, message="操作人长度必须介于 0 和 64 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min=0, max=64, message="医院名称长度必须介于 0 和 64 之间")
	public String getHospitalName() {
		return hospitalName;
	}

	public void setHospitalName(String hospitalName) {
		this.hospitalName = hospitalName;
	}

	@Length(min=0, max=64, message="医院编号长度必须介于 0 和 64 之间")
	public String getHospitalCode() {
		return hospitalCode;
	}

	public void setHospitalCode(String hospitalCode) {
		this.hospitalCode = hospitalCode;
	}

	public String getBloodSaveFlag() {
		return bloodSaveFlag;
	}

	public void setBloodSaveFlag(String bloodSaveFlag) {
		this.bloodSaveFlag = bloodSaveFlag;
	}

	public String getDogChipChangeId() {
		return dogChipChangeId;
	}

	public void setDogChipChangeId(String dogChipChangeId) {
		this.dogChipChangeId = dogChipChangeId;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getDelTime() {
		return delTime;
	}

	public void setDelTime(Date delTime) {
		this.delTime = delTime;
	}

	@Length(min=0, max=20, message="审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min=0, max=255, message="审核的意见长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min=0, max=20, message="付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}

	@Length(min=0, max=20, message="流程状态长度必须介于 0 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}

	public Date getSendDate() {
		return sendDate;
	}

	public void setSendDate(Date sendDate) {
		this.sendDate = sendDate;
	}

	public String getStickerFlag() {
		return stickerFlag;
	}

	public void setStickerFlag(String stickerFlag) {
		this.stickerFlag = stickerFlag;
	}

	public String getPrintSource() {
		return printSource;
	}

	public void setPrintSource(String printSource) {
		this.printSource = printSource;
	}

	public DogBirthCertificate getDogBirthCertificate() {
        return dogBirthCertificate;
    }

    public void setDogBirthCertificate(DogBirthCertificate dogBirthCertificate) {
        this.dogBirthCertificate = dogBirthCertificate;
    }

    public String getPrintState() {
        return printState;
    }

    public Date getPrintTime() {
        return printTime;
    }

    public void setPrintState(String printState) {
        this.printState = printState;
    }

    public void setPrintTime(Date printTime) {
        this.printTime = printTime;
    }

	public String getDogOwner() {
		return dogOwner;
	}

	public void setDogOwner(String dogOwner) {
		this.dogOwner = dogOwner;
	}

	public Org getSysOrg() {
        return sysOrg;
    }

    public void setSysOrg(Org sysOrg) {
        this.sysOrg = sysOrg;
    }

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Date getEndInjectDate() {
		return endInjectDate;
	}

	public void setEndInjectDate(Date endInjectDate) {
		this.endInjectDate = endInjectDate;
	}

	public Date getChipInjectDate() {
		return chipInjectDate;
	}

	public void setChipInjectDate(Date chipInjectDate) {
		this.chipInjectDate = chipInjectDate;
	}

	public String getIsCanceled() {
		return isCanceled;
	}

	public void setIsCanceled(String isCanceled) {
		this.isCanceled = isCanceled;
	}

	public Date getCanceledDate() {
		return canceledDate;
	}

	public Date getCanceledEndDate() {
		return canceledEndDate;
	}

	public void setCanceledDate(Date canceledDate) {
		this.canceledDate = canceledDate;
	}

	public void setCanceledEndDate(Date canceledEndDate) {
		this.canceledEndDate = canceledEndDate;
	}

	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}

	public String getBusinessState() {
		return businessState;
	}

	public void setBusinessState(String businessState) {
		this.businessState = businessState;
	}

	public Date getProcessStartDate() {
		return processStartDate;
	}

	public void setProcessStartDate(Date processStartDate) {
		this.processStartDate = processStartDate;
	}

	public Date getProcessEndDate() {
		return processEndDate;
	}

	public void setProcessEndDate(Date processEndDate) {
		this.processEndDate = processEndDate;
	}

	public String getProcessUserId() {
		return processUserId;
	}

	public void setProcessUserId(String processUserId) {
		this.processUserId = processUserId;
	}

	public Date getApplyDate() {
		return applyDate;
	}

	public void setApplyDate(Date applyDate) {
		this.applyDate = applyDate;
	}

	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}


	public String getEcertFlag() {
		return ecertFlag;
	}

	public void setEcertFlag(String ecertFlag) {
		this.ecertFlag = ecertFlag;
	}

	public String getCallName() {
		return callName;
	}

	public void setCallName(String callName) {
		this.callName = callName;
	}

	public String getChipInjectFlag() {
		return chipInjectFlag;
	}

	public void setChipInjectFlag(String chipInjectFlag) {
		this.chipInjectFlag = chipInjectFlag;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getNoseState() {
		return noseState;
	}

	public void setNoseState(String noseState) {
		this.noseState = noseState;
	}

	public String getIdentificationFlagState() {
		return identificationFlagState;
	}

	public void setIdentificationFlagState(String identificationFlagState) {
		this.identificationFlagState = identificationFlagState;
	}

	public String getOldHaddleWay() {
		return oldHaddleWay;
	}

	public void setOldHaddleWay(String oldHaddleWay) {
		this.oldHaddleWay = oldHaddleWay;
	}

	public BigDecimal getFloatingPrice() {
		return floatingPrice;
	}

	public void setFloatingPrice(BigDecimal floatingPrice) {
		this.floatingPrice = floatingPrice;
	}
	
}
