package com.cku.oa.contest.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.contest.entity.ContestClass;
import com.cku.oa.contest.dao.ContestClassDao;

/**
 * 赛场年龄组别Service
 * @author yuanshuai
 * @version 2020-10-12
 */
@Service
@Transactional(readOnly = true)
public class ContestClassService extends CrudService<ContestClassDao, ContestClass> {

	public ContestClass get(String id) {
		return super.get(id);
	}
	
	public List<ContestClass> findList(ContestClass contestClass) {
		return super.findList(contestClass);
	}
	
	public Page<ContestClass> findPage(Page<ContestClass> page, ContestClass contestClass) {
		return super.findPage(page, contestClass);
	}
	
	@Transactional(readOnly = false)
	public void save(ContestClass contestClass) {
		super.save(contestClass);
	}
	
	@Transactional(readOnly = false)
	public void delete(ContestClass contestClass) {
		super.delete(contestClass);
	}

	public ContestClass getByClassNo(String classNo) {
		return dao.getByClassNo(classNo);
	}
}