package com.cku.oa.components.rule.validation.dog;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogDnaArchiveDao;
import com.cku.oa.dog.dao.DogDnaDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogDna;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.show.dao.ChampionLoginDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.dog.service.RestDogService;
import com.thinkgem.jeesite.common.utils.StringUtils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

@Component
public class DogCondition {

    @Autowired
    public DogDnaArchiveDao dogDnaArchiveDao;
    @Autowired
    public DogDnaDao dogDnaDao;
    @Autowired
    public ChampionLoginDao championLoginDao;
    @Autowired
    private RestDogService restDogService;

    private static SimpleDateFormat YYYYMMDD = new SimpleDateFormat("yyyy-MM-dd");

	/**
	 * 
	 * @description: 传入的时间是否在当前时间x个月内
	 * 1要求传入的日期都是yyyy-MM-dd的格式，时分秒都得是0
	 * 2x必须为大于0的正整数
	 * 3假设传入的参数为2016-11-14 00：00：00，只要当前时间小于2016-12-14 23：59：59都返回true
	 * @author: laiguanglong
	 * @date: 2016年12月14日 下午6:05:38
	 */
	public  boolean isInXMounth(Date date,int x){
		if(date==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"日期为空");
		}
		if(x<1){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"月份数必须为大于1的正整数");
		}
		try {
			date = YYYYMMDD.parse(YYYYMMDD.format(date));
		} catch (ParseException e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"日期有误");
		}
		Calendar dateCalendar = Calendar.getInstance();
		dateCalendar.setTime(date);
		dateCalendar.add(Calendar.MONTH, x); //月份加x  
		dateCalendar.add(Calendar.DATE, 1); //日期加1
		if(new Date().getTime()<dateCalendar.getTimeInMillis()){
			return true;
		}else{
			return false;
		}
	}
    
    /**
     * @description: 犬只是否属于该会员
     * @author: laiguanglong
     * @date: 2017/4/20 11:20
     */
    public boolean isDogBelongToMember(Dog dog, Member member) {
        boolean flag = false;
        if (member != null
                && dog != null
                && StringUtils.isNotBlank(member.getMemberCode())
                && member.getMemberCode().equals(dog.getMemberCode())) {
            flag = true;
        }
        return flag;
    }

    /**
     * @description: 犬只芯片号是否为空
     * @author: laiguanglong
     * @date: 2017/4/20 14:18
     */
    public boolean isIdentificationFlagNotBlank(Dog dog) {
        boolean flag = false;
        if (dog != null
                && StringUtils.isNotBlank(dog.getIdentificationFlag())) {
            flag = true;
        }
        return flag;
    }

    /**
     * @description: 判断是否进行DNA存档了
     * 先查看DogDna是否有记录，如果有，返回true；
     * 如果没有查看是否有已交费的DogDnaArchive，如果有，返回true
     * @author: laiguanglong
     * @date: 2016年12月16日 上午10:17:09
     */
    public boolean isHaveDogDna(Dog dog) {
        boolean flag = false;
        if (dog != null && StringUtils.isNotBlank(dog.getId())) {
            DogDna dogDna = dogDnaDao.getByDogId(dog.getId());
            if (dogDna != null) {
                flag = true;
            } else {
                DogDnaArchive dogDnaArchive = dogDnaArchiveDao.getDnaMsg(dog.getId());
                if (dogDnaArchive != null) {
                    flag = true;
                }
            }
        }
        return flag;
    }

    /**
     * @Description：是否完成登录
     * @author: zhuoHeng
     * @version: 2016年8月29日 上午10:44:29
     */
    public boolean isHaveChampionLogin(Dog dog, Integer loginType) {
        boolean flag = false;
        if (dog != null
                && StringUtils.isNotBlank(dog.getPedigreeCertifiedCode())
                && loginType != null
                && StringUtils.isNotBlank(loginType.toString())) {
            Long count = championLoginDao.getChampionLoginCount(loginType.toString(), dog.getPedigreeCertifiedCode(),"1");
            if (count > 0) {
                flag = true;
            }
        }
        return flag;
    }

    /**
     * @description: 是否是CKU注册犬，以血统证书号是否以CKU开头进行判断
     * @author: laiguanglong
     * @date: 2017/4/21 18:24
     */
    public boolean isCKUDog(Dog dog) {
        boolean flag = false;
        if (dog != null
                && StringUtils.isNotBlank(dog.getPedigreeCertifiedCode())
                && dog.getPedigreeCertifiedCode().toUpperCase().startsWith("CKU")) {
            flag = true;
        }
        return flag;
    }

    /**
     * @description: 犬只获得BOB/ BOS/BOW成绩
     * @author: laiguanglong
     * @date: 2017/4/24 17:53
     */
    public boolean isBOB_BOS_BOWCountCreaterThan(Dog dog, Integer count) {
        boolean flag = false;
        if (dog != null
                && StringUtils.isNotBlank(dog.getPedigreeCertifiedCode())
                && count >= championLoginDao.countBOB_BOS_BOW(dog.getPedigreeCertifiedCode())) {
            flag = true;
        }
        return flag;
    }

    /**
     * @description: 犬只月龄大于等于X
     * @author: laiguanglong
     * @date: 2017/4/25 16:10
     */
    public boolean isDogMonthAgeGEX(Dog dog, Integer x) {
        boolean flag = false;
        if (dog != null && dog.getBirthdate() != null && x != null && x > 0) {
            Calendar birthdate = Calendar.getInstance();
            birthdate.setTime(dog.getBirthdate());
            birthdate.add(Calendar.MONTH, x); //月份加x
            if (System.currentTimeMillis() > birthdate.getTimeInMillis()) {
                flag = true;
            }
        }
        return flag;
    }

    /**
     * @description: 犬只月龄小于等于X
     * @author: laiguanglong
     * @date: 2017/4/25 16:10
     */
    public boolean isDogMonthAgeLEX(Dog dog, Integer x) {
        boolean flag = false;
        if (dog != null && dog.getBirthdate() != null && x != null && x > 0) {
            Calendar birthdate = Calendar.getInstance();
            birthdate.setTime(dog.getBirthdate());
            birthdate.add(Calendar.MONTH, x); //月份加x
            birthdate.add(Calendar.DATE, 1); //日期加1
            if (System.currentTimeMillis() < birthdate.getTimeInMillis()) {
                flag = true;
            }
        }
        return flag;
    }

    /**
     * @description: 犬只月龄大于等于X
     * 这里犬只的生日一定是0时0分0秒，但是time的格式不一定，所以也要格式化为0时0分0秒进行判断
     * @author: laiguanglong
     * @date: 2017/4/25 16:10
     */
    public boolean isDogMonthAgeGEX(Dog dog, Date time, Integer x) {
        boolean flag = false;
        if (dog != null
                && dog.getBirthdate() != null
                && time != null
                && x != null
                && x > 0) {
            Calendar birthdate = Calendar.getInstance();
            birthdate.setTime(dog.getBirthdate());
            birthdate.add(Calendar.MONTH, x); //月份加x
            //格式化time
            String timeString = YYYYMMDD.format(time);
            Date timeDate = null;
            try {
                timeDate = YYYYMMDD.parse(timeString);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            if (timeDate.getTime() >= birthdate.getTimeInMillis()) {
                flag = true;
            }
        }
        return flag;
    }

    /**
     * @description: 犬只月龄小于等于X
     * @author: laiguanglong
     * @date: 2017/4/25 16:10
     */
    public boolean isDogMonthAgeLEX(Dog dog, Date time, Integer x) {
        boolean flag = false;
        if (dog != null
                && dog.getBirthdate() != null
                && time != null
                && x != null
                && x > 0) {
            Calendar birthdate = Calendar.getInstance();
            birthdate.setTime(dog.getBirthdate());
            birthdate.add(Calendar.MONTH, x); //月份加x
            //格式化time
            String timeString = YYYYMMDD.format(time);
            Date timeDate = null;
            try {
                timeDate = YYYYMMDD.parse(timeString);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            if (time.getTime() <= birthdate.getTimeInMillis()) {
                flag = true;
            }
        }
        return flag;
    }

    /**
     * @description: 犬只代数大于等于X
     * @author: laiguanglong
     * @date: 2017/4/25 16:10
     */
    public boolean isDogGenerationGEX(Dog dog, Integer x) {
        boolean flag = false;
        if (dog != null
                && StringUtils.isNumeric(dog.getDogGeneration())
                && x != null
                && x > 0
                && Integer.valueOf(dog.getDogGeneration()) > x) {
            flag = true;
        }
        return flag;
    }

    /**
     * @description: 犬只状态是否正常，判断dogState字段是否为0
     * @author: laiguanglong
     * @date: 2017/4/27 10:26
     */
    public boolean isDogStateNormal(Dog dog) {
        boolean flag = false;
        if (dog != null && "0".equals(dog.getDogState())) {
            flag = true;
        }
        return flag;
    }

    /**
     * @description: 是否同一犬种
     * @author: laiguanglong
     * @date: 2017/4/27 10:49
     */
    public boolean isSameDogType(Dog dog1, Dog dog2) {
        boolean flag = false;
        if (dog1 != null
                && dog2 != null
                && StringUtils.isNotBlank(dog1.getDogBreed())
                && StringUtils.isNotBlank(dog2.getDogBreed())) {
            if (dog1.getDogBreed().equals(dog2.getDogBreed())) {
                return true;
            }
            if (dog1.getDogBreed().startsWith("181") && dog2.getDogBreed().startsWith("181")) {
                return true;
            }
            if (dog1.getDogBreed().startsWith("182") && dog2.getDogBreed().startsWith("182")) {
                return true;
            }
            if (dog1.getDogBreed().startsWith("183") && dog2.getDogBreed().startsWith("183")) {
                return true;
            }
        }
        return flag;
    }

    /**
     * @description: 犬只是否不为近亲
     * @author: laiguanglong
     * @date: 2017/4/27 15:11
     */
    public boolean isNotCloseRelative(Dog maleDog,Dog femaleDog){
        boolean flag = true;
        if(maleDog!=null&&femaleDog!=null){
            JSONObject jo = restDogService.bloodline(maleDog.getPedigreeCertifiedCode(),femaleDog.getPedigreeCertifiedCode());
            JSONArray infos = jo.getJSONArray("infos");
            for(int i=0;i<infos.size();i++){
                JSONObject jsonObject = infos.getJSONObject(i);
                if("1".equals(jsonObject.getString("state"))){
                    return false;
                }
            }

        }
        return flag;
    }

    /**
     * @description: 犬只是否为公犬
     * @author: laiguanglong
     * @date: 2017/4/27 11:02
     */
    public boolean isMaleDog(Dog dog) {
        boolean flag = false;
        if (dog != null && "1".equals(dog.getGender())) {
            flag = true;
        }
        return flag;
    }

    /**
     * @description: 犬只是否为母犬
     * @author: laiguanglong
     * @date: 2017/4/27 11:02
     */
    public boolean isFemaleDog(Dog dog) {
        boolean flag = false;
        if (dog != null && "2".equals(dog.getGender())) {
            flag = true;
        }
        return flag;
    }

    /**
     * @description: 犬只是否不为业务禁止状态
     * @author: laiguanglong
     * @date: 2017/4/27 11:12
     */
    public boolean isNotBusinessBan(Dog dog) {
        boolean flag = false;
        if (dog != null
                && !"1".equals(dog.getBusinessBan())) {
            flag = true;
        }
        return flag;
    }
}