/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.breeder.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 幼犬信息表Entity
 *
 * @author lgl
 * @version 2018-01-12
 */
public class Pup extends DataEntity<Pup> {

    private static final long serialVersionUID = 1L;
    private String birthCode;        // 出生纸编号
    private String nickname;        // 呼名
    private String state;        // 状态：0未上架；1已上架
    private String dogBreed;        // 犬种号
    private String memberCode;        // 犬主会员号
    private String price;        // 配种价格
    private String mainLabel;        // 主标签，由系统生成
    private String label;        // 标签，可修改
    private String recommendInfo;        // 推荐信息
    private String coverImgId;        // 封面图片id
    private String otherImgId;        // 其他图片id，逗号分隔
    private String city;        // 城市
    private Date birthdate;        // 出生日期
    private String gender;        // 犬只性别：1公2母
    private Date addTime;        // 上架时间
    private String viewCount;       // 查看次数

    public Pup() {
        super();
    }

    public Pup(String id) {
        super(id);
    }

    @Length(min = 1, max = 64, message = "出生纸编号长度必须介于 1 和 64 之间")
    public String getBirthCode() {
        return birthCode;
    }

    public void setBirthCode(String birthCode) {
        this.birthCode = birthCode;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @Length(min = 1, max = 2, message = "状态：0未上架；1已上架长度必须介于 1 和 2 之间")
    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Length(min = 1, max = 20, message = "犬种号长度必须介于 1 和 20 之间")
    public String getDogBreed() {
        return dogBreed;
    }

    public void setDogBreed(String dogBreed) {
        this.dogBreed = dogBreed;
    }

    @Length(min = 1, max = 20, message = "犬主会员号长度必须介于 1 和 20 之间")
    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    @Length(min = 1, max = 20, message = "主标签，由系统生成长度必须介于 1 和 20 之间")
    public String getMainLabel() {
        return mainLabel;
    }

    public void setMainLabel(String mainLabel) {
        this.mainLabel = mainLabel;
    }

    @Length(min = 1, max = 20, message = "标签，可修改长度必须介于 1 和 20 之间")
    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Length(min = 1, max = 300, message = "推荐信息长度必须介于 1 和 300 之间")
    public String getRecommendInfo() {
        return recommendInfo;
    }

    public void setRecommendInfo(String recommendInfo) {
        this.recommendInfo = recommendInfo;
    }

    @Length(min = 1, max = 64, message = "封面图片id长度必须介于 1 和 64 之间")
    public String getCoverImgId() {
        return coverImgId;
    }

    public void setCoverImgId(String coverImgId) {
        this.coverImgId = coverImgId;
    }

    @Length(min = 1, max = 350, message = "其他图片id，逗号分隔长度必须介于 1 和 350 之间")
    public String getOtherImgId() {
        return otherImgId;
    }

    public void setOtherImgId(String otherImgId) {
        this.otherImgId = otherImgId;
    }

    @Length(min = 1, max = 50, message = "城市长度必须介于 1 和 50 之间")
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Date getBirthdate() {
        return birthdate;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public String getViewCount() {
        return viewCount;
    }

    public void setViewCount(String viewCount) {
        this.viewCount = viewCount;
    }
}