package com.cku.oa.banner.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 广告位管理Entity
 * 
 * @author zhaoxy
 * @version 2021-01-13
 */
public class AppBanner extends DataEntity<AppBanner> {

	private static final long serialVersionUID = 1L;
	private String bannerId; // banner_id
	private String bannerName; // 广告位名称
	private String bannerSort; // 排序
	private String bannerPlace; // 广告位置 1:强力推荐 2:热门犬舍 3:犬舍联盟
	private String bannerType; // 类型 1:app原生
	private String bannerAction; // 行为 1:犬舍
	private String bannerRoute; // 行为路由（暂不使用）
	private String kennelName; // 犬舍名称
	private String kennelManager; // 犬舍主理人
	private String kennelBreed; // 主营犬种
	private String kennelBreedDesc; // 主营犬种描述
	private String kennelProvince; // 省
	private String kennelCity; // 市
	private String kennelArea; // 区域
	private String bannerImg; // 图片
	private Date startDate; // start_date
	private Date endDate; // end_date
	private String bannerStatus; // 0:启动 1:禁用
	private String bannerDesc; // 备注
	private String kennelCode; // 犬舍编号
	private String bannerTimeStatus;
	private String bannerTimeStatusDesc;
	private Date createDate;
	private Date start;
	private Date end;
	private Date createDateBegin;
	private Date createDateEnd;

	public AppBanner() {
		super();
	}

	public AppBanner(String id) {
		super(id);
	}

	@Length(min = 1, max = 10, message = "banner_id长度必须介于 1 和 10 之间")
	public String getBannerId() {
		return bannerId;
	}

	public void setBannerId(String bannerId) {
		this.bannerId = bannerId;
	}

	@Length(min = 0, max = 32, message = "广告位名称长度必须介于 0 和 32 之间")
	public String getBannerName() {
		return bannerName;
	}

	public void setBannerName(String bannerName) {
		this.bannerName = bannerName;
	}

	@Length(min = 0, max = 10, message = "排序长度必须介于 0 和 10 之间")
	public String getBannerSort() {
		return bannerSort;
	}

	public void setBannerSort(String bannerSort) {
		this.bannerSort = bannerSort;
	}

	@Length(min = 0, max = 4, message = "广告位置 1:强力推荐 2:热门犬舍 3:犬舍联盟长度必须介于 0 和 4 之间")
	public String getBannerPlace() {
		return bannerPlace;
	}

	public void setBannerPlace(String bannerPlace) {
		this.bannerPlace = bannerPlace;
	}

	@Length(min = 0, max = 4, message = "类型 1:app原生长度必须介于 0 和 4 之间")
	public String getBannerType() {
		return bannerType;
	}

	public void setBannerType(String bannerType) {
		this.bannerType = bannerType;
	}

	@Length(min = 0, max = 4, message = "行为 1:犬舍长度必须介于 0 和 4 之间")
	public String getBannerAction() {
		return bannerAction;
	}

	public void setBannerAction(String bannerAction) {
		this.bannerAction = bannerAction;
	}

	@Length(min = 0, max = 640, message = "行为路由（暂不使用）长度必须介于 0 和 640 之间")
	public String getBannerRoute() {
		return bannerRoute;
	}

	public void setBannerRoute(String bannerRoute) {
		this.bannerRoute = bannerRoute;
	}

	@Length(min = 0, max = 32, message = "犬舍名称长度必须介于 0 和 32 之间")
	public String getKennelName() {
		return kennelName;
	}

	public void setKennelName(String kennelName) {
		this.kennelName = kennelName;
	}

	@Length(min = 0, max = 32, message = "犬舍主理人长度必须介于 0 和 32 之间")
	public String getKennelManager() {
		return kennelManager;
	}

	public void setKennelManager(String kennelManager) {
		this.kennelManager = kennelManager;
	}

	@Length(min = 0, max = 32, message = "主营犬种长度必须介于 0 和 32 之间")
	public String getKennelBreed() {
		return kennelBreed;
	}

	public void setKennelBreed(String kennelBreed) {
		this.kennelBreed = kennelBreed;
	}

	@Length(min = 0, max = 32, message = "主营犬种描述长度必须介于 0 和 32 之间")
	public String getKennelBreedDesc() {
		return kennelBreedDesc;
	}

	public void setKennelBreedDesc(String kennelBreedDesc) {
		this.kennelBreedDesc = kennelBreedDesc;
	}

	@Length(min = 0, max = 32, message = "省长度必须介于 0 和 32 之间")
	public String getKennelProvince() {
		return kennelProvince;
	}

	public void setKennelProvince(String kennelProvince) {
		this.kennelProvince = kennelProvince;
	}

	@Length(min = 0, max = 32, message = "市长度必须介于 0 和 32 之间")
	public String getKennelCity() {
		return kennelCity;
	}

	public void setKennelCity(String kennelCity) {
		this.kennelCity = kennelCity;
	}

	@Length(min = 0, max = 32, message = "区域长度必须介于 0 和 32 之间")
	public String getKennelArea() {
		return kennelArea;
	}

	public void setKennelArea(String kennelArea) {
		this.kennelArea = kennelArea;
	}

	@Length(min = 0, max = 64, message = "图片长度必须介于 0 和 64 之间")
	public String getBannerImg() {
		return bannerImg;
	}

	public void setBannerImg(String bannerImg) {
		this.bannerImg = bannerImg;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	@Length(min = 0, max = 1, message = "0:启动 1:禁用长度必须介于 0 和 1 之间")
	public String getBannerStatus() {
		return bannerStatus;
	}

	public void setBannerStatus(String bannerStatus) {
		this.bannerStatus = bannerStatus;
	}

	@Length(min = 0, max = 64, message = "备注长度必须介于 0 和 64 之间")
	public String getBannerDesc() {
		return bannerDesc;
	}

	public void setBannerDesc(String bannerDesc) {
		this.bannerDesc = bannerDesc;
	}

	@Length(min = 0, max = 64, message = "犬舍编号长度必须介于 0 和 64 之间")
	public String getKennelCode() {
		return kennelCode;
	}

	public void setKennelCode(String kennelCode) {
		this.kennelCode = kennelCode;
	}

	public String getBannerTimeStatus() {
		return bannerTimeStatus;
	}

	public void setBannerTimeStatus(String bannerTimeStatus) {
		this.bannerTimeStatus = bannerTimeStatus;
	}

	public String getBannerTimeStatusDesc() {
		return bannerTimeStatusDesc;
	}

	public void setBannerTimeStatusDesc(String bannerTimeStatusDesc) {
		this.bannerTimeStatusDesc = bannerTimeStatusDesc;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public Date getStart() {
		return start;
	}

	public void setStart(Date start) {
		this.start = start;
	}

	public Date getEnd() {
		return end;
	}

	public void setEnd(Date end) {
		this.end = end;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Date getCreateDateBegin() {
		return createDateBegin;
	}

	public void setCreateDateBegin(Date createDateBegin) {
		this.createDateBegin = createDateBegin;
	}

	public Date getCreateDateEnd() {
		return createDateEnd;
	}

	public void setCreateDateEnd(Date createDateEnd) {
		this.createDateEnd = createDateEnd;
	}

	
	
}