//冠军登录申请页面
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        userInfo.refresh();
        //血统证书号
        me.pedigreeCertified = ko.observable("");
        //登录类型：普通1；铜制2；银制3；金质4；超级5；世界冠军6；青年冠军7
        me.loginType = ko.observable(1);
        //	邮寄类型：到付快递0；平邮1；协会自取2
        me.postType = ko.observable(0);
        //邮寄地址 默认地址
        var member = userInfo.getMember();
        var address = member.province+"-"+member.city+"-"+member.street;
        me.postAddress = ko.observable(address);
        //临时地址的显隐；
        me.isAddress = ko.observable(false);
        //狗信息
        me.mydog = ko.observable({});
        //获取价格
        me.showPrice = ko.observable("300.00");
        //修改冠军登录类型
        me.changeType = function(type){
            if(type==0 || type==6 || type==7){
                $("a[name='parentType']").removeClass("checked");
                $("#type"+type).addClass("checked");
                if(type==0){
                    $(".childDiv").css("display","block");
                    $("a[name='childType']").removeClass("checked");
                    $("#type1").addClass("checked");
                    me.loginType(1);
                }else{
                    $(".childDiv").css("display","none");
                    me.loginType(type);
                }
            }else{
                $("a[name='childType']").removeClass("checked");
                $("#type"+type).addClass("checked");
                me.loginType(type);
            }
            var loginType = me.loginType();
            me.getPrcie(loginType);
        }
        //获取价格
        me.getPrcie = function(loginType){
            var sendData = {};
            sendData["loginType"] = loginType;
            util.sendAjax({
                url:'show/championlogin/getPrice',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                       me.showPrice(json.data.price);
                    }else{
                        layer.msg("获取价格失败："+json.msg);
                    }
                }
            });
        }
        //修改邮寄类型
        me.changePostType = function(type){
            $("a[name='postType']").removeClass("checked");
            $("#postType"+type).addClass("checked");
            me.postType(type);
            if(type==0){
                me.isAddress(false);
            }else{
                me.isAddress(true);
            }
        }
        //血统证书号或芯片号查狗
        me.getDog = function(){
            if(me.pedigreeCertified()==""){
                layer.msg("血统证书号不能为空！");
            }else{
                var sendData = {};
                sendData["pedigreeCertifiedCode"] = me.pedigreeCertified();
                util.sendAjax({
                    url:'dog/dog',
                    data:sendData,
                    async:true,
                    loadFlag:true,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        if(json.rc==0){
                            if(json.list!=null && json.list.length>0){
                                me.mydog(json.list[0]);
                            }else{
                                layer.msg("查询信息失败,请输入正确的血统证书号！");
                                me.mydog({});
                            }
                        }else{
                            layer.msg("查询失败:"+json.msg);
                        }
                    }
                });
            }
        }
        //冠军登录申请
        me.savechampionlogin = function(){
            var sendData = {};
            var pedigreeCertified = me.pedigreeCertified();
            if(util.isVal(pedigreeCertified)==""){
                layer.msg("CKU-血统证书号不能为空");
                return;
            }
            sendData["pedigreeCertified"] = me.pedigreeCertified();
            sendData["loginType"] = me.loginType();
            sendData["postType"] = me.postType();
            sendData["stickerFlag"] = me.applyChecked() ? 1:0;
            var postAddress = me.postAddress();
            if(util.isVal(postAddress)==""){
                layer.msg("地址不能为空！");
                return;
            }
            sendData["postAddress"] = me.postAddress();
            util.sendAjax({
                url:'show/championlogin',
                data:JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        context.app.changeCart();
                        layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                            time: 0 //不自动关闭
                            ,btn: ['跳转', '取消']
                            ,yes: function(index){
                                layer.close(index);
                                location.href = location.href.split("#")[0]+"#/order/check";
                            }
                        });
                    }else{
                        layer.msg("冠军登录申请失败:"+json.msg);
                    }
                }
            });
        }
        /*宠爱护照及等级贴纸申请*/
        me.applyChecked = ko.observable(false);
        /*宠爱护照及等级贴纸申请*/
        me.toggleSelect = function(){
            me.applyChecked(!me.applyChecked());
        }
        context.app.loading(false);
        context.app.isShop(false);
    }
});