<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>冠军登录信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            
        });
        function page(n,s){
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
    <ul class="nav nav-tabs">
        <li class="active"><a href="${ctxDc}/championLogin/">冠军登录信息列表</a></li>
    </ul>
    <form:form id="searchForm" modelAttribute="championLogin" action="${ctxDc}/championLogin/" method="post" class="breadcrumb form-search">
        <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
        <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
        <ul class="ul-form">
        	<li><label>犬主/会员号：</label>
                <form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
            </li>
            <li><label>登录类型：</label>
                <form:select path="loginType" class="input-medium">
                    <form:option value="" label="全部 "/>
                    <form:options items="${fns:getDictList('champion_login')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li><label>登录序号：</label>
                <form:input path="loginCode" htmlEscape="false" maxlength="100" class="input-medium"/>
            </li>
            <li><label>血统证书号：</label>
                <form:input path="pedigreeCertified" htmlEscape="false" maxlength="100" class="input-medium"/>
            </li>
            <li><label>支付状态：</label>
                <form:select path="paymentState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li><label>审核状态：</label>
                <form:select path="reviewState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('champion_login_review')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
            <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
            <li class="clearfix"></li>
        </ul>
    </form:form>
    <sys:message content="${message}"/>
    <table id="contentTable" class="table table-striped table-bordered table-condensed">
        <thead>
            <tr>
                <th>缴费流水号</th>
                <th>登录类型</th>
                <th>登录序号</th>
                <th>犬主人</th>
                <th>会员号</th>
                <th>血统证书号</th>
                <th>身份识别标志</th>
                <th>犬名</th>
                <th>DNA存档</th>
                <th>申请时间</th>
                <th>支付状态</th>
                <th>审核状态</th>
                <th>操作</th>
            </tr>
        </thead>
        <tbody>
        <c:forEach items="${page.list}" var="championLogin">
            <tr>
                <td>
                    ${fns:escapeHtml(championLogin.runningNumber) }
                </td>
                <td>
                    ${fns:getDictLabel(championLogin.loginType, 'main_login_type', fns:getDictLabel(championLogin.loginType, 'champion_login_type', ''))}
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.loginCode) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.dog.dogOwner) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.dog.memberCode) }
                </td>
                <td>
                        ${fns:escapeHtml(championLogin.pedigreeCertified) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.dog.identificationFlag) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.dog.nameEn) }
                </td>
                <td>
                    ${fns:escapeHtml(championLogin.isHaveDogDna) }
                </td>
                <td>
                    <fmt:formatDate value="${championLogin.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
                </td>
                <td>
                    <c:if test="${championLogin.paymentState=='1'}"><font color="red">未缴费</font>
                    </c:if>
                    <c:if test="${championLogin.paymentState=='2'}"><font color="green">
                        已缴费
                        </font>
                    </c:if>
                </td>
                <td><c:if test="${championLogin.reviewState=='0'}"><font color="red"></c:if>
                    ${fns:getDictLabel(championLogin.reviewState, 'champion_login_review', '')}
                    <c:if test="${championLogin.reviewState=='0'}"></font></c:if>
                </td>
                <td>
                    <a href="${ctxDc}/championLogin/view?id=${championLogin.id}">查看</a>
                </td>
            </tr>
        </c:forEach>
        </tbody>
    </table>
    <div class="pagination">${page}</div>
</body>
</html>