<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>

<link rel="stylesheet" href="${ctxStatic}/layuiv2/layui/css/layui.css">
<script src="${ctxStatic}/layuiv2/layui/layui.js"></script>
<html>
<head>
	<title>美容活动批量报名</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

			$("#inputForm").validate({
				submitHandler: function(form){
					var flag = true;
					var showDogBreedValue = $("input[name='showDogBreed']:checked").val();
					if(showDogBreedValue == '无'){
						var value = $("#showDogBreedId").val();
						if(value == ''){
							alert("请填写比赛犬种");
							flag = false;
						}
					}
					
					var memberCodesStr="";
					$(".checkedId:checked").each(function(){
						memberCodesStr +=$(this).attr("memberCodes")+',';
					});
					if(memberCodesStr == ''){
						alert("请至少选择一位会员");
						flag = false;
					}
					$("#memberCodesStr").val(memberCodesStr);
					
					if(flag){
						loading('正在提交，请稍等...');
						form.submit();
					}
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			var showCategory = "${groomerShow.showCategory}";
			//美容师资格认证
			if(showCategory=='1'){
				$("input[type='radio'][name='showLevel'][value='C']").attr("checked",true);
				$("input[type='radio'][name='showDogBreed'][value='贵宾']").attr("checked",true);
				
			}
			//国际宠物美容师认证
			if(showCategory=='2'){
				$("input[type='radio'][name='showLevel'][value='国际宠物美容师']").attr("checked",true);
				$("input[type='radio'][name='showDogBreed'][value='模型']").attr("checked",true);
			}
			//宠物造型师&国际宠物美容师认证
			if(showCategory=='3'){
				$("input[type='radio'][name='showLevel'][value='宠物造型师&国际宠物美容师']").attr("checked",true);
				$("input[type='radio'][name='showDogBreed'][value='贵宾']").attr("checked",true);
				$("#moxing").hide();
				$("input[type='radio'][name='showLevel']").change(function(){
					if($(this).val()=='国际宠物美容师'){
						$("#moxing").show();
					}else{
						$("#moxing").hide();
						if($('input[type=radio][name=showDogBreed]:checked').val()=='模型'){
							$("input[type='radio'][name='showDogBreed'][value='贵宾']").attr("checked","true");	
						}
					}
				});
			}
			
			//CKU国际宠物洗护师
			if(showCategory=='4'){
				$("input[type='radio'][name='showLevel'][value='PRIMARY']").attr("checked",true);
			}

			if('${groomerShow.showCategory}' == '6'){
				var testLevel = '${groomerShow.testLevel}'.split(",");
				$.each(testLevel, function (index, value){
					/*$("<input type='radio' name='showLevel' value=''>").attr("value",value).text(value).appendTo("#showLevelDiv");*/
					var levelRadioHtml = "<input type='radio' name='showLevel' value='" + value + "'>" + "<span>" +value + "</span>";
					$(levelRadioHtml).appendTo("#showLevelDiv");
				});
			}
			if('${groomerShow.showCategory}' == '8'){
				$("#fee").prop("readonly", false);
				var levelMapping = {
					"PRIMARY LEVEL": "宠物级",
					"PROFESSIONAL LEVEL": "专业级",
					"MASTER": "教师级"
				};
				var testLevel = '${groomerShow.testLevel}'.split(",");
				$.each(testLevel, function (index, value){
					var levelName = levelMapping[value] || value;
					/*$("<input type='radio' name='showLevel' value=''>").attr("value",value).text(value).appendTo("#showLevelDiv");*/
					var levelRadioHtml = "<input type='radio' name='showLevel' value='" + value + "'>" + "<span>" +levelName + "</span>";
					$(levelRadioHtml).appendTo("#showLevelDiv8");
				});
			}

			$('input[type=radio][name=showDogBreed]').change(function() {
		          if (this.value == '无') {
		              $("#showDogBreedId").removeAttr("disabled");
		          } else  {
					  $("#showDogBreedId").attr("disabled","disabled");
					  $("#showDogBreedId").val("");
		          }
		    });
				
		});

	
		var b=false;
		function allCheck(){
			if (!b) {
				b=true;
				$(".checkedId").each(function(){
					$(this).attr("checked", b);
				});
			}else{
				b=false;
				$(".checkedId").each(function(){
					$(this).attr("checked", b);
				});
			}
		}
	</script>
</head>
<body >
	<ul class="nav nav-tabs">
		<li><a href="${ctxSchools}/schoolsGroomer/groomerShowList">美容师活动列表</a></li>
		<li class="active"><a href="${ctxSchools}/schoolsGroomer/registerBatchForm?id=${groomerRegister.groomerShowId}">美容师活动批量报名</a></li>
	</ul>
	<form:form id="inputForm" modelAttribute="groomerRegister" action="${ctxSchools}/schoolsGroomerRegister/webFormBatch" method="post" class="form-horizontal" >
	<form:hidden path="memberCodesStr"/>
	<form:hidden path="groomerShowId"/>
	<form:hidden path="showCode"/>
	<form:hidden path="fee" value="${groomerShow.fee}"/>
	<form:hidden path="showCategory" value="${groomerShow.showCategory}"/>
	<div class="control-group">
		<label class="control-label">赛事编号：</label>
		<div class="controls">
			${fns:escapeHtml(groomerShow.showCode) }
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">活动名称：</label>
		<div class="controls">
			${fns:escapeHtml(groomerShow.showName) }
		</div>
	</div>
	<div class="control-group" >
			<label class="control-label">参赛级别：</label>
			<div class="controls">
				<c:set var="showCategory" value="${groomerShow.showCategory}"></c:set>
				<c:choose>
				    <c:when test="${showCategory eq '1'}">
						<input  name="showLevel" class="required" type="radio" value="C"/>
						<label>C</label>
				    </c:when>
				    <c:when test="${showCategory eq '2'}">
				    	<input name="showLevel" class="required" type="radio" value="国际宠物美容师"/>
						<label>国际宠物美容师</label>
				    </c:when>
				    <c:when test="${showCategory eq '3'}">
				    	<input name="showLevel" class="required" type="radio" value="国际宠物美容师"/>
						<label>国际宠物美容师</label>
						<input  name="showLevel" class="required" type="radio" value="宠物造型师&国际宠物美容师"/>
						<label>宠物造型师&国际宠物美容师</label>
				    </c:when>
				    <c:when test="${showCategory eq '4'}">
				    	<oa:dictRadios name="showLevel" type="groomer_nurse_level" value="PRIMARY" excludeValue="MATCH" rangeItems="${groomerShow.testLevel}" cssClass="required" remarks="注：切换参赛级别请重新选择比赛犬种"></oa:dictRadios>
				    </c:when>
					<c:when test="${groomerShow.showCategory eq '6'}">
						<div id = "showLevelDiv">

						</div>
						<%--<input  name="showLevel" class="required" type="radio" value="C"/>
						<label>C</label>
						<input  name="showLevel" class="required" type="radio" value="B"/>
						<label>B</label>
						<input name="showLevel" class="required" type="radio" value="A"/>
						<label>A</label>--%>
					</c:when>
					<c:when test="${groomerShow.showCategory eq '8'}">
						<div id = "showLevelDiv8">

						</div>
					</c:when>
				    <c:otherwise>
				    	活动类型错误
				    </c:otherwise>
				</c:choose>
			</div>
		</div>	
	<c:set var="showLevelHidden" value="${groomerShow.showCategory eq '1' && groomerShowTypeMap['showType'] eq 'cathedra'}"></c:set>
	<div class="control-group" ${showLevelHidden?'style="display:none"':''}>
		<label class="control-label">比赛品种：</label>
		<div class="controls">
			<c:choose>
			    <c:when test="${groomerShow.showCategory eq '4'}">
			    	<input type="hidden" id="tmpMemberCode" name="tmpMemberCode" value="batch">
					<oa:groomerBreeds name="showDogBreed" otherName="showDogBreedExtra" memberElementId="tmpMemberCode" levelElementId="showLevel" isSchool="true" cssClass="input-xlarge required" ></oa:groomerBreeds>
			    </c:when>
				<c:when test="${groomerShow.showCategory eq '8'}">
					<input name="showDogBreed" type="text" required/><span><font>&nbsp;&nbsp;注:多个品种用空格分隔</font></span>
				</c:when>
			    <c:otherwise>
	                <input name="showDogBreed" class="required" type="radio" value="贵宾" />
	                <label>贵宾</label>
	               	<input name="showDogBreed" class="required" type="radio" value="比熊"/>
	                <label>比熊</label>
	                <input name="showDogBreed" class="required" type="radio" value="雪纳瑞" />
	                <label>雪纳瑞</label>
	                <c:if test="${groomerShow.showCategory eq '2' || groomerShow.showCategory eq '3'}">
						<div id="moxing" style="display: inline-block;">
							<input name="showDogBreed" class="required" type="radio" value="模型"/>
							<label>模型</label>
						</div>
					</c:if>
					<input name="showDogBreed" class="required" type="radio" value="无" />
	                <label>其他犬种: </label>
	                <input id="showDogBreedId" name="showDogBreed" type="text" disabled="disabled"/><span><font>&nbsp;&nbsp;注:多个犬种用空格分隔</font></span>
			    </c:otherwise>
			</c:choose>
		</div>
	</div>
 <br>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th><a href="#" onclick="allCheck()">全选</a></th>
				<th>会员编号</th>
				<th>会员姓名</th>
				<th>联系方式</th>
				<th>性别</th>
				<th>是否有效</th>
				<th>结业证书号</th>
				<th>结业证书级别</th>
			</tr>
		</thead>
		<tbody>
		<c:if test="${empty memberList }">
		<tr> <td colspan="8">没有找到任何会员信息</td></tr></c:if>
		<c:forEach items="${memberList}" var="member">
			<tr>
				<td><input type="checkbox" class="checkedId" memberCodes="${fns:escapeHtml(member.memberCode)}"></td>
				<td>
					${fns:escapeHtml(member.memberCode) }
				</td>
				<td>
					${fns:escapeHtml(member.name)}
				</td>
				<td>
					${fns:escapeHtml(member.mobile)}
				</td>
				<td>
					${fns:getDictLabels(member.gender,'user_gender','')}
				</td>
				<td>
					是
				</td>
				<td>
					${fns:escapeHtml(member.certificateCode)}
				</td>
					<td>
					${fns:escapeHtml(member.certificateLevel)}
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	
	<div style="z-index: 10; position: fixed; text-align: center; bottom: 0; width:100%; height:60px;line-height:60px;background: #F8F8F8;border-top: 1px solid #eee;">
    	<button  style="height: 40px;width: 240px ;" type="submit" class="btn btn-primary" >确认批量报名</button>
	</div>
	</form:form>
	
</body>
</html>