<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容师结业证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();

			// 选择下拉列表
			var $select = $('#showCategoryClass');

			// 遍历所有的 <option> 元素
			$select.find('option').each(function() {
				// 检查 value 是否等于 5 为FCI增发类型，不展示
				if ($(this).val() === '5') {
					// 从下拉列表中移除该 <option>
					$(this).remove();
				}
			});
		});
	
		function page(n,s){
			if(n) $("#pageNo").val(n);
			if(s) $("#pageSize").val(s);
			$("#searchForm").attr("action","${ctxSchools}/schoolsGroomer/groomerShowList/");
			$("#searchForm").submit();
	    	return false;
	    }

		function batchRegister(id){
			top.layer.open({
				type: 2,
				title: ['美容活动批量报名', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['900px', '700px'],
				content: "${ctxSchools}/schoolsGroomer/registerBatchForm?id=" + id
			});
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxSchools}/schoolsGroomer/groomerShowList">美容师活动列表</a></li>
		<li class=""><a href="${ctxSchools}/schoolsGroomerRegister/groomerRegisterList">美容师报名列表</a></li>
	</ul>
	
	
	<form:form id="searchForm" modelAttribute="groomerShow" action="${ctxSchools}/schoolsGroomer/groomerShowList" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>活动名称：</label>
				<form:input path="showName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>赛事编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>活动分类：</label>
				<form:select path="showCategory" id="showCategoryClass" class="input-xlarge required">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('groomer_show_category')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>赛事编号</th>
				<th>活动类型</th>
				<th>活动分类</th>
				<th>活动名称</th>
				<th>活动地点</th>
				<th>开始日期</th>
				<th>结束日期</th>
				<th>截止时间</th>
				<th>报名费</th>
				<th>报名状态</th>
				<th>操作</th>
				<th>报名</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerShow">
			<tr>
				<td>
					${fns:escapeHtml(groomerShow.showCode)}
				</td>
				<td>
					${fns:getDictLabel(groomerShow.showType, 'groomer_show_type', '')}
				</td>
				<td>
					${fns:getDictLabel(groomerShow.showCategory, 'groomer_show_category', '')}
				</td>
				<td>
					${fns:escapeHtml(groomerShow.showName)}
				</td>
				<td>
					${fns:escapeHtml(groomerShow.showAddress)}
				</td>
				<td>
					<fmt:formatDate value="${groomerShow.startTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${groomerShow.endTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${groomerShow.registerEndTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(groomerShow.fee)}
				</td>
				<td>
					<c:choose>
						<c:when test="${groomerShow.registerEndTime > date}">
							<font color="green">开放</font>
						</c:when>
						<c:otherwise>
							<font color="red">关闭</font>
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					<a href="${ctxSchools}/schoolsGroomer/view?id=${fns:escapeHtml(groomerShow.id)}">查看</a>
				</td>
				<td>
					<c:if test="${groomerShow.showType ne 'team'}">
						<c:choose>
							<c:when test="${groomerShow.registerEndTime > date}">
								<c:choose>
									<c:when test="${groomerShow.showCategory ne '8'}">
										<a href="${ctxSchools}/schoolsGroomer/registerForm?id=${fns:escapeHtml(groomerShow.id)}">报名</a>
										<a href="${ctxSchools}/schoolsGroomer/registerBatchForm?id=${fns:escapeHtml(groomerShow.id)}">批量报名</a>
									</c:when>
									<c:otherwise>
										报名 批量报名
									</c:otherwise>
								</c:choose>
								<%-- <a href="" onclick="batchRegister('${groomerShow.id}')">批量报名</a> --%>
							</c:when>
							<c:otherwise>
								报名 批量报名
							</c:otherwise>
						</c:choose>
					</c:if>
					<c:if test="${groomerShow.showType eq 'team'}">
						报名 批量报名
					</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>