<%@page import="com.cku.oa.sys.entity.user.MemberCardTypeEnum"%>
<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户会员信息表管理</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.form-horizontal .control-label {
		    width: 110px!important;
		}
	</style>
	<script src="${ctxStatic}/jquery/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			$("#btnSubmit").click(function(){
				$("#inputForm").ajaxSubmit({
			        dataType: 'json',
			        beforeSubmit: function(){
						if (!$("#inputForm").valid() || $(".error:visible").length > 0){
							return false;
						}
						else{
				            return true; 
						}
			        },
			        success: function(data){
			            top.layer.msg(data.msg);
					    if(data.rc == 0){
							window.location = "${ctx}/sys/user/member"
					    }
			        },  
			        error: function(err) { 
						top.layer.msg("操作失败!");           
			        }
				});
			});
			$("#province").empty().val("").select2();
			$("#city").empty().val("").select2();
			$("#area").empty().val("").select2();
			//访问省市区域
			$.ajax({
				url:'${ctxProvince}',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var html = "<option value='' code=''>请选择省份</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
						}
						$("#province").append(html);
					}else{
						layer.msg(json.msg);
					}
				}
			});

			$("#registerProvince").empty().val("").select2();
			$("#registerCity").empty().val("").select2();
			$("#registerArea").empty().val("").select2();
			//访问省市区域
			$.ajax({
				url:'${ctxProvince}',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var option = "";
						var html = "<option value='' code=''>请选择省份</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
							if('${member.registerProvince}'==lists[i].province) {
								option = lists[i].province;
							}
						}
						$("#registerProvince").append(html);
						if(option!=''){
							$("#registerProvince").val(option).select2().change();
						}
					}else{
						layer.msg(json.msg);
					}
				}
			});
			
			$(".kennelClass").hide();
			
			$("#memberCardType").change(function(obj){
				if($(this).val() == "${MemberCardTypeEnum.PLATINUM_CARD.code()}" || $(this).val() == "${MemberCardTypeEnum.PURPLE_CARD.code()}"){
					$(".kennelClass").show();
					$("#kennelName").rules("add",{required:true,minlength:2,maxlength:4});
					$("#nameEn").rules("add",{required:true,minlength:3,maxlength:30});
					$("#fciName").rules("add",{required:true,minlength:3,maxlength:30});
					$("#fciNameBackup").rules("add",{minlength:3,maxlength:30});
				}else{
					$(".kennelClass").hide();
					$("#kennelName").rules("remove");
					$("#nameEn").rules("remove");
					$("#fciName").rules("remove");
					$("#fciNameBackup").rules("remove");
				}
			});
			
			$("#kennelName").blur(function(){
				var name = encodeURI($("#kennelName").val());
				$.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctx}/kennel/kennel/nameCheck?name="+name,
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                	$.jBox.alert("请求失败！");
	                },
	                success: function(data) {
	                	if(data.rc != 0){
	                		$("#nameError").html(data.msg);
							$("#nameError").show();
	                	}else{
	                		$("#nameError").hide();
	                	}
	                }
				})
			});
			
			$("#nameEn").blur(function(){
				validateEnName($(this).attr("id"),true);
			});
			
			$("#fciName").blur(function(){
				validateEnName($(this).attr("id"),true);
			});
			
			$("#fciNameBackup").blur(function(){
				validateEnName($(this).attr("id"),false);
			});
			
			function validateEnName(inputId,isValidBlank){
				$.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctx}/kennel/kennel/nameEnCheck?isValidBlank="+isValidBlank+"&nameEn="+encodeURI($("#"+inputId).val()),
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                	$.jBox.alert("请求失败！");
	                },
	                success: function(data) {
	                	if(data.rc != 0){
	                		$("#"+inputId+"Error").html(data.msg);
	                		$("#"+inputId+"Error").show();
	                	}else{
	                		$("#"+inputId+"Error").hide();
	                	}
	                }
				})
			}
			
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/sys/user/member/">会员列表</a></li>
		<li class="active"><a href="${ctx}/sys/user/member/form?id=${member.id}"><shiro:hasPermission name="sys:user:member:edit">${not empty member.id?'修改':'添加'}</shiro:hasPermission>会员</a></li>
		<shiro:hasPermission name="sys:user:member:tcadd"><li><a href="${ctx}/sys/user/member/tcform">淘宠会员注册</a></li></shiro:hasPermission>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="member" action="${ctx}/sys/user/member/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden path="freezeFlag" value="0"/>
		<sys:message content="${message}"/>	
		<h3>会员基本信息</h3>
		<div class="control-group" style="width:80%">
			<label class="control-label">证件照正面：</label> 
			<div class="controls">
				<sys:singleImgUpload module="member" imgId="avatar" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
				<form:input path="avatar" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#avatar").val(response.id);
					}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:select path="gender" class="input-large required">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('user_gender')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="birthday" type="text" readonly="readonly" maxlength="20" class="input-large Wdate "
					value="<fmt:formatDate value="${member.birthday}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证件号：</label>
			<div class="controls">
				<form:input path="cardNo" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机：</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮编：</label>
			<div class="controls">
				<form:input path="postcode" htmlEscape="false" maxlength="60" class="input-xlarge isZipCode" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">QQ：</label>
			<div class="controls">
				<form:input path="qq" htmlEscape="false" maxlength="50" class="input-xlarge isQq"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">固定电话：</label>
			<div class="controls">
				<form:input path="phone" htmlEscape="false" maxlength="200" class="input-xlarge isPhone"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">传真：</label>
			<div class="controls">
				<form:input path="fax" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮箱：</label>
			<div class="controls">
				<form:input path="email" htmlEscape="false" maxlength="200" value="" class="input-xlarge email"/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">会员类别：</label>
			<div class="controls">
				<form:select path="memberCardType" class="input-large required">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('member_card_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员站点：</label>
			<div class="controls">
				<form:select path="memberSite" class="input-large ">
					<form:option value="">CKU会员</form:option>
					<form:option value="4">CKUDC会员</form:option>
					<form:option value="6">CKUMC会员</form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍中文名：</label>
			<div class="controls">
				<form:input id="kennelName" path="kennel.name" htmlEscape="false" class="input-xlarge" />
				<span class="help-inline"><font color="red">*</font> </span>
				<label id="nameError" style="display:none" class="error"></label>
			</div>
		</div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍英文名：</label>
			<div class="controls">
				<form:input id="nameEn" path="kennel.nameEn" htmlEscape="false" class="input-xlarge"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<label id="nameEnError" style="display:none" class="error"></label>
			</div>
		</div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍FCI英文名：</label>
			<div class="controls">
				<form:input id="fciName" path="kennel.fciName" htmlEscape="false" class="input-xlarge"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<label id="fciNameError" style="display:none" class="error"></label>
			</div>
		</div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍FCI备用名：</label>
			<div class="controls">
				<form:input id="fciNameBackup" path="kennel.fciNameBackup" htmlEscape="false" class="input-xlarge"/>
				<label id="fciNameBackupError" style="display:none" class="error"></label>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<h3>邮寄地址</h3>
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:select id="province" path="province" class="input-large required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				<form:select id="city" path="city" class="input-large required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#province").change(function(){
				$("#city").empty().val("").select2();
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxCity}',
					data: {province_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>请选择城市</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
							}
							$("#city").append(html);
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">区域：</label>
			<div class="controls">
				<form:select id="area" path="area" class="input-large required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#city").change(function(){
				$("#area").empty().val("<option value='' code=''>请选择区域</option>").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxArea}',
					data: {city_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>请选择区域</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
							}
							$("#area").append(html);
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<form:input path="street" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		
		<div style = "clear:both;"></div>
		<h3>注册地址</h3>
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:select id="registerProvince" path="registerProvince" class="input-large required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				<form:select id="registerCity" path="registerCity" class="input-large required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#registerProvince").change(function(){
				$("#registerCity").empty().val("").select2();
				$("#registerArea").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxCity}',
					data: {province_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>请选择城市</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
							}
							$("#registerCity").append(html);
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">区域：</label>
			<div class="controls">
				<form:select id="registerArea" path="registerArea" class="input-large required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#registerCity").change(function(){
				$("#registerArea").empty().val("<option value='' code=''>请选择区域</option>").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxArea}',
					data: {city_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>请选择区域</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
							}
							$("#registerArea").append(html);
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<form:input path="registerStreet" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		
		<div style = "clear:both;"></div>
		
		<div class="form-actions">
			<shiro:hasPermission name="sys:user:member:add">
				<input id="btnSubmit" class="btn btn-primary" type="button" value="保 存"/>&nbsp;
			</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>