<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>计划任务管理管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/systask/sysTask/">计划任务管理列表</a></li>
		<li class="active"><a href="${ctx}/systask/sysTask/form?id=${sysTask.id}">计划任务管理<shiro:hasPermission name="systask:sysTask:edit">${not empty sysTask.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="systask:sysTask:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="sysTask" action="${ctx}/systask/sysTask/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">工作计划描述：</label>
			<div class="controls">
				<form:input path="jobInfo" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<font color="#FF0000">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">工作计划名称：</label>
			<div class="controls">
				<form:input path="jobName" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<font color="#FF0000">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">任务组名：</label>
			<div class="controls">
				<form:input path="jobGroup" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
				<font color="#FF0000">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">任务执行类名：</label>
			<div class="controls">
				<form:input path="jobCls" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
				<font color="#FF0000">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">触发时间格式：</label>
			<div class="controls">
				<form:input path="timeFormat" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<font color="#FF0000">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">当前状态：</label>
			<div class="controls">
				<form:select path="state" class="input-xlarge " disabled="true">
					<form:options items="${fns:getDictList('taskState')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="systask:sysTask:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>