<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展成绩管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					if (confirm("成绩有改动请选确定，成绩无改动请选取消后关闭该窗口")==true){
						 }else{
						  return;
						 }
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			//给裁判下拉框赋值
			$('#s2id_referee').find('.select2-chosen').html('${fns:escapeHtml(showResults.referee)}');
			$("#referee").prepend("<option value='${fns:escapeHtml(showResults.referee)}' selected='selected'>${fns:escapeHtml(showResults.referee)}</option>");

		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
	<style type="text/css">
		.form-horizontal .control-label{
			width: 120px;
		}
	</style>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/results/showResults/">犬展成绩列表</a></li>
		<li class="active"><a href="${ctx}/results/showResults/form?id=${showResults.id}">犬展成绩<shiro:hasPermission name="results:showResults:edit">${not empty showResults.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="results:showResults:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="showResults" action="${ctx}/results/showResults/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">秩序号：</label>
			<div class="controls">
				<form:input path="orderCode" htmlEscape="false" maxlength="5" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				<form:input path="pedigreeCertified" htmlEscape="false" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">评价：</label>
			<div class="controls">
					${fns:escapeHtml(showResults.appraisal)}
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">CC：</label>
			<div class="controls">
				<form:checkboxes path="resultCcs" items="${fns:getDictList('show_result_cc')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:input path="remarksCc" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">CACIB：</label>
			<div class="controls">
				<form:radiobuttons path="resultCacib" items="${fns:getDictList('show_result_cacib')}" itemLabel="label" itemValue="value" htmlEscape="false" class=""/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">CACIB备注：</label>
			<div class="controls">
				<form:input path="remarksCacib" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BOB：</label>
			<div class="controls">
				<form:radiobuttons path="resultBob" items="${fns:getDictList('show_result_bob')}" itemLabel="label" itemValue="value" htmlEscape="false" class=""/>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">BOW：</label>
			<div class="controls">
				<form:input path="resultBow" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">BOJ/JBOS/VBOB：</label>
			<div class="controls">
				<form:input path="resultBoj" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">JBIG：</label>
			<div class="controls">
				<form:input path="resultJbig" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">JBIS：</label>
			<div class="controls">
				<form:input path="resultJbis" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">BIG：</label>
			<div class="controls">
				<form:input path="resultBig" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">BIS：</label>
			<div class="controls">
				<form:input path="resultBis" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">BOV：</label>
			<div class="controls">
				<form:input path="resultBov" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">BBE-BIS：</label>
			<div class="controls">
				<form:input path="resultBbeBis" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BBE-BIG：</label>
			<div class="controls">
				<form:input path="resultBbeBig" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BBE-BISS：</label>
			<div class="controls">
				<form:input path="resultBbeBiss" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BBE-WINNER：</label>
			<div class="controls">
				<form:input path="resultBbeWinner" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">OHC-BIS：</label>
			<div class="controls">
				<form:input path="resultOhcBis" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">OHC-BIG：</label>
			<div class="controls">
				<form:input path="resultOhcBig" htmlEscape="false" maxlength="20" class="input-xlarge "/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">OHC-BISS：</label>
			<div class="controls">
				<form:input path="resultOhcBiss" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">OHC-BOH：</label>
			<div class="controls">
				<form:input path="resultOhcBoh" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">本场积分：</label>
			<div class="controls">
				<form:input path="showResult" htmlEscape="false" type="number" maxlength="4" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">单犬种积分：</label>
			<div class="controls">
				<form:input path="showBreedResult" htmlEscape="false" type="number" maxlength="4" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">BBE积分：</label>
			<div class="controls">
				<form:input path="bbeScore" htmlEscape="false" type="number" maxlength="4" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">OHC积分：</label>
			<div class="controls">
				<form:input path="ohcScore" htmlEscape="false" type="number" maxlength="4" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">WW/APCS-CAC：</label>
			<div class="controls">
				<form:input path="resultApaccc" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">犬主中文名：</label>
			<div class="controls">
				<form:input path="dogOwnerNameCn" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主英文名：</label>
			<div class="controls">
				<form:input path="dogOwnerNameEn" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主会员号：</label>
			<div class="controls">
				<form:input path="dogOwnerMemberCode" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI代码：</label>
			<div class="controls">
				<form:input path="fciCode" htmlEscape="false" maxlength="6" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:radiobuttons path="dogGender" items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">年龄组别：</label>
			<div class="controls">
				<form:select path="ageGroup" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('show_age_group')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">犬展编号：</label>
			<div class="controls">
                <form:select id="showCode" path="showCode" class="input-medium">
                	<form:option value="" label="全部"/><form:options items="${showCodeList}" htmlEscape="false"/>
                </form:select>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">裁判：</label>
			<div class="controls">
				<%-- <form:input path="referee" htmlEscape="false" maxlength="50" class="input-xlarge "/> --%>
                <form:select id="referee" path="referee" class="input-medium required">
                	<form:options items="${showJudgeList}" itemLabel="judgeName" itemValue="judgeName" htmlEscape="false"/>
                </form:select>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">活动区域：</label>
			<div class="controls">
				<form:input path="raceLap" htmlEscape="false" maxlength="10" class="input-xlarge"/>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">修改说明：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="5" maxlength="1024" class="input-xxlarge "/>
			</div>
		</div>
		<div style="clear:both;"/>
		<div class="form-actions">
			<shiro:hasPermission name="results:showResults:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/></shiro:hasPermission>
		</div>
	</form:form>
</body>
</html>