<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展裁判管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/referee/showReferee/">犬展裁判列表</a></li>
		<shiro:hasPermission name="referee:showReferee:edit"><li><a href="${ctx}/referee/showReferee/form">犬展裁判添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="showReferee" action="${ctx}/referee/showReferee/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>裁判中文名：</label>
				<form:input path="refereeNameCn" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>裁判英文名：</label>
				<form:input path="refereeNameEn" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>裁判类型：</label>
				<form:select path="refereeType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('show_referee_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>裁判中文名</th>
				<th>裁判英文名</th>
				<th>裁判性别</th>
				<th>裁判国籍</th>
				<th>裁判类型</th>
				<th>修改时间</th>
				<th>备注信息</th>
				<shiro:hasPermission name="referee:showReferee:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showReferee">
			<tr>
				<td><a href="${ctx}/referee/showReferee/form?id=${showReferee.id}">
					${fns:escapeHtml(showReferee.refereeNameCn)}
				</a></td>
				<td>
					${fns:escapeHtml(showReferee.refereeNameEn)}
				</td>
				<td>
					${fns:escapeHtml(showReferee.refereeSex)}
				</td>
				<td>
					${fns:escapeHtml(showReferee.refereeCitizenship)}
				</td>
				<td>
					${fns:getDictLabel(showReferee.refereeType, 'show_referee_type', '')}
				</td>
				<td>
					<fmt:formatDate value="${showReferee.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(showReferee.remarks)}
				</td>
				<shiro:hasPermission name="referee:showReferee:edit"><td>
    				<a href="${ctx}/referee/showReferee/form?id=${showReferee.id}">修改</a>
					<a href="${ctx}/referee/showReferee/delete?id=${showReferee.id}" onclick="return confirmx('确认要删除该犬展裁判吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>