<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html id="contonier">
<head>
	<title>项目管理</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.cust-th-head1{
			height:50px;
			text-align:center!important;
			vertical-align:middle!important;
			font-size:18px;
		}
		.cust-th-head2{
			height:30px;
			text-align:center!important;
			vertical-align:middle!important;
			font-size:14px;
		}
		.cust-th-head3{
			text-align:center!important;
			vertical-align:middle!important;
		}
		.cust-td-col1{
			text-align:center!important;
			vertical-align:middle!important;
			min-width: 60px!important;
			height: 20px;
		}
		.cust-td-col2{
			text-align:center!important;
			vertical-align:middle!important;
			background-color: white!important;
			min-width: 20px!important;
			height: 20px;
		}
		.bg-color1{
			background-color: #5cb85c!important;
		}
		.bg-color2{
			background-color: #5bc0de!important;
		}
		.bg-color3{
			background-color: #fcf8e3!important;
/* 			#f2dede */
/* 			#d9edf7 */
/* 			#dff0d8 */
		}
		.bg-color4{
			background-color: #f0ad4e!important;
		}
		
		.hide{
            overflow: hidden;
			text-overflow: ellipsis;
			display: -webkit-box;
			-webkit-line-clamp: 3;
			-webkit-box-orient: vertical;
        }
        table{
        	border-top: 0px!important;
        }
		
	</style>
	<script type="text/javascript">
		$(document).ready(function() {
		  //初始化
		  if(${currentMonth>=6} && $(".cust-td-col2").size()>0){
			  document.getElementById("son").scrollLeft  = 1000;
		  }
		  
		  window.addEventListener('scroll',function(){
			var scrollTop = top.document.getElementById('mainFrame').contentWindow.document.getElementsByTagName('html')[0].scrollTop;
			document.getElementById("head").style.transform = 'translateY(' + scrollTop + 'px)';
			document.getElementsByTagName('thead')[0].style.transform = 'translateY(' + scrollTop + 'px)';
			document.getElementsByTagName('thead')[1].style.transform = 'translateY(' + scrollTop + 'px)';
		  });
		});
		
		function loadSelectYear(){
			window.location = "${ctx}/project/ckuProject/viewTable?queryYear="+$dp.cal.getDateStr();
		}
		function trClick(obj){
			$(obj).find(".cust-td-col2").each(function(index,element){
				if($(element).hasClass("bg-color3")){
					$(element).removeClass("bg-color3");
				}else if(!$(element).hasClass("bg-color2") && !$(element).hasClass("bg-color1")){
					$(element).addClass("bg-color3");
				}
			});
		}
	</script>
</head>
<body>
	<div id="head" style="text-align:center;background-color:#FFF;">
		<div style="text-align: center;">
			 <span style="display: inline-block;width: 20px;height: 20px;border: 1px solid #EEE;background-color: #5bc0de;"></span>
		     <span style="display: inline-block;">蓝色表示往月</span>
		     <span style="display: inline-block;width: 20px;height: 20px;border: 1px solid #EEE;background-color: #5cb85c;"></span>
		     <span style="display: inline-block;">绿色表示当月</span>
		     <span style="display: inline-block;width: 20px;height: 20px;border: 1px solid #EEE;background-color: #f0ad4e;"></span>
		     <span style="display: inline-block;">橙色表示将来</span>
		</div>
		<div style="text-align: center;padding:5px 0px 10px 0px;">
		     <span style="color:#d9534f;">此图表仅展示大型项目，日常版本维护迭代和小功能修改可能不会展示在此</span>
		</div>
	</div>
	<div id="box">
		<div id="child" style="width:15%;float:left;clear:both;margin-right:2px;">
			<table id="headTable" class="table table-striped table-bordered table-condensed" >
				<thead>
					<tr>
						<th id="th1" class="cust-th-head1" style="border-top: 1px solid #ddd;">
							<input name="startTime" type="text" readonly="readonly" maxlength="20" class="Wdate" style="width:60px;"
								value="${monthWeek.year}" onclick="WdatePicker({onpicked:loadSelectYear,dateFmt:'yyyy',isShowClear:false});"/>
						</th>
					</tr>
					<tr>
						<th class="cust-th-head2"></th>
					</tr>
					<tr>
						<th class="cust-th-head3">部门</th>
					</tr>
				</thead>
				<tbody>
						<c:forEach items="${projectList}" var="p">
							<tr>
								<td class="cust-td-col1 hide" title="${p.deptName}">${p.deptName}</td>
							</tr>
						</c:forEach>
				</tbody>
			</table>
		</div>
		<div id="son" style="width:84%;float:left;overflow-x:scroll;">
			<table id="contentTable" class="table table-striped table-bordered table-condensed">
				<thead>
					<tr>
						<th id="th2" colspan="${monthWeek.colColumn}" class="cust-th-head1" style="border-top: 1px solid #ddd;">
							${monthWeek.year}年
						</th>
					</tr>
					<tr>
						<c:forEach items="${monthWeek.monthList}" var="m">
							<th class="cust-th-head2" colspan="${fn:length(m.weekList)}">${m.month}月</th>
						</c:forEach>
					</tr>
					<tr>
						<c:forEach items="${monthWeek.monthList}" var="m">
							<c:forEach items="${m.weekList}" var="w">
								<th class="cust-th-head3">${w.week}</th>
							</c:forEach>
						</c:forEach>
					</tr>
				</thead>
				<tbody>
						<c:forEach items="${projectList}" var="p">
							<tr onclick="trClick(this);">
								<c:forEach items="${monthWeek.monthList}" var="m">
									<c:forEach items="${m.weekList}" var="w">
										<c:if test="${monthWeek.year < currentYear}">
											<td title="${p.startWeek <= w.week && p.endWeek >= w.week? p.name:''  }" class="cust-td-col2 ${p.startWeek <= w.week && p.endWeek >= w.week? 'bg-color2':''  }"></td>
										</c:if>
										<c:if test="${monthWeek.year eq currentYear}">
											<c:if test="${m.month < currentMonth}">
												<td title="${p.startWeek <= w.week && p.endWeek >= w.week? p.name:''  }" class="cust-td-col2 ${p.startWeek <= w.week && p.endWeek >= w.week? 'bg-color2':''  }"></td>
											</c:if>
											<c:if test="${m.month eq currentMonth}">
												<td title="${p.startWeek <= w.week && p.endWeek >= w.week? p.name:''  }" class="cust-td-col2 ${p.startWeek <= w.week && p.endWeek >= w.week? 'bg-color1':''  }"></td>
											</c:if>
											<c:if test="${m.month > currentMonth}">
												<td title="${p.startWeek <= w.week && p.endWeek >= w.week? p.name:''  }" class="cust-td-col2 ${p.startWeek <= w.week && p.endWeek >= w.week? 'bg-color4':''  }"></td>
											</c:if>
										</c:if>
										<c:if test="${monthWeek.year > currentYear}">
											<td title="${p.startWeek <= w.week && p.endWeek >= w.week? p.name:''  }" class="cust-td-col2 ${p.startWeek <= w.week && p.endWeek >= w.week? 'bg-color4':''  }"></td>
										</c:if>
									</c:forEach>
								</c:forEach>
							</tr>
						</c:forEach>
				</tbody>
			</table>
		</div>
	</div>
</body>
</html>